/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.config;

import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.echo.jira.JiraProperties;
import com.netflix.spinnaker.echo.jira.JiraService;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@ConditionalOnProperty(value={"jira.enabled"})
@EnableConfigurationProperties(value={JiraProperties.class})
public class JiraConfig {
    private static Logger LOGGER = LoggerFactory.getLogger(JiraConfig.class);
    @Autowired(required=false)
    private OkHttpClient x509ConfiguredClient;

    @Bean
    JiraService jiraService(JiraProperties jiraProperties, OkHttp3ClientConfiguration okHttpClientConfig) {
        OkHttpClient okHttpClient;
        if (this.x509ConfiguredClient != null) {
            LOGGER.info("Using X509 Cert for Jira Client");
            okHttpClient = this.x509ConfiguredClient;
        } else {
            String credentials = String.format("%s:%s", jiraProperties.getUsername(), jiraProperties.getPassword());
            String basic = String.format("Basic %s", Base64.encodeBase64String((byte[])credentials.getBytes()));
            BasicAuthRequestInterceptor interceptor = new BasicAuthRequestInterceptor(basic);
            okHttpClient = okHttpClientConfig.createForRetrofit2().addInterceptor((Interceptor)interceptor).build();
        }
        return (JiraService)new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)jiraProperties.getBaseUrl())).client(okHttpClient).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(JiraService.class);
    }

    private static class BasicAuthRequestInterceptor
    implements Interceptor {
        private final String basic;

        public BasicAuthRequestInterceptor(String basic) {
            this.basic = basic;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request().newBuilder().addHeader("Authorization", this.basic).addHeader("Accept", "application/json").build();
            return chain.proceed(request);
        }
    }
}

