/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.config;

import com.netflix.spinnaker.config.DefaultServiceEndpoint;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.echo.notification.DryRunNotificationAgent;
import com.netflix.spinnaker.echo.pipelinetriggers.orca.OrcaService;
import com.netflix.spinnaker.echo.services.Front50Service;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@EnableConfigurationProperties(value={DryRunProperties.class})
@ConditionalOnProperty(value={"dryrun.enabled"})
public class DryRunConfig {
    private static final Logger log = LoggerFactory.getLogger(DryRunConfig.class);

    @Bean
    DryRunNotificationAgent dryRunNotificationAgent(Front50Service front50, OkHttpClientProvider clientProvider, DryRunProperties properties) {
        log.info("Pipeline dry runs will execute at {}", (Object)properties.getBaseUrl());
        OrcaService orca = (OrcaService)new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)properties.getBaseUrl())).client(clientProvider.getClient((ServiceEndpoint)new DefaultServiceEndpoint("orca", properties.getBaseUrl()))).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OrcaService.class);
        return new DryRunNotificationAgent(front50, orca, properties);
    }

    @ConfigurationProperties(value="dryrun")
    public static class DryRunProperties {
        String baseUrl;
        List<Notification> notifications;

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public List<Notification> getNotifications() {
            return this.notifications;
        }

        public DryRunProperties setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public DryRunProperties setNotifications(List<Notification> notifications) {
            this.notifications = notifications;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DryRunProperties)) {
                return false;
            }
            DryRunProperties other = (DryRunProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
                return false;
            }
            List<Notification> this$notifications = this.getNotifications();
            List<Notification> other$notifications = other.getNotifications();
            return !(this$notifications == null ? other$notifications != null : !((Object)this$notifications).equals(other$notifications));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DryRunProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            List<Notification> $notifications = this.getNotifications();
            result = result * 59 + ($notifications == null ? 43 : ((Object)$notifications).hashCode());
            return result;
        }

        public String toString() {
            return "DryRunConfig.DryRunProperties(baseUrl=" + this.getBaseUrl() + ", notifications=" + String.valueOf(this.getNotifications()) + ")";
        }
    }

    public static class Notification {
        String type;
        String address;
        String level;
        List<String> when;

        public String getType() {
            return this.type;
        }

        public String getAddress() {
            return this.address;
        }

        public String getLevel() {
            return this.level;
        }

        public List<String> getWhen() {
            return this.when;
        }

        public Notification setType(String type) {
            this.type = type;
            return this;
        }

        public Notification setAddress(String address) {
            this.address = address;
            return this;
        }

        public Notification setLevel(String level) {
            this.level = level;
            return this;
        }

        public Notification setWhen(List<String> when) {
            this.when = when;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Notification)) {
                return false;
            }
            Notification other = (Notification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$level = this.getLevel();
            String other$level = other.getLevel();
            if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
                return false;
            }
            List<String> this$when = this.getWhen();
            List<String> other$when = other.getWhen();
            return !(this$when == null ? other$when != null : !((Object)this$when).equals(other$when));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Notification;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : $level.hashCode());
            List<String> $when = this.getWhen();
            result = result * 59 + ($when == null ? 43 : ((Object)$when).hashCode());
            return result;
        }

        public String toString() {
            return "DryRunConfig.Notification(type=" + this.getType() + ", address=" + this.getAddress() + ", level=" + this.getLevel() + ", when=" + String.valueOf(this.getWhen()) + ")";
        }
    }
}

