/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.cdevents;

import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.cdevents.BaseCDEvent;
import com.netflix.spinnaker.echo.cdevents.CDEventPipelineRunFinished;
import com.netflix.spinnaker.echo.cdevents.CDEventPipelineRunQueued;
import com.netflix.spinnaker.echo.cdevents.CDEventPipelineRunStarted;
import com.netflix.spinnaker.echo.cdevents.CDEventTaskRunFinished;
import com.netflix.spinnaker.echo.cdevents.CDEventTaskRunStarted;
import com.netflix.spinnaker.echo.exceptions.FieldNotFoundException;
import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.exception.CDEventsException;
import io.cloudevents.CloudEvent;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CDEventsBuilderService {
    private static final Logger log = LoggerFactory.getLogger(CDEventsBuilderService.class);

    public CloudEvent createCDEvent(Map<String, Object> preference, String application, Event event, Map<String, String> config, String status, String spinnakerUrl) {
        String configType = Optional.ofNullable(config).map(c -> (String)c.get("type")).orElseThrow(() -> new FieldNotFoundException("type"));
        String configLink = Optional.ofNullable(config).map(c -> (String)c.get("link")).orElseThrow(() -> new FieldNotFoundException("link"));
        String executionId = Optional.ofNullable(event.content).map(e -> (Map)e.get("execution")).map(e -> (String)e.get("id")).orElseThrow(() -> new FieldNotFoundException("execution.id"));
        String executionUrl = String.format("%s/#/applications/%s/%s/%s", spinnakerUrl, application, configType == "stage" ? "executions/details" : configLink, executionId);
        String executionName = Optional.ofNullable(event.content).map(e -> (Map)e.get("execution")).map(e -> (String)e.get("name")).orElseThrow(() -> new FieldNotFoundException("execution.name"));
        String cdEventsType = Optional.ofNullable(preference).map(p -> (String)p.get("cdEventsType")).orElseThrow(() -> new FieldNotFoundException("notifications.cdEventsType"));
        Map customData = Optional.ofNullable(preference).map(p -> (Map)p.get("customData")).orElseGet(() -> Optional.ofNullable(event.content).map(e -> (Map)e.get("context")).map(ctx -> (Map)ctx.get("customData")).orElseGet(Collections::emptyMap));
        log.info("Event type {} received to create CDEvent.", (Object)cdEventsType);
        Map<String, CDEventTaskRunFinished> cdEventsMap = Map.of(CDEventConstants.CDEventTypes.PipelineRunQueuedEvent.getEventType(), new CDEventPipelineRunQueued(executionId, executionUrl, executionName, spinnakerUrl, customData), CDEventConstants.CDEventTypes.PipelineRunStartedEvent.getEventType(), new CDEventPipelineRunStarted(executionId, executionUrl, executionName, spinnakerUrl, customData), CDEventConstants.CDEventTypes.PipelineRunFinishedEvent.getEventType(), new CDEventPipelineRunFinished(executionId, executionUrl, executionName, spinnakerUrl, status, customData), CDEventConstants.CDEventTypes.TaskRunStartedEvent.getEventType(), new CDEventTaskRunStarted(executionId, executionUrl, executionName, spinnakerUrl, customData), CDEventConstants.CDEventTypes.TaskRunFinishedEvent.getEventType(), new CDEventTaskRunFinished(executionId, executionUrl, executionName, spinnakerUrl, status, customData));
        BaseCDEvent cdEvent = cdEventsMap.keySet().stream().filter(keyType -> keyType.contains(cdEventsType)).map(cdEventsMap::get).findFirst().orElseThrow(() -> {
            log.error("No mapping event type found for {}", (Object)cdEventsType);
            log.error("The event type should be an event or substring of an event from the list of event types {}", cdEventsMap.keySet());
            return new CDEventsException("No mapping eventType found to create CDEvent");
        });
        return cdEvent.createCDEvent();
    }
}

