/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.cdevents;

import com.netflix.spinnaker.echo.cdevents.BaseCDEvent;
import dev.cdevents.CDEvents;
import dev.cdevents.events.TaskrunStartedCDEvent;
import dev.cdevents.models.CDEvent;
import io.cloudevents.CloudEvent;
import java.net.URI;

public class CDEventTaskRunStarted
extends BaseCDEvent {
    private String subjectTaskName;
    private String subjectPipelineRunId;
    private Object customData;

    public CDEventTaskRunStarted(String executionId, String executionUrl, String executionName, String spinnakerUrl, Object customData) {
        super(spinnakerUrl, executionId, spinnakerUrl, executionUrl);
        this.subjectTaskName = executionName;
        this.subjectPipelineRunId = executionId;
        this.customData = customData;
    }

    @Override
    public CloudEvent createCDEvent() {
        TaskrunStartedCDEvent cdEvent = new TaskrunStartedCDEvent();
        cdEvent.setSource(URI.create(this.getSource()));
        cdEvent.setSubjectId(this.getSubjectId());
        cdEvent.setSubjectSource(URI.create(this.getSubjectSource()));
        cdEvent.setSubjectTaskName(this.getSubjectTaskName());
        cdEvent.setSubjectUrl(URI.create(this.getSubjectUrl()).toString());
        cdEvent.setSubjectPipelineRunId(this.getSubjectPipelineRunId());
        cdEvent.setCustomData(this.customData);
        return CDEvents.cdEventAsCloudEvent((CDEvent)cdEvent);
    }

    public String getSubjectTaskName() {
        return this.subjectTaskName;
    }

    public String getSubjectPipelineRunId() {
        return this.subjectPipelineRunId;
    }

    public Object getCustomData() {
        return this.customData;
    }
}

