/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.cdevents;

import com.netflix.spinnaker.echo.cdevents.BaseCDEvent;
import dev.cdevents.CDEvents;
import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.events.TaskrunFinishedCDEvent;
import dev.cdevents.models.CDEvent;
import io.cloudevents.CloudEvent;
import java.net.URI;

public class CDEventTaskRunFinished
extends BaseCDEvent {
    private String subjectTaskName;
    private String subjectPipelineRunId;
    private String subjectError;
    private Object customData;

    public CDEventTaskRunFinished(String executionId, String executionUrl, String executionName, String spinnakerUrl, String status, Object customData) {
        super(spinnakerUrl, executionId, spinnakerUrl, executionUrl);
        this.subjectTaskName = executionName;
        this.subjectPipelineRunId = executionId;
        this.subjectError = status;
        this.customData = customData;
    }

    @Override
    public CloudEvent createCDEvent() {
        TaskrunFinishedCDEvent cdEvent = new TaskrunFinishedCDEvent();
        cdEvent.setSource(URI.create(this.getSource()));
        cdEvent.setSubjectId(this.getSubjectId());
        cdEvent.setSubjectSource(URI.create(this.getSubjectSource()));
        cdEvent.setSubjectTaskName(this.getSubjectTaskName());
        cdEvent.setSubjectUrl(URI.create(this.getSubjectUrl()).toString());
        cdEvent.setSubjectErrors(this.getSubjectError());
        cdEvent.setSubjectPipelineRunId(this.getSubjectPipelineRunId());
        if ("complete".equals(this.getSubjectError())) {
            cdEvent.setSubjectOutcome(CDEventConstants.Outcome.SUCCESS.getOutcome());
        } else if ("failed".equals(this.getSubjectError())) {
            cdEvent.setSubjectOutcome(CDEventConstants.Outcome.FAILURE.getOutcome());
        }
        cdEvent.setCustomData(this.customData);
        return CDEvents.cdEventAsCloudEvent((CDEvent)cdEvent);
    }

    public String getSubjectTaskName() {
        return this.subjectTaskName;
    }

    public String getSubjectPipelineRunId() {
        return this.subjectPipelineRunId;
    }

    public String getSubjectError() {
        return this.subjectError;
    }

    public Object getCustomData() {
        return this.customData;
    }
}

