/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.slack;

import com.netflix.spinnaker.echo.config.SlackAppProperties;
import com.netflix.spinnaker.echo.slack.SlackClient;
import com.netflix.spinnaker.echo.slack.SlackService;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.ToString;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.security.InvalidKeyException;
import java.time.Duration;
import java.time.Instant;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.RequestEntity;

@ToString
@EqualsAndHashCode
public class SlackAppService
extends SlackService {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public SlackAppService(SlackClient client, SlackAppProperties config) {
        super(client, config);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void verifySignature(RequestEntity<String> request, boolean preventReplays) {
        CallSite headers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getHeaders", 0, request));
        CallSite body = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getBody", 0, request));
        CallSite timestamp = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "getAt", 0, headers, "X-Slack-Request-Timestamp")));
        CallSite signature = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "getAt", 0, headers, "X-Slack-Signature")));
        if (preventReplays && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isBefore", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "ofEpochSecond", 0, Instant.class, IndyInterface.bootstrap("invoke", "valueOf", 0, Long.class, timestamp)), IndyInterface.bootstrap("invoke", "ofMinutes", 0, Duration.class, 5)), IndyInterface.bootstrap("invoke", "now", 0, Instant.class)))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, "Slack request timestamp is older than 5 minutes. Replay attack?"));
        }
        CallSite calculatedSignature = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateSignature", 2, this, timestamp, body));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)calculatedSignature, (Object)signature)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, "Invalid Slack signature header."));
        }
    }

    public String calculateSignature(String timestamp, String body, String version) {
        body = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, body, "\\*", "%2A"));
        CallSite signatureBaseString = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{version, timestamp, body}, new String[]{"", ":", ":", ""}));
        CallSite mac = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstance", 0, Mac.class, "HmacSHA256"));
        CallSite secretKeySpec = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SecretKeySpec.class, IndyInterface.bootstrap("invoke", "getBytes", 0, IndyInterface.bootstrap("getProperty", "signingSecret", 4, IndyInterface.bootstrap("getProperty", "config", 12, this))), "HmacSHA256"));
        IndyInterface.bootstrap("invoke", "init", 0, mac, secretKeySpec);
        CallSite digest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "doFinal", 0, mac, IndyInterface.bootstrap("invoke", "getBytes", 0, signatureBaseString)));
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{version, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "encodeHex", 0, Hex.class, digest))}, new String[]{"", "=", ""}));
        try {
            return callSite;
        }
        catch (InvalidKeyException e) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, "Invalid key exception verifying Slack request signature."));
        }
    }

    public void verifyToken(String receivedToken) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)receivedToken, (Object)IndyInterface.bootstrap("getProperty", "verificationToken", 4, IndyInterface.bootstrap("getProperty", "config", 12, this)))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, "Token received from Slack does not match verification token."));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SlackAppService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    public String toString() {
        CallSite _result = IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class);
        Boolean $toStringFirst = Boolean.TRUE;
        IndyInterface.bootstrap("invoke", "append", 0, _result, "com.netflix.spinnaker.echo.slack.SlackAppService(");
        IndyInterface.bootstrap("invoke", "append", 0, _result, ")");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, _result));
    }

    @Override
    @Generated
    public int hashCode() {
        CallSite _result = IndyInterface.bootstrap("invoke", "initHash", 0, HashCodeHelper.class);
        return DefaultTypeTransformation.intUnbox((Object)_result);
    }

    @Override
    @Generated
    public boolean canEqual(Object other) {
        return other instanceof SlackAppService;
    }

    @Override
    @Generated
    public boolean equals(Object other) {
        if (ScriptBytecodeAdapter.compareEqual(null, (Object)other)) {
            return false;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 2, this, other)) != false) {
            return true;
        }
        if (!(other instanceof SlackAppService)) {
            return false;
        }
        SlackAppService otherTyped = (SlackAppService)other;
        return !(IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "canEqual", 0, otherTyped, this)) == false);
    }

    @Generated
    public void verifySignature(RequestEntity<String> request) {
        this.verifySignature(request, true);
    }

    @Generated
    public String calculateSignature(String timestamp, String body) {
        return this.calculateSignature(timestamp, body, "v0");
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.echo.slack.SlackAppService");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public /* synthetic */ boolean super$2$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ String super$2$toString() {
        return super.toString();
    }

    public /* synthetic */ int super$2$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ boolean super$2$canEqual(Object object) {
        return super.canEqual(object);
    }
}

