/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.jira;

import com.netflix.spinnaker.echo.controller.EchoResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface JiraService {
    @POST(value="rest/api/2/issue/")
    public Call<CreateIssueResponse> createIssue(@Body CreateIssueRequest var1);

    @GET(value="rest/api/2/issue/{issueIdOrKey}/transitions")
    public Call<IssueTransitions> getIssueTransitions(@Path(value="issueIdOrKey") String var1);

    @POST(value="rest/api/2/issue/{issueIdOrKey}/transitions")
    public Call<ResponseBody> transitionIssue(@Path(value="issueIdOrKey") String var1, @Body TransitionIssueRequest var2);

    @POST(value="rest/api/2/issue/{issueIdOrKey}/comment")
    public Call<ResponseBody> addComment(@Path(value="issueIdOrKey") String var1, @Body CommentIssueRequest var2);

    public static class CreateIssueResponse
    implements EchoResponse.EchoResult {
        private String id;
        private String key;
        private String self;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getSelf() {
            return this.self;
        }

        public void setSelf(String self) {
            this.self = self;
        }
    }

    public static class IssueTransitions {
        private List<Transition> transitions;

        public List<Transition> getTransitions() {
            return this.transitions;
        }

        public void setTransitions(List<Transition> transitions) {
            this.transitions = transitions;
        }

        public static class Transition {
            private String id;
            private String name;

            public String getId() {
                return this.id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }

    public static class CommentIssueRequest {
        private String body;

        CommentIssueRequest(String body) {
            this.body = body;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }
    }

    public static class TransitionIssueRequest
    extends HashMap<String, Object> {
        TransitionIssueRequest(Map<String, Object> body) {
            super(body);
        }
    }

    public static class CreateIssueRequest
    extends HashMap<String, Object> {
        CreateIssueRequest(Map<String, Object> body) {
            super(body);
        }
    }
}

