/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.jira;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.echo.api.Notification;
import com.netflix.spinnaker.echo.controller.EchoResponse;
import com.netflix.spinnaker.echo.jira.JiraService;
import com.netflix.spinnaker.echo.notification.NotificationService;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.logstash.logback.argument.StructuredArguments;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseStatus;

@Component
@ConditionalOnProperty(value={"jira.enabled"})
public class JiraNotificationService
implements NotificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraNotificationService.class);
    private static final int MAX_RETRY = 3;
    private static final long RETRY_BACKOFF = 100L;
    private final JiraService jiraService;
    private final RetrySupport retrySupport;
    private final ObjectMapper mapper;

    @Autowired
    public JiraNotificationService(JiraService jiraService, RetrySupport retrySupport, ObjectMapper objectMapper) {
        this.jiraService = jiraService;
        this.retrySupport = retrySupport;
        this.mapper = objectMapper;
    }

    @Override
    public boolean supportsType(String type) {
        return "JIRA".equalsIgnoreCase(type);
    }

    @Override
    public EchoResponse handle(Notification notification) {
        return this.isTransition(notification) ? this.transitionIssue(notification) : this.create(notification);
    }

    private boolean isTransition(Notification notification) {
        return notification.getAdditionalContext().get("transitionContext") != null;
    }

    private EchoResponse.Void transitionIssue(Notification notification) {
        TransitionJiraNotification transitionNotification = (TransitionJiraNotification)this.mapper.convertValue(notification.getAdditionalContext(), TransitionJiraNotification.class);
        String jiraIssue = transitionNotification.getJiraIssue();
        try {
            Map<String, String> transition = transitionNotification.getTransitionContext().getTransition();
            Map<String, Object> transitionDetails = transitionNotification.getTransitionContext().getTransitionDetails();
            String transitionName = transition.get("name");
            JiraService.IssueTransitions issueTransitions = (JiraService.IssueTransitions)this.retrySupport.retry(this.getIssueTransitions(jiraIssue), 3, 100L, false);
            issueTransitions.getTransitions().stream().filter(it -> it.getName().equals(transitionName)).findFirst().ifPresentOrElse(t -> {
                transition.put("id", t.getId());
                transitionDetails.put("transition", transition);
            }, () -> {
                throw new IllegalArgumentException(ImmutableMap.of((Object)"issue", (Object)jiraIssue, (Object)"transitionName", (Object)transitionName, (Object)"validTransitionNames", issueTransitions.getTransitions().stream().map(JiraService.IssueTransitions.Transition::getName).collect(Collectors.toList())).toString());
            });
            this.retrySupport.retry(this.transitionIssue(jiraIssue, transitionDetails), 3, 100L, false);
            if (transitionNotification.getComment() != null) {
                this.retrySupport.retry(this.addComment(jiraIssue, transitionNotification.getComment()), 3, 100L, false);
            }
            return new EchoResponse.Void();
        }
        catch (Exception e) {
            throw new TransitionJiraIssueException(String.format("Failed to transition Jira issue %s: %s", jiraIssue, this.errors(e)), e);
        }
    }

    private EchoResponse<JiraService.CreateIssueResponse> create(Notification notification) {
        Map<String, Object> issueRequestBody = this.issueRequestBody(notification);
        try {
            JiraService.CreateIssueResponse response = (JiraService.CreateIssueResponse)this.retrySupport.retry(this.createIssue(issueRequestBody), 3, 100L, false);
            return new EchoResponse<JiraService.CreateIssueResponse>(response);
        }
        catch (Exception e) {
            throw new CreateJiraIssueException(String.format("Failed to create Jira Issue %s: %s", StructuredArguments.kv((String)"issueRequestBody", issueRequestBody), this.errors(e)), e);
        }
    }

    private Supplier<JiraService.IssueTransitions> getIssueTransitions(String issueIdOrKey) {
        return () -> (JiraService.IssueTransitions)Retrofit2SyncCall.execute(this.jiraService.getIssueTransitions(issueIdOrKey));
    }

    private Supplier<ResponseBody> transitionIssue(String issueIdOrKey, Map<String, Object> transitionDetails) {
        return () -> (ResponseBody)Retrofit2SyncCall.execute(this.jiraService.transitionIssue(issueIdOrKey, new JiraService.TransitionIssueRequest(transitionDetails)));
    }

    private Supplier<ResponseBody> addComment(String issueIdOrKey, String comment) {
        return () -> (ResponseBody)Retrofit2SyncCall.execute(this.jiraService.addComment(issueIdOrKey, new JiraService.CommentIssueRequest(comment)));
    }

    private Supplier<JiraService.CreateIssueResponse> createIssue(Map<String, Object> issueRequestBody) {
        return () -> (JiraService.CreateIssueResponse)Retrofit2SyncCall.execute(this.jiraService.createIssue(new JiraService.CreateIssueRequest(issueRequestBody)));
    }

    private Map<String, Object> issueRequestBody(Notification notification) {
        Map issue = (Map)notification.getAdditionalContext().get("issueContext");
        Optional.ofNullable((Map)issue.get("details")).ifPresent(i -> i.forEach(issue::put));
        issue.remove("details");
        return issue;
    }

    private Map errors(Exception exception) {
        if (exception instanceof SpinnakerHttpException) {
            return ((SpinnakerHttpException)exception).getResponseBody();
        }
        return ImmutableMap.of((Object)"errors", (Object)exception.getMessage());
    }

    static class TransitionJiraNotification {
        private String jiraIssue;
        private String comment;
        private TransitionContext transitionContext;

        TransitionJiraNotification() {
        }

        public String getJiraIssue() {
            return this.jiraIssue;
        }

        public void setJiraIssue(String jiraIssue) {
            this.jiraIssue = jiraIssue;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public TransitionContext getTransitionContext() {
            return this.transitionContext;
        }

        public void setTransitionContext(TransitionContext transitionContext) {
            this.transitionContext = transitionContext;
        }

        static class TransitionContext {
            private Map<String, String> transition;
            private Map<String, Object> transitionDetails = new HashMap<String, Object>();

            TransitionContext() {
            }

            public Map<String, String> getTransition() {
                return this.transition;
            }

            public void setTransition(Map<String, String> transition) {
                this.transition = transition;
            }

            public Map<String, Object> getTransitionDetails() {
                return this.transitionDetails;
            }

            @JsonAnySetter
            public void setTransitionDetails(String name, Object value) {
                this.transitionDetails.put(name, value);
            }
        }
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    static class TransitionJiraIssueException
    extends RuntimeException {
        public TransitionJiraIssueException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    static class CreateJiraIssueException
    extends RuntimeException {
        public CreateJiraIssueException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

