/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.controller;

import com.netflix.spinnaker.echo.api.Notification;
import com.netflix.spinnaker.echo.api.events.NotificationAgent;
import com.netflix.spinnaker.echo.controller.EchoResponse;
import com.netflix.spinnaker.echo.notification.InteractiveNotificationCallbackHandler;
import com.netflix.spinnaker.echo.notification.InteractiveNotificationService;
import com.netflix.spinnaker.echo.notification.NotificationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/notifications"})
@RestController
public class NotificationController {
    @Autowired(required=false)
    Collection<NotificationService> notificationServices;
    @Autowired
    private InteractiveNotificationCallbackHandler interactiveNotificationCallbackHandler;
    @Autowired
    Optional<List<NotificationAgent>> notificationAgents;

    @RequestMapping(method={RequestMethod.POST})
    public EchoResponse create(@RequestBody Notification notification) {
        Optional<NotificationService> notificationService = this.notificationServices.stream().filter(it -> it.supportsType(notification.getNotificationType()) && (it instanceof InteractiveNotificationService ? notification.isInteractive() : !notification.isInteractive())).findFirst();
        return notificationService.map(ns -> ns.handle(notification)).orElse(null);
    }

    @RequestMapping(value={"/callbacks/{source}"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"}, produces={"application/json"})
    public ResponseEntity<String> processCallback(@PathVariable String source, RequestEntity<String> request) {
        return this.interactiveNotificationCallbackHandler.processCallback(source, request);
    }

    @GetMapping(value={"/metadata"})
    public List<NotificationAgent> getNotificationTypeMetadata() {
        return this.notificationAgents.orElseGet(ArrayList::new);
    }

    public NotificationController(Collection<NotificationService> notificationServices, InteractiveNotificationCallbackHandler interactiveNotificationCallbackHandler, Optional<List<NotificationAgent>> notificationAgents) {
        this.notificationServices = notificationServices;
        this.interactiveNotificationCallbackHandler = interactiveNotificationCallbackHandler;
        this.notificationAgents = notificationAgents;
    }
}

