/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.config;

import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.echo.config.PagerDutyConfigurationProperties;
import com.netflix.spinnaker.echo.pagerduty.PagerDutyService;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@EnableConfigurationProperties(value={PagerDutyConfigurationProperties.class})
@ConditionalOnProperty(value={"pager-duty.enabled"})
public class PagerDutyConfig {
    private static final Logger log = LoggerFactory.getLogger(PagerDutyConfig.class);

    @Bean
    PagerDutyService pagerDutyService(OkHttp3ClientConfiguration okHttpClientConfig, PagerDutyConfigurationProperties pagerDutyProps) {
        log.info("Pager Duty service loaded");
        return (PagerDutyService)new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)pagerDutyProps.getEndpoint())).client(okHttpClientConfig.createForRetrofit2().build()).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(PagerDutyService.class);
    }
}

