/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.cdevents;

import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.echo.cdevents.CDEventsConverterFactory;
import com.netflix.spinnaker.echo.cdevents.CDEventsSenderClient;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

@Component
public class CDEventsSenderService {
    private static final Logger log = LoggerFactory.getLogger(CDEventsSenderService.class);
    private OkHttp3ClientConfiguration okHttpClientConfig;

    public CDEventsSenderService(OkHttp3ClientConfiguration okHttpClientConfig) {
        this.okHttpClientConfig = okHttpClientConfig;
    }

    public retrofit2.Response<ResponseBody> sendCDEvent(CloudEvent cdEvent, String eventsBrokerUrl) {
        CDEventsConverterFactory converterFactory = CDEventsConverterFactory.create();
        RequestInterceptor authInterceptor = new RequestInterceptor(cdEvent);
        CDEventsSenderClient cdEventsSenderClient = (CDEventsSenderClient)new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)this.getEndpointUrl(eventsBrokerUrl))).client(this.okHttpClientConfig.createForRetrofit2().addInterceptor((Interceptor)authInterceptor).build()).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)converterFactory).build().create(CDEventsSenderClient.class);
        String jsonEvent = converterFactory.convertCDEventToJson(cdEvent);
        log.info("Sending CDEvent Json {} ", (Object)jsonEvent);
        return (retrofit2.Response)Retrofit2SyncCall.execute(cdEventsSenderClient.sendCDEvent(jsonEvent, this.getRelativePath(eventsBrokerUrl)));
    }

    private String getEndpointUrl(String webhookUrl) {
        try {
            URL url = new URL(webhookUrl);
            String endPointURL = url.getPort() != -1 ? url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() : url.getProtocol() + "://" + url.getHost();
            log.info("Endpoint Url to send CDEvent {} ", (Object)endPointURL);
            return endPointURL;
        }
        catch (MalformedURLException e) {
            throw new InvalidRequestException("Unable to determine CloudEvents broker address.", (Throwable)e);
        }
    }

    private String getRelativePath(String webhookUrl) {
        String relativePath = "";
        try {
            URL url = new URL(webhookUrl);
            relativePath = url.getPath();
            if (StringUtils.isEmpty((CharSequence)relativePath)) {
                throw new MalformedURLException();
            }
        }
        catch (MalformedURLException e) {
            throw new InvalidRequestException("Unable to determine URL from CloudEvents broker address.", (Throwable)e);
        }
        if (relativePath.charAt(0) == '/') {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    private static class RequestInterceptor
    implements Interceptor {
        private CloudEvent cdEvent;

        public RequestInterceptor(CloudEvent cdEvent) {
            this.cdEvent = cdEvent;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder builder = chain.request().newBuilder().addHeader("Ce-Id", this.cdEvent.getId());
            this.cdEvent.getSpecVersion();
            Request request = builder.addHeader("Ce-Specversion", SpecVersion.V1.toString()).addHeader("Ce-Source", this.cdEvent.getSource().toString()).addHeader("Ce-Type", this.cdEvent.getType()).addHeader("Content-Type", "application/json").build();
            return chain.proceed(request);
        }
    }
}

