/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.cdevents;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import io.cloudevents.CloudEvent;
import io.cloudevents.jackson.JsonFormat;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class CDEventsConverterFactory
extends Converter.Factory {
    private final ObjectMapper objectMapper;

    public CDEventsConverterFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static CDEventsConverterFactory create() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)JsonFormat.getCloudEventJacksonModule());
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        return new CDEventsConverterFactory(objectMapper);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        return value -> {
            try (ResponseBody responseBody = value;){
                JavaType javaType = this.objectMapper.getTypeFactory().constructType(type);
                Object object = this.objectMapper.readValue(value.charStream(), javaType);
                return object;
            }
        };
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return value -> {
            try {
                String json = this.objectMapper.writeValueAsString(value);
                return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
            }
            catch (JsonProcessingException e) {
                throw new IOException("Failed to serialize object to JSON", e);
            }
        };
    }

    public String convertCDEventToJson(CloudEvent cdEvent) {
        try {
            return this.objectMapper.writeValueAsString((Object)cdEvent);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Unable to convert CDEvent to Json format.", (Throwable)e);
        }
    }
}

