/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.cdevents;

import com.netflix.spinnaker.echo.cdevents.BaseCDEvent;
import dev.cdevents.CDEvents;
import dev.cdevents.events.PipelinerunStartedCDEvent;
import dev.cdevents.models.CDEvent;
import io.cloudevents.CloudEvent;
import java.net.URI;

public class CDEventPipelineRunStarted
extends BaseCDEvent {
    private String subjectPipelineName;
    private Object customData;

    public CDEventPipelineRunStarted(String executionId, String executionUrl, String executionName, String spinnakerUrl, Object customData) {
        super(spinnakerUrl, executionId, spinnakerUrl, executionUrl);
        this.subjectPipelineName = executionName;
        this.customData = customData;
    }

    @Override
    public CloudEvent createCDEvent() {
        PipelinerunStartedCDEvent cdEvent = new PipelinerunStartedCDEvent();
        cdEvent.setSource(URI.create(this.getSource()));
        cdEvent.setSubjectId(this.getSubjectId());
        cdEvent.setSubjectSource(URI.create(this.getSubjectSource()));
        cdEvent.setSubjectPipelineName(this.getSubjectPipelineName());
        cdEvent.setSubjectUrl(URI.create(this.getSubjectUrl()).toString());
        cdEvent.setCustomData(this.customData);
        return CDEvents.cdEventAsCloudEvent((CDEvent)cdEvent);
    }

    public String getSubjectPipelineName() {
        return this.subjectPipelineName;
    }

    public Object getCustomData() {
        return this.customData;
    }
}

