/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.cdevents;

import com.netflix.spinnaker.echo.cdevents.BaseCDEvent;
import dev.cdevents.CDEvents;
import dev.cdevents.constants.CDEventConstants;
import dev.cdevents.events.PipelinerunFinishedCDEvent;
import dev.cdevents.models.CDEvent;
import io.cloudevents.CloudEvent;
import java.net.URI;

public class CDEventPipelineRunFinished
extends BaseCDEvent {
    private String subjectPipelineName;
    private String subjectError;
    private Object customData;

    public CDEventPipelineRunFinished(String executionId, String executionUrl, String executionName, String spinnakerUrl, String status, Object customData) {
        super(spinnakerUrl, executionId, spinnakerUrl, executionUrl);
        this.subjectPipelineName = executionName;
        this.subjectError = status;
        this.customData = customData;
    }

    @Override
    public CloudEvent createCDEvent() {
        PipelinerunFinishedCDEvent cdEvent = new PipelinerunFinishedCDEvent();
        cdEvent.setSource(URI.create(this.getSource()));
        cdEvent.setSubjectId(this.getSubjectId());
        cdEvent.setSubjectSource(URI.create(this.getSubjectSource()));
        cdEvent.setSubjectPipelineName(this.getSubjectPipelineName());
        cdEvent.setSubjectUrl(URI.create(this.getSubjectUrl()).toString());
        cdEvent.setSubjectErrors(this.getSubjectError());
        if ("complete".equals(this.getSubjectError())) {
            cdEvent.setSubjectOutcome(CDEventConstants.Outcome.SUCCESS.getOutcome());
        } else if ("failed".equals(this.getSubjectError())) {
            cdEvent.setSubjectOutcome(CDEventConstants.Outcome.FAILURE.getOutcome());
        }
        cdEvent.setCustomData(this.customData);
        return CDEvents.cdEventAsCloudEvent((CDEvent)cdEvent);
    }

    public String getSubjectPipelineName() {
        return this.subjectPipelineName;
    }

    public String getSubjectError() {
        return this.subjectError;
    }

    public Object getCustomData() {
        return this.customData;
    }
}

