/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.notification;

import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.microsoftteams.MicrosoftTeamsMessage;
import com.netflix.spinnaker.echo.microsoftteams.MicrosoftTeamsService;
import com.netflix.spinnaker.echo.microsoftteams.api.MicrosoftTeamsSection;
import com.netflix.spinnaker.echo.notification.AbstractEventNotificationAgent;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(value={"microsoftteams.enabled"})
@Service
public class MicrosoftTeamsNotificationAgent
extends AbstractEventNotificationAgent {
    private static final Logger log = LoggerFactory.getLogger(MicrosoftTeamsNotificationAgent.class);
    private final MicrosoftTeamsService teamsService;

    @Autowired
    public MicrosoftTeamsNotificationAgent(MicrosoftTeamsService teamsService) {
        this.teamsService = teamsService;
    }

    public String getNotificationType() {
        return "microsoftteams";
    }

    public void sendNotifications(Map<String, Object> preference, String application, Event event, Map<String, String> config, String status) {
        Object summary;
        log.info("Building Microsoft Teams notification");
        String configType = Optional.ofNullable(config).map(c -> (String)c.get("type")).orElse(null);
        String configLink = Optional.ofNullable(config).map(c -> (String)c.get("link")).orElse(null);
        Map context = Optional.ofNullable(event.content).map(e -> (Map)e.get("context")).orElse(null);
        String cardTitle = String.format("%s %s for %s", WordUtils.capitalize((String)configType), status, application.toUpperCase());
        String eventName = "";
        String executionId = Optional.ofNullable(event.content).map(e -> (Map)e.get("execution")).map(e -> (String)e.get("id")).orElse(null);
        String executionUrl = String.format("%s/#/applications/%s/%s/%s", this.getSpinnakerUrl(), application, configType == "stage" ? "executions/details" : configLink, executionId);
        String executionDescription = Optional.ofNullable(event.content).map(e -> (Map)e.get("execution")).map(e -> (String)e.get("description")).orElse(null);
        String executionName = Optional.ofNullable(event.content).map(e -> (Map)e.get("execution")).map(e -> (String)e.get("name")).orElse(null);
        String message = Optional.ofNullable(preference).map(p -> (Map)p.get("message")).map(p -> (Map)p.get(configType + "." + status)).map(p -> (String)p.get("text")).orElse(null);
        if (configType == "stage") {
            eventName = Optional.ofNullable(event.content).map(e -> (String)e.get("name")).orElse(null);
            String stageName = Optional.ofNullable(context).map(c -> (Map)c.get("stageDetails")).map(c -> (String)c.get("name")).orElse(null);
            eventName = eventName != null ? eventName : stageName;
            summary = String.format("Stage %s for %s's %s pipeline ", eventName, application, executionName);
        } else {
            summary = configType == "pipeline" ? String.format("%s's %s pipeline ", application, executionName) : String.format("%s's %s task ", application, executionId);
        }
        summary = (String)summary + (status.equalsIgnoreCase("starting") ? "is" : "has") + " " + (status.equalsIgnoreCase("complete") ? "completed successfully" : status);
        MicrosoftTeamsMessage teamsMessage = new MicrosoftTeamsMessage((String)summary, status);
        MicrosoftTeamsSection section = teamsMessage.createSection(configType, cardTitle);
        section.setApplicationName(application);
        section.setDescription(executionDescription);
        section.setExecutionName(executionName);
        section.setEventName(eventName);
        section.setMessage(message);
        section.setStatus(status);
        section.setSummary((String)summary);
        section.setPotentialAction(executionUrl, null);
        teamsMessage.addSection(section);
        log.info("Sending Microsoft Teams notification");
        String webhookUrl = Optional.ofNullable(preference).map(p -> (String)p.get("address")).orElse(null);
        ResponseBody response = this.teamsService.sendMessage(webhookUrl, teamsMessage);
        try {
            log.info("Received response from Microsoft Teams Webhook for execution id {}. {}", (Object)executionId, (Object)response.string());
        }
        catch (IOException e2) {
            log.info("Received response from Microsoft Teams Webhook for execution id {} but failed to deserialize", (Object)executionId);
        }
    }
}

