/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.notification;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.exceptions.FieldNotFoundException;
import com.netflix.spinnaker.echo.github.GithubCommit;
import com.netflix.spinnaker.echo.github.GithubService;
import com.netflix.spinnaker.echo.github.GithubStatus;
import com.netflix.spinnaker.echo.notification.AbstractEventNotificationAgent;
import com.netflix.spinnaker.echo.notification.EventContent;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerServerException;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import retrofit2.Response;

@ConditionalOnProperty(value={"github-status.enabled"})
@Service
public class GithubNotificationAgent
extends AbstractEventNotificationAgent {
    private static final Logger log = LoggerFactory.getLogger(GithubNotificationAgent.class);
    private ImmutableMap<String, String> STATUSES = ImmutableMap.of((Object)"starting", (Object)"pending", (Object)"complete", (Object)"success", (Object)"failed", (Object)"failure");
    private final RetrySupport retrySupport = new RetrySupport();
    private static final int MAX_RETRY = 5;
    private static final long RETRY_BACKOFF = 1000L;
    @Autowired
    private GithubService githubService;
    @Value(value="${github-status.token}")
    private String token;

    public void sendNotifications(Map preference, String application, Event event, Map config, String status) {
        String targetUrl;
        String context;
        String description;
        EventContent content;
        String forced_repo = Optional.ofNullable(preference).map(p -> (String)p.get("repo")).orElse(null);
        String forced_hash = Optional.ofNullable(preference).map(p -> (String)p.get("commit")).orElse(null);
        try {
            content = new EventContent(event, (String)config.get("type"), forced_repo, forced_hash);
        }
        catch (FieldNotFoundException e) {
            return;
        }
        String state = (String)this.STATUSES.get((Object)status);
        if (config.get("type").equals("stage")) {
            description = String.format("Stage '%s' in pipeline '%s' is %s", content.getStageName(), content.getPipeline(), status);
            context = String.format("stage/%s", content.getStageName());
            targetUrl = String.format("%s/#/applications/%s/executions/details/%s?pipeline=%s&stage=%d", this.getSpinnakerUrl(), application, content.getExecutionId(), content.getPipeline(), content.getStageIndex());
        } else if (config.get("type").equals("pipeline")) {
            description = String.format("Pipeline '%s' is %s", content.getPipeline(), status);
            context = String.format("pipeline/%s", content.getPipeline());
            targetUrl = String.format("%s/#/applications/%s/executions/details/%s?pipeline=%s", this.getSpinnakerUrl(), application, content.getExecutionId(), content.getPipeline());
        } else {
            return;
        }
        log.info(String.format("Sending Github status check for application: %s", application));
        String branchCommit = this.getBranchCommit(content.getRepo(), content.getSha());
        GithubStatus githubStatus = new GithubStatus(state, targetUrl, description, context);
        try {
            String repo = content.getRepo();
            this.retrySupport.retry(() -> (Response)Retrofit2SyncCall.execute(this.githubService.updateCheck("token " + this.token, repo, branchCommit, githubStatus)), 5, 1000L, false);
        }
        catch (Exception e) {
            log.error(String.format("Failed to send github status for application: '%s' pipeline: '%s', %s", application, content.getPipeline(), e));
        }
    }

    private String getBranchCommit(String repo, String sha) {
        GithubCommit message;
        try {
            message = (GithubCommit)Retrofit2SyncCall.execute(this.githubService.getCommit("token " + this.token, repo, sha));
        }
        catch (SpinnakerServerException e) {
            return sha;
        }
        Pattern pattern = Pattern.compile("Merge (?<branchCommit>[0-9a-f]{5,40}) into (?<masterCommit>[0-9a-f]{5,40})");
        Matcher matcher = pattern.matcher(message.getCommit().getMessage());
        if (matcher.matches()) {
            return matcher.group("branchCommit");
        }
        return sha;
    }

    public String getNotificationType() {
        return "githubStatus";
    }

    public GithubService getGithubService() {
        return this.githubService;
    }

    public void setGithubService(GithubService githubService) {
        this.githubService = githubService;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

