/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.notification;

import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.cdevents.CDEventsBuilderService;
import com.netflix.spinnaker.echo.cdevents.CDEventsSenderService;
import com.netflix.spinnaker.echo.exceptions.FieldNotFoundException;
import com.netflix.spinnaker.echo.notification.AbstractEventNotificationAgent;
import io.cloudevents.CloudEvent;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import retrofit2.Response;

@ConditionalOnProperty(value={"cdevents.enabled"})
@Service
public class CDEventsNotificationAgent
extends AbstractEventNotificationAgent {
    private static final Logger log = LoggerFactory.getLogger(CDEventsNotificationAgent.class);
    @Autowired
    CDEventsBuilderService cdEventsBuilderService;
    @Autowired
    CDEventsSenderService cdEventsSenderService;

    public String getNotificationType() {
        return "cdevents";
    }

    public void sendNotifications(Map<String, Object> preference, String application, Event event, Map<String, String> config, String status) {
        log.info("Sending CDEvents notification..");
        String executionId = Optional.ofNullable(event.content).map(e -> (Map)e.get("execution")).map(e -> (String)e.get("id")).orElseThrow(() -> new FieldNotFoundException("execution.id"));
        String cdEventsType = Optional.ofNullable(preference).map(p -> (String)p.get("cdEventsType")).orElseThrow(() -> new FieldNotFoundException("notifications.cdEventsType"));
        String eventsBrokerUrl = Optional.ofNullable(preference).map(p -> (String)p.get("address")).orElseThrow(() -> new FieldNotFoundException("notifications.address"));
        CloudEvent cdEvent = this.cdEventsBuilderService.createCDEvent(preference, application, event, config, status, this.getSpinnakerUrl());
        log.info("Sending CDEvent {} notification to events broker url {}", (Object)cdEventsType, (Object)eventsBrokerUrl);
        Response<ResponseBody> response = this.cdEventsSenderService.sendCDEvent(cdEvent, eventsBrokerUrl);
        if (response != null) {
            try {
                log.info("Received response from events broker : {} {} for execution id {}. {}", new Object[]{response.code(), response.message(), executionId, response.body() != null ? ((ResponseBody)response.body()).string() : ""});
            }
            catch (IOException e2) {
                log.info("Received response from events broker : {} {} for execution id {} but unable to serialize the response body: {}", new Object[]{response.code(), response.message(), executionId, e2.getMessage()});
            }
        }
    }
}

