/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.microsoftteams.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.netflix.spinnaker.echo.api.Notification;
import com.netflix.spinnaker.echo.microsoftteams.api.MicrosoftTeamsFact;
import com.netflix.spinnaker.echo.microsoftteams.api.MicrosoftTeamsPotentialAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftTeamsSection {
    private static final Logger log = LoggerFactory.getLogger(MicrosoftTeamsSection.class);
    public String activityTitle;
    public List<MicrosoftTeamsFact> facts;
    public List<MicrosoftTeamsPotentialAction> potentialAction;
    private transient String executionType;

    public MicrosoftTeamsSection(String executionType, String title) {
        this.activityTitle = title.trim();
        this.facts = new ArrayList<MicrosoftTeamsFact>();
        this.potentialAction = new ArrayList<MicrosoftTeamsPotentialAction>();
        this.executionType = executionType == null ? "" : executionType.trim();
    }

    @JsonIgnore
    public void setApplicationName(String applicationName) {
        if (!StringUtils.isEmpty((CharSequence)applicationName)) {
            this.facts.add(new MicrosoftTeamsFact("Application Name", applicationName));
        }
    }

    @JsonIgnore
    public void setCustomMessage(String message) {
        if (!StringUtils.isEmpty((CharSequence)message)) {
            this.facts.add(new MicrosoftTeamsFact("Custom Message", message));
        }
    }

    @JsonIgnore
    public void setDescription(String description) {
        if (!StringUtils.isEmpty((CharSequence)description)) {
            this.facts.add(new MicrosoftTeamsFact("Description", description));
        }
    }

    @JsonIgnore
    public void setExecutionName(String executionName) {
        if (!StringUtils.isEmpty((CharSequence)executionName)) {
            this.facts.add(new MicrosoftTeamsFact("Execution Name", executionName));
        }
    }

    @JsonIgnore
    public void setEventName(String eventName) {
        if (!StringUtils.isEmpty((CharSequence)eventName)) {
            switch (this.executionType.toLowerCase()) {
                case "pipeline": {
                    this.facts.add(new MicrosoftTeamsFact("Pipeline Name", eventName));
                    break;
                }
                case "stage": {
                    this.facts.add(new MicrosoftTeamsFact("Stage Name", eventName));
                    break;
                }
                default: {
                    this.facts.add(new MicrosoftTeamsFact("Event Name", eventName));
                }
            }
        }
    }

    @JsonIgnore
    public void setMessage(String message) {
        if (!StringUtils.isEmpty((CharSequence)message)) {
            this.facts.add(new MicrosoftTeamsFact("Message", message));
        }
    }

    @JsonIgnore
    public void setStatus(String status) {
        if (!StringUtils.isEmpty((CharSequence)status)) {
            status = ((String)status).substring(0, 1).toUpperCase() + ((String)status).substring(1);
            this.facts.add(new MicrosoftTeamsFact("Status", (String)status));
        }
    }

    @JsonIgnore
    public void setSummary(String summary) {
        if (!StringUtils.isEmpty((CharSequence)summary)) {
            this.facts.add(new MicrosoftTeamsFact("Summary", summary));
        }
    }

    @JsonIgnore
    public void setPotentialAction(String url, Notification.InteractiveActions interactiveActions) {
        MicrosoftTeamsPotentialAction action = new MicrosoftTeamsPotentialAction();
        if (interactiveActions != null) {
            log.debug("Setting multi choice actions");
            action.setMultiChoiceAction(interactiveActions.getActions());
        } else if (url != null) {
            log.debug("Setting single choice action using url " + url);
            action.setSingleChoiceAction(url);
            this.potentialAction.add(action);
        }
    }
}

