/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.config;

import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.echo.github.GithubService;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@ConditionalOnProperty(value={"github-status.enabled"})
public class GithubConfig {
    private static final Logger log = LoggerFactory.getLogger(GithubConfig.class);
    private final String endpoint;

    public GithubConfig(@Value(value="${github-status.endpoint:https://api.github.com}") String endpoint) {
        this.endpoint = endpoint;
    }

    @Bean
    public GithubService githubService(OkHttp3ClientConfiguration okHttpClientConfig) {
        log.info("Github service loaded");
        return (GithubService)new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)this.endpoint)).client(okHttpClientConfig.createForRetrofit2().build()).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(GithubService.class);
    }
}

