/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.events;

import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.api.events.EventListener;
import com.netflix.spinnaker.echo.api.events.NotificationAgent;
import com.netflix.spinnaker.echo.notification.ExtensionNotificationAgent;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import rx.Observable;
import rx.Scheduler;
import rx.schedulers.Schedulers;

public class EventPropagator {
    private static final Logger log = LoggerFactory.getLogger(EventPropagator.class);
    private final Scheduler scheduler;
    private final ObjectProvider<List<EventListener>> eventListenerProvider;
    private final List<EventListener> notificationAgents;

    public EventPropagator(ObjectProvider<List<EventListener>> eventListenerProvider, List<NotificationAgent> notificationAgents) {
        this(eventListenerProvider, notificationAgents, Schedulers.io());
    }

    public EventPropagator(ObjectProvider<List<EventListener>> eventListenerProvider, List<NotificationAgent> notificationAgents, Scheduler scheduler) {
        this.eventListenerProvider = eventListenerProvider;
        this.notificationAgents = Optional.ofNullable(notificationAgents).orElseGet(ArrayList::new).stream().map(ExtensionNotificationAgent::new).collect(Collectors.toList());
        this.scheduler = scheduler;
    }

    private Set<EventListener> eventListeners() {
        HashSet<EventListener> eventListeners = new HashSet<EventListener>();
        eventListeners.addAll((Collection)this.eventListenerProvider.getIfAvailable(ArrayList::new));
        eventListeners.addAll(this.notificationAgents);
        return eventListeners;
    }

    public void processEvent(Event event) {
        Observable.from(this.eventListeners()).map(listener -> AuthenticatedRequest.propagate(() -> {
            listener.processEvent(event);
            return null;
        })).observeOn(this.scheduler).subscribe(callable -> {
            try {
                callable.call();
            }
            catch (Exception e) {
                log.error("failed processing event: {}", (Object)event, (Object)e);
            }
        });
    }
}

