/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.build;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.echo.config.IgorConfigurationProperties;
import com.netflix.spinnaker.echo.jackson.EchoObjectMapper;
import com.netflix.spinnaker.echo.model.Trigger;
import com.netflix.spinnaker.echo.model.trigger.BuildEvent;
import com.netflix.spinnaker.echo.services.IgorService;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"igor.enabled"})
public class BuildInfoService {
    private final IgorService igorService;
    private final RetrySupport retrySupport;
    private final IgorConfigurationProperties igorConfigurationProperties;
    private final ObjectMapper objectMapper = EchoObjectMapper.getInstance();

    public BuildEvent getBuildEvent(String master, String job, int buildNumber) {
        Map rawBuild = this.retry(this.igorConfigurationProperties.isJobNameAsQueryParameter() ? () -> (Map)Retrofit2SyncCall.execute(this.igorService.getBuildStatusWithJobQueryParameter(buildNumber, master, job)) : () -> (Map)Retrofit2SyncCall.execute(this.igorService.getBuild(buildNumber, master, job)));
        BuildEvent.Build build = (BuildEvent.Build)this.objectMapper.convertValue((Object)rawBuild, BuildEvent.Build.class);
        BuildEvent.Project project = new BuildEvent.Project(job, build);
        BuildEvent.Content content = new BuildEvent.Content(project, master);
        BuildEvent buildEvent = new BuildEvent();
        buildEvent.setContent(content);
        return buildEvent;
    }

    public Map<String, Object> getBuildInfo(BuildEvent event) {
        String master = event.getContent().getMaster();
        String job = event.getContent().getProject().getName();
        int buildNumber = event.getBuildNumber();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{master, job})) {
            return this.retry(() -> this.igorConfigurationProperties.isJobNameAsQueryParameter() ? (Map)Retrofit2SyncCall.execute(this.igorService.getBuildStatusWithJobQueryParameter(buildNumber, master, job)) : (Map)Retrofit2SyncCall.execute(this.igorService.getBuild(buildNumber, master, job)));
        }
        return Collections.emptyMap();
    }

    public Map<String, Object> getProperties(BuildEvent event, String propertyFile) {
        String master = event.getContent().getMaster();
        String job = event.getContent().getProject().getName();
        int buildNumber = event.getBuildNumber();
        if (StringUtils.isEmpty((CharSequence)propertyFile) && master.contains("travis")) {
            propertyFile = "travis";
        }
        String propertyFileFinal = propertyFile;
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{master, job, propertyFile})) {
            return this.retry(() -> this.igorConfigurationProperties.isJobNameAsQueryParameter() ? (Map)Retrofit2SyncCall.execute(this.igorService.getPropertyFileWithJobQueryParameter(buildNumber, propertyFileFinal, master, job)) : (Map)Retrofit2SyncCall.execute(this.igorService.getPropertyFile(buildNumber, propertyFileFinal, master, job)));
        }
        return Collections.emptyMap();
    }

    private List<Artifact> getArtifactsFromPropertyFile(BuildEvent event, String propertyFile) {
        String master = event.getContent().getMaster();
        String job = event.getContent().getProject().getName();
        int buildNumber = event.getBuildNumber();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{master, job, propertyFile})) {
            return this.retry(() -> this.igorConfigurationProperties.isJobNameAsQueryParameter() ? (List)Retrofit2SyncCall.execute(this.igorService.getArtifactsWithJobQueryParameter(buildNumber, master, job, propertyFile)) : (List)Retrofit2SyncCall.execute(this.igorService.getArtifacts(buildNumber, master, job, propertyFile)));
        }
        return Collections.emptyList();
    }

    private List<Artifact> getArtifactsFromBuildInfo(Trigger trigger) {
        Object artifacts;
        Map buildInfo = trigger.getBuildInfo();
        if (buildInfo != null && (artifacts = buildInfo.get("artifacts")) != null) {
            return (List)this.objectMapper.convertValue(artifacts, (TypeReference)new TypeReference<List<Artifact>>(){});
        }
        return Collections.emptyList();
    }

    public List<Artifact> getArtifactsFromBuildEvent(BuildEvent event, Trigger trigger) {
        List buildArtifacts = Optional.ofNullable(event.getContent()).map(BuildEvent.Content::getProject).map(BuildEvent.Project::getLastBuild).map(BuildEvent.Build::getArtifacts).orElse(Collections.emptyList());
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        result.addAll(buildArtifacts);
        result.addAll(this.getArtifactsFromPropertyFile(event, trigger.getPropertyFile()));
        result.addAll(this.getArtifactsFromBuildInfo(trigger));
        return result;
    }

    private <T> T retry(Supplier<T> supplier) {
        return (T)this.retrySupport.retry(supplier, 5, 2000L, false);
    }

    public BuildInfoService(IgorService igorService, RetrySupport retrySupport, IgorConfigurationProperties igorConfigurationProperties) {
        this.igorService = igorService;
        this.retrySupport = retrySupport;
        this.igorConfigurationProperties = igorConfigurationProperties;
    }
}

