/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.services;

import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.util.List;
import java.util.Map;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface IgorService {
    @GET(value="builds/status/{buildNumber}/{master}/{job}")
    public Call<Map<String, Object>> getBuild(@Path(value="buildNumber") Integer var1, @Path(value="master") String var2, @Path(value="job", encoded=true) String var3);

    @GET(value="builds/status/{buildNumber}/{master}")
    public Call<Map<String, Object>> getBuildStatusWithJobQueryParameter(@Path(value="buildNumber") @NotNull Integer var1, @Path(value="master") @NotNull String var2, @Query(value="job") @NotNull String var3);

    @GET(value="builds/properties/{buildNumber}/{fileName}/{master}/{job}")
    public Call<Map<String, Object>> getPropertyFile(@Path(value="buildNumber") Integer var1, @Path(value="fileName") String var2, @Path(value="master") String var3, @Path(value="job", encoded=true) String var4);

    @GET(value="builds/properties/{buildNumber}/{fileName}/{master}")
    public Call<Map<String, Object>> getPropertyFileWithJobQueryParameter(@Path(value="buildNumber") Integer var1, @Path(value="fileName") String var2, @Path(value="master") String var3, @Query(value="job") String var4);

    @GET(value="builds/artifacts/{buildNumber}/{master}/{job}")
    public Call<List<Artifact>> getArtifacts(@Path(value="buildNumber") Integer var1, @Path(value="master") String var2, @Path(value="job", encoded=true) String var3, @Query(value="propertyFile") String var4);

    @GET(value="builds/artifacts/{buildNumber}/{master}")
    public Call<List<Artifact>> getArtifactsWithJobQueryParameter(@Path(value="buildNumber") Integer var1, @Path(value="master") String var2, @Query(value="job") String var3, @Query(value="propertyFile") String var4);

    @GET(value="artifacts/{provider}/{packageName}")
    public Call<List<String>> getVersions(@Path(value="provider") String var1, @Path(value="packageName") String var2);

    @GET(value="artifacts/{provider}/{packageName}/{version}")
    public Call<Artifact> getArtifactByVersion(@Path(value="provider") String var1, @Path(value="packageName") String var2, @Path(value="version") String var3);

    @PUT(value="gcb/builds/{account}/{buildId}")
    public Call<ResponseBody> updateBuildStatus(@Path(value="account") String var1, @Path(value="buildId") String var2, @Query(value="status") String var3, @Body RequestBody var4);

    @PUT(value="gcb/artifacts/extract/{account}")
    public Call<List<Artifact>> extractGoogleCloudBuildArtifacts(@Path(value="account") String var1, @Body RequestBody var2);
}

