/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.notification;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.echo.api.events.Event;
import com.netflix.spinnaker.echo.api.events.EventListener;
import com.netflix.spinnaker.echo.jackson.EchoObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractEventNotificationAgent
implements EventListener {
    private static final String ORCHESTRATION = "orchestration";
    private static final String PIPELINE = "pipeline";
    private static final String TASK = "task";
    private static final String STAGE = "stage";
    private static final Map<String, Map<String, String>> CONFIG = ImmutableMap.builder().put((Object)"orchestration", (Object)ImmutableMap.of((Object)"type", (Object)"orchestration", (Object)"link", (Object)"tasks")).put((Object)"pipeline", (Object)ImmutableMap.of((Object)"type", (Object)"pipeline", (Object)"link", (Object)"executions/details")).put((Object)"task", (Object)ImmutableMap.of((Object)"type", (Object)"task", (Object)"link", (Object)"tasks")).put((Object)"stage", (Object)ImmutableMap.of((Object)"type", (Object)"stage", (Object)"link", (Object)"stage")).build();
    private static final Map<String, String> MANUAL_JUDGMENT_CONDITIONS = ImmutableMap.builder().put((Object)ManualJudgmentCondition.MANUAL_JUDGMENT.getName(), (Object)StageStatus.STARTING.getName()).put((Object)ManualJudgmentCondition.CONTINUE.getName(), (Object)StageStatus.COMPLETE.getName()).put((Object)ManualJudgmentCondition.STOP.getName(), (Object)StageStatus.FAILED.getName()).build();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ObjectMapper mapper = EchoObjectMapper.getInstance();
    @Value(value="${spinnaker.base-url}")
    protected String spinnakerUrl;

    public abstract String getNotificationType();

    public abstract void sendNotifications(Map<String, Object> var1, String var2, Event var3, Map<String, String> var4, String var5);

    protected String getSpinnakerUrl() {
        return this.spinnakerUrl;
    }

    public void processEvent(Event event) {
        Object when;
        if (this.log.isDebugEnabled() && this.mapper != null && !event.getDetails().getType().equals("pubsub")) {
            this.log.debug("Event received: {}", (Object)this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)event));
        }
        if (!event.getDetails().getType().startsWith("orca:")) {
            return;
        }
        List<String> eventDetails = Arrays.asList(event.getDetails().getType().split(":"));
        Map<String, String> config = CONFIG.get(eventDetails.get(1));
        String status = eventDetails.get(2);
        if (config == null || Strings.isNullOrEmpty((String)config.get("type"))) {
            return;
        }
        String configType = config.get("type");
        if (TASK.equals(configType) && !this.contentKeyAsBoolean(event, "standalone")) {
            return;
        }
        if (TASK.equals(configType) && this.contentKeyAsBoolean(event, "canceled")) {
            return;
        }
        if (STAGE.equals(configType) && this.contentKeyAsBoolean(event, "canceled")) {
            return;
        }
        if (STAGE.equals(configType) && (when = event.getContent().get("when")) != null && (when instanceof String ? !AbstractEventNotificationAgent.isManualJudgmentMatchStringCase((String)when, status) : when instanceof Collection && !AbstractEventNotificationAgent.isManualJudgmentMatchCollectionCase((Collection)when, status))) {
            return;
        }
        if (AbstractEventNotificationAgent.isExecution(configType) && this.isExecutionCanceled(event)) {
            return;
        }
        String application = event.getDetails().getApplication();
        ArrayList<Map<String, Object>> notificationsToSend = new ArrayList<Map<String, Object>>();
        if (AbstractEventNotificationAgent.isExecution(configType)) {
            notificationsToSend.addAll(this.buildPipelineNotifications(event, configType, status));
        }
        if (STAGE.equals(configType)) {
            notificationsToSend.addAll(this.buildStageNotifications(event, configType, status));
        }
        notificationsToSend.forEach(notification -> {
            try {
                this.sendNotifications((Map<String, Object>)notification, application, event, config, status);
            }
            catch (Exception e) {
                this.log.error("failed to send {} message", (Object)this.getNotificationType(), (Object)e);
            }
        });
    }

    private List<Map<String, Object>> buildPipelineNotifications(Event event, String configType, String status) {
        Execution execution = this.convertExecution(event);
        if (execution == null) {
            return Collections.emptyList();
        }
        List<Map<String, Object>> notifications = execution.notifications;
        if (notifications == null) {
            return Collections.emptyList();
        }
        return execution.notifications.stream().filter(it -> this.shouldSendRequestForNotification((Map<String, Object>)it, configType, status)).collect(Collectors.toList());
    }

    private List<Map<String, Object>> buildStageNotifications(Event event, String configType, String status) {
        Map context = (Map)event.getContent().get("context");
        if (context == null) {
            return Collections.emptyList();
        }
        boolean sendNotifications = Boolean.parseBoolean(Optional.ofNullable(context.get("sendNotifications")).orElse("false").toString());
        if (!sendNotifications || this.isStageSynthetic(event)) {
            return Collections.emptyList();
        }
        List notifications = context.getOrDefault("notifications", Collections.emptyList());
        return notifications.stream().filter(it -> this.shouldSendRequestForNotification((Map<String, Object>)it, configType, status)).collect(Collectors.toList());
    }

    private boolean shouldSendRequestForNotification(Map<String, Object> notification, String configType, String status) {
        Object when;
        String key = this.getNotificationType();
        if (key.equals(notification.get("type")) && (when = notification.get("when")) != null) {
            String requiredWhen = String.format("%s.%s", configType, status);
            if (when instanceof String) {
                return AbstractEventNotificationAgent.isManualJudgmentMatchStringCase((String)when, status) || ((String)when).contains(requiredWhen);
            }
            if (when instanceof Collection) {
                return AbstractEventNotificationAgent.isManualJudgmentMatchCollectionCase((Collection)when, status) || ((Collection)when).contains(requiredWhen);
            }
        }
        return false;
    }

    private boolean contentKeyAsBoolean(Event event, String key) {
        Object value = event.getContent().get(key);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private static boolean isManualJudgmentMatchStringCase(String when, String status) {
        if (ManualJudgmentCondition.MANUAL_JUDGMENT.getName().equals(when) || ManualJudgmentCondition.CONTINUE.getName().equals(when) || ManualJudgmentCondition.STOP.getName().equals(when)) {
            return false;
        }
        return status.equals(MANUAL_JUDGMENT_CONDITIONS.get(when));
    }

    private static boolean isManualJudgmentMatchCollectionCase(Collection<String> when, String status) {
        if (when.contains(ManualJudgmentCondition.MANUAL_JUDGMENT.getName()) || when.contains(ManualJudgmentCondition.CONTINUE.getName()) || when.contains(ManualJudgmentCondition.STOP.getName())) {
            return false;
        }
        for (String condition : when) {
            if (!status.equals(MANUAL_JUDGMENT_CONDITIONS.get(condition))) continue;
            return true;
        }
        return false;
    }

    private static boolean isExecution(String type) {
        return PIPELINE.equals(type) || ORCHESTRATION.equals(type);
    }

    private boolean isExecutionCanceled(Event event) {
        Execution execution = this.convertExecution(event);
        if (execution == null) {
            return false;
        }
        return "CANCELED".equals(execution.status) || execution.canceled;
    }

    private Execution convertExecution(Event event) {
        Object rawExecution = event.getContent().get("execution");
        if (rawExecution == null) {
            return null;
        }
        return (Execution)this.mapper.convertValue(rawExecution, Execution.class);
    }

    private boolean isStageSynthetic(Event event) {
        return Boolean.parseBoolean(Optional.ofNullable(event.getContent().get("isSynthetic")).orElseGet(() -> {
            Map context = (Map)event.getContent().get("context");
            if (context == null) {
                return false;
            }
            Map details = (Map)context.get("stageDetails");
            if (details != null) {
                return details.get("isSynthetic").toString();
            }
            return false;
        }).toString());
    }

    private static class Execution {
        public String status;
        public boolean canceled;
        public List<Map<String, Object>> notifications;

        private Execution() {
        }
    }

    static enum ManualJudgmentCondition {
        CONTINUE("manualJudgmentContinue"),
        STOP("manualJudgmentStop"),
        MANUAL_JUDGMENT("manualJudgment");

        final String name;

        private ManualJudgmentCondition(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    static enum StageStatus {
        COMPLETE("complete"),
        STARTING("starting"),
        FAILED("failed");

        final String name;

        private StageStatus(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

