/*
 * Copyright 2018 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.netflix.spinnaker.echo.services;

import java.util.List;
import java.util.Map;

public class GraphQLQueryResponse {

  Map<String, Object> data;
  List<Error> errors;

  public Map<String, Object> getData() {
    return data;
  }

  public List<Error> getErrors() {
    return errors;
  }

  public static class Error {
    String message;
    List<Object> path;
    List<Object> locations;
    String errorType;
    Object extensions;

    public String getMessage() {
      return message;
    }

    public List<Object> getPath() {
      return path;
    }

    public List<Object> getLocations() {
      return locations;
    }

    public String getErrorType() {
      return errorType;
    }

    public Object getExtensions() {
      return extensions;
    }
  }
}
