/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.artifacts;

import com.netflix.spinnaker.echo.model.ArtifactEvent;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.kork.artifacts.parsing.ArtifactExtractor;
import com.netflix.spinnaker.kork.artifacts.parsing.JinjaArtifactExtractor;
import java.io.InputStream;
import java.util.List;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

public class MessageArtifactTranslator {
    private final ArtifactExtractor artifactExtractor;
    private final ApplicationEventPublisher applicationEventPublisher;

    public List<Artifact> parseArtifacts(String messagePayload) {
        List artifacts = this.artifactExtractor.getArtifacts(messagePayload);
        if (!artifacts.isEmpty()) {
            this.applicationEventPublisher.publishEvent((Object)new ArtifactEvent(null, artifacts));
        }
        return artifacts;
    }

    private MessageArtifactTranslator(ArtifactExtractor artifactExtractor, ApplicationEventPublisher applicationEventPublisher) {
        this.artifactExtractor = artifactExtractor;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Component
    public static class Factory {
        private final ApplicationEventPublisher applicationEventPublisher;
        private final JinjaArtifactExtractor.Factory jinjaExtractorFactory;

        public MessageArtifactTranslator create(ArtifactExtractor artifactExtractor) {
            return new MessageArtifactTranslator(artifactExtractor, this.applicationEventPublisher);
        }

        public MessageArtifactTranslator createJinja(String jinjaTemplate) {
            return this.create((ArtifactExtractor)this.jinjaExtractorFactory.create(jinjaTemplate));
        }

        public MessageArtifactTranslator createJinja(InputStream jinjaStream) {
            return this.create((ArtifactExtractor)this.jinjaExtractorFactory.create(jinjaStream));
        }

        public Factory(ApplicationEventPublisher applicationEventPublisher, JinjaArtifactExtractor.Factory jinjaExtractorFactory) {
            this.applicationEventPublisher = applicationEventPublisher;
            this.jinjaExtractorFactory = jinjaExtractorFactory;
        }
    }
}

