/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.config.OkHttp3ClientConfiguration;
import com.netflix.spinnaker.echo.services.KeelService;
import com.netflix.spinnaker.kork.retrofit.ErrorHandlingExecutorCallAdapterFactory;
import com.netflix.spinnaker.kork.retrofit.util.RetrofitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@ConditionalOnExpression(value="${keel.enabled:false}")
public class KeelConfig {
    private static final Logger log = LoggerFactory.getLogger(KeelConfig.class);

    @Bean
    public KeelService keelService(@Value(value="${keel.base-url}") String keelBaseUrl, OkHttp3ClientConfiguration okHttpClientConfig) {
        return (KeelService)new Retrofit.Builder().baseUrl(RetrofitUtils.getBaseUrl((String)keelBaseUrl)).client(okHttpClientConfig.createForRetrofit2().build()).addCallAdapterFactory((CallAdapter.Factory)ErrorHandlingExecutorCallAdapterFactory.getInstance()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)new ObjectMapper())).build().create(KeelService.class);
    }
}

