/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.echo.artifacts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.echo.config.ArtifactEmitterProperties;
import com.netflix.spinnaker.echo.model.ArtifactEvent;
import com.netflix.spinnaker.echo.services.KeelService;
import com.netflix.spinnaker.kork.retrofit.Retrofit2SyncCall;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${artifact-emitter.enabled:false}")
public class ArtifactEmitter {
    private static final Logger log = LoggerFactory.getLogger(ArtifactEmitter.class);
    private final ObjectMapper objectMapper;
    private final KeelService keelService;
    private final ArtifactEmitterProperties artifactEmitterProperties;

    @Autowired
    public ArtifactEmitter(KeelService keelService, ArtifactEmitterProperties artifactEmitterProperties, ObjectMapper objectMapper) {
        this.keelService = keelService;
        this.artifactEmitterProperties = artifactEmitterProperties;
        this.objectMapper = objectMapper;
        log.info("Preparing to emit artifacts");
    }

    @EventListener
    public void processEvent(ArtifactEvent event) {
        try {
            HashMap<String, Object> sentEvent = new HashMap<String, Object>();
            sentEvent.put("eventName", this.artifactEmitterProperties.getEventName());
            sentEvent.put(this.artifactEmitterProperties.getFieldName(), this.objectMapper.convertValue((Object)event, Map.class));
            log.debug("Sending artifacts to Keel: {}", (Object)event.getArtifacts());
            Retrofit2SyncCall.execute(this.keelService.sendArtifactEvent(sentEvent));
        }
        catch (Exception e) {
            log.error("Could not send event {} to Keel", (Object)event, (Object)e);
        }
    }
}

