/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.specmesh.kafka.provision.Status;
import io.specmesh.kafka.provision.schema.AvroReferenceFinder;
import io.specmesh.kafka.provision.schema.SchemaProvisioner;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public final class SchemaReaders {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private SchemaReaders() {
    }

    public static SchemaReaderBuilder builder() {
        return SchemaReaderBuilder.builder();
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="schema refs")
    public static final class SchemaReaderBuilder {
        private SchemaRegistryClient srClient;

        private SchemaReaderBuilder() {
        }

        public static SchemaReaderBuilder builder() {
            return new SchemaReaderBuilder();
        }

        public SchemaReaderBuilder schemaRegistryClient(SchemaRegistryClient schemaRegistryClient) {
            this.srClient = schemaRegistryClient;
            return this;
        }

        public SchemaReader build() {
            return new SrSchemaReader(this.srClient);
        }
    }

    public static final class NamedSchema {
        private final String subject;
        private final ParsedSchema schema;

        public NamedSchema(String subject, ParsedSchema schema) {
            this.subject = Objects.requireNonNull(subject, "subject");
            this.schema = Objects.requireNonNull(schema, "parsedSchema");
        }

        public ParsedSchema schema() {
            return this.schema;
        }

        public String subject() {
            return this.subject;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="refs passed as param to prevent API pollution")
    public static class SchemaReferences {
        final List<SchemaReference> references = new ArrayList<SchemaReference>();
        final Map<String, String> resolvedReferences = new LinkedHashMap<String, String>();

        public void add(String type, String subject, String content) {
            this.references.add(new SchemaReference(type, subject, Integer.valueOf(-1)));
            this.resolvedReferences.put(subject, content);
        }

        @Generated
        public SchemaReferences() {
        }

        @Generated
        public List<SchemaReference> references() {
            return this.references;
        }

        @Generated
        public Map<String, String> resolvedReferences() {
            return this.resolvedReferences;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SchemaReferences)) {
                return false;
            }
            SchemaReferences other = (SchemaReferences)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<SchemaReference> this$references = this.references();
            List<SchemaReference> other$references = other.references();
            if (this$references == null ? other$references != null : !((Object)this$references).equals(other$references)) {
                return false;
            }
            Map<String, String> this$resolvedReferences = this.resolvedReferences();
            Map<String, String> other$resolvedReferences = other.resolvedReferences();
            return !(this$resolvedReferences == null ? other$resolvedReferences != null : !((Object)this$resolvedReferences).equals(other$resolvedReferences));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SchemaReferences;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<SchemaReference> $references = this.references();
            result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
            Map<String, String> $resolvedReferences = this.resolvedReferences();
            result = result * 59 + ($resolvedReferences == null ? 43 : ((Object)$resolvedReferences).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaReaders.SchemaReferences(references=" + String.valueOf(this.references()) + ", resolvedReferences=" + String.valueOf(this.resolvedReferences()) + ")";
        }
    }

    public static interface SchemaReader {
        public Collection<SchemaProvisioner.Schema> read(String var1);
    }

    public static final class SrSchemaReader
    implements SchemaReader {
        private final SchemaRegistryClient client;

        private SrSchemaReader(SchemaRegistryClient client) {
            this.client = client;
        }

        @Override
        public Collection<SchemaProvisioner.Schema> read(String prefix) {
            try {
                Collection subjects = this.client.getAllSubjectsByPrefix(prefix);
                Map<String, List> schemas = subjects.stream().collect(Collectors.toMap(subject -> subject, subject -> {
                    try {
                        return this.client.getSchemas(subject, false, true);
                    }
                    catch (RestClientException | IOException e) {
                        throw new SchemaProvisioner.SchemaProvisioningException("Failed to load schemas", e);
                    }
                }));
                return schemas.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).map(entry -> SchemaProvisioner.Schema.builder().subject((String)entry.getKey()).type(((ParsedSchema)((List)entry.getValue()).get(0)).schemaType()).schema((ParsedSchema)((List)entry.getValue()).get(0)).state(Status.STATE.READ).build()).collect(Collectors.toList());
            }
            catch (RestClientException | IOException e) {
                throw new SchemaProvisioner.SchemaProvisioningException("Failed to read schemas for:" + prefix, e);
            }
        }
    }

    public static final class FileSystemSchemaReader
    extends BaseLocalSchemaReader {
        public List<NamedSchema> read(Path path) {
            return this.read(path.toAbsolutePath().normalize().toString());
        }

        @Override
        public String readContent(String path) {
            return this.readContent(Path.of(path, new String[0]));
        }

        public String readContent(Path path) {
            try {
                return Files.readString(path, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new SchemaProvisioner.SchemaProvisioningException("Failed to read schema at path:" + String.valueOf(path.toAbsolutePath().normalize()), e);
            }
        }

        @Override
        AvroReferenceFinder referenceFinder(Path parentSchema) {
            Path schemaDir = parentSchema.toAbsolutePath().getParent();
            return new AvroReferenceFinder(type -> {
                Path path = schemaDir.resolve(type + ".avsc");
                String content = this.readContent(path);
                return new AvroReferenceFinder.LoadedSchema(path.toString(), content);
            });
        }

        @Override
        AvroReferenceFinder referenceFinder(String parentSchema) {
            return this.referenceFinder(Path.of(parentSchema, new String[0]));
        }
    }

    public static final class ClassPathSchemaReader
    extends BaseLocalSchemaReader {
        private static final char RESOURCE_PATH_SEPARATOR = '/';

        @Deprecated
        public boolean has(Path schemaFile) {
            return this.has(schemaFile.toString());
        }

        public boolean has(String schemaFile) {
            return this.getClass().getClassLoader().getResource(schemaFile) != null;
        }

        @Override
        @Deprecated(since="0.18.0", forRemoval=true)
        public List<NamedSchema> readLocal(Path filePath) {
            return super.readLocal(filePath);
        }

        @Override
        public String readContent(String location) {
            String string;
            block9: {
                InputStream s = this.getClass().getClassLoader().getResourceAsStream(location);
                try {
                    if (s == null) {
                        throw new RuntimeException(location + " not found");
                    }
                    string = new String(s.readAllBytes(), StandardCharsets.UTF_8);
                    if (s == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new SchemaProvisioner.SchemaProvisioningException("Failed to read schema from classpath:" + location, e);
                    }
                }
                s.close();
            }
            return string;
        }

        @Override
        AvroReferenceFinder referenceFinder(String rootSchemaLocation) {
            int idx = rootSchemaLocation.lastIndexOf(47);
            String schemaDir = idx < 0 ? "" : rootSchemaLocation.substring(0, idx + 1);
            return new AvroReferenceFinder(type -> {
                String location = "%s%s.avsc".formatted(schemaDir, type);
                String content = this.readContent(location);
                return new AvroReferenceFinder.LoadedSchema(location, content);
            });
        }
    }

    private static abstract class BaseLocalSchemaReader
    implements LocalReader {
        private BaseLocalSchemaReader() {
        }

        @Override
        public List<NamedSchema> read(String schemaFile) {
            String schemaContent = this.readContent(schemaFile);
            if (schemaFile.endsWith(".avsc")) {
                return this.referenceFinder(schemaFile).findReferences(schemaFile, schemaContent).stream().map(s -> new NamedSchema(s.typeName(), (ParsedSchema)BaseLocalSchemaReader.toAvroSchema(s))).collect(Collectors.toList());
            }
            if (schemaFile.endsWith(".yml")) {
                return List.of(new NamedSchema("", (ParsedSchema)new JsonSchema(schemaContent)));
            }
            if (schemaFile.endsWith(".proto")) {
                return List.of(new NamedSchema("", (ParsedSchema)new ProtobufSchema(schemaContent)));
            }
            throw new UnsupportedOperationException("Unsupported schema file: " + schemaFile);
        }

        public List<NamedSchema> readLocal(Path filePath) {
            return this.read(filePath.toString());
        }

        @Deprecated
        protected String readSchema(Path path) {
            return this.readContent(path.toString());
        }

        @Deprecated
        AvroReferenceFinder referenceFinder(Path parentSchema) {
            return this.referenceFinder(parentSchema.toString());
        }

        abstract AvroReferenceFinder referenceFinder(String var1);

        private static AvroSchema toAvroSchema(AvroReferenceFinder.DetectedSchema schema) {
            List references = schema.references().stream().map(ref -> new SchemaReference(ref.typeName(), ref.typeName(), Integer.valueOf(-1))).collect(Collectors.toList());
            Map resolvedReferences = schema.references().stream().collect(Collectors.toMap(AvroReferenceFinder.DetectedSchema::typeName, AvroReferenceFinder.DetectedSchema::content, (s1, s2) -> s1, LinkedHashMap::new));
            return new AvroSchema(schema.content(), references, resolvedReferences, Integer.valueOf(-1));
        }
    }

    public static interface LocalReader {
        public List<NamedSchema> read(String var1);

        public String readContent(String var1);
    }

    public static final class LocalSchemaReader {
        private final ClassPathSchemaReader cpReader = new ClassPathSchemaReader();
        private final FileSystemSchemaReader fsReader = new FileSystemSchemaReader();

        @Deprecated
        public List<NamedSchema> read(Path schemaFile) {
            return this.read(schemaFile.toString());
        }

        public List<NamedSchema> read(String schemaFile) {
            if (this.cpReader.has(schemaFile)) {
                return this.cpReader.read(schemaFile);
            }
            return this.fsReader.read(schemaFile);
        }
    }
}

