/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision.schema;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.specmesh.kafka.provision.ProvisioningException;
import io.specmesh.kafka.provision.Status;
import io.specmesh.kafka.provision.schema.SchemaOwnership;
import io.specmesh.kafka.provision.schema.SchemaProvisioner;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SchemaMutators {
    public static final String DEFAULT_EVOLUTION = "FULL_TRANSITIVE";

    private SchemaMutators() {
    }

    static SchemaMutatorBuilder builder() {
        return SchemaMutatorBuilder.builder();
    }

    static final class SchemaMutatorBuilder {
        private SchemaRegistryClient client;
        private boolean dryRun;
        private boolean cleanUnspecified;

        private SchemaMutatorBuilder() {
        }

        public static SchemaMutatorBuilder builder() {
            return new SchemaMutatorBuilder();
        }

        public SchemaMutatorBuilder schemaRegistryClient(SchemaRegistryClient client) {
            this.client = client;
            return this;
        }

        public SchemaMutatorBuilder noop(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public SchemaMutatorBuilder cleanUnspecified(boolean cleanUnspecified) {
            this.cleanUnspecified = cleanUnspecified;
            return this;
        }

        SchemaMutator build(String domainId) {
            if (this.cleanUnspecified) {
                return new CleanUnspecifiedMutator(this.dryRun, this.client);
            }
            if (this.dryRun) {
                return new NoopSchemaMutator();
            }
            return new CollectiveMutator(new EnsureSharedRegistered(domainId, this.client), new UpdateMutator(this.client), new WriteMutator(this.client), new IgnoredMutator());
        }
    }

    static interface SchemaMutator {
        public List<SchemaProvisioner.Schema> mutate(Collection<SchemaProvisioner.Schema> var1);
    }

    public static final class NoopSchemaMutator
    implements SchemaMutator {
        @Override
        public List<SchemaProvisioner.Schema> mutate(Collection<SchemaProvisioner.Schema> schemas) {
            return List.copyOf(schemas);
        }
    }

    public static final class IgnoredMutator
    implements SchemaMutator {
        @Override
        public List<SchemaProvisioner.Schema> mutate(Collection<SchemaProvisioner.Schema> schemas) {
            return schemas.stream().filter(schema -> schema.state().equals((Object)Status.STATE.IGNORED)).collect(Collectors.toList());
        }
    }

    public static final class WriteMutator
    implements SchemaMutator {
        private final SchemaRegistryClient client;

        private WriteMutator(SchemaRegistryClient client) {
            this.client = client;
        }

        @Override
        public List<SchemaProvisioner.Schema> mutate(Collection<SchemaProvisioner.Schema> schemas) {
            return schemas.stream().filter(schema -> schema.state().equals((Object)Status.STATE.CREATE)).peek(schema -> {
                try {
                    int schemaId = this.client.register(schema.subject(), schema.schema());
                    this.client.updateCompatibility(schema.subject(), SchemaMutators.DEFAULT_EVOLUTION);
                    schema.messages("Subject: " + schema.subject() + ", created with id: " + schemaId + ", evolution set to: FULL_TRANSITIVE");
                    schema.state(Status.STATE.CREATED);
                }
                catch (RestClientException | IOException e) {
                    schema.exception(new ProvisioningException("Failed to write schema:" + schema.subject(), e));
                }
            }).collect(Collectors.toList());
        }
    }

    public static final class UpdateMutator
    implements SchemaMutator {
        private final SchemaRegistryClient client;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="client passed as param to prevent API pollution")
        public UpdateMutator(SchemaRegistryClient client) {
            this.client = client;
        }

        @Override
        public List<SchemaProvisioner.Schema> mutate(Collection<SchemaProvisioner.Schema> schemas) {
            return schemas.stream().filter(schema -> schema.state().equals((Object)Status.STATE.UPDATE)).map(this::register).collect(Collectors.toList());
        }

        private SchemaProvisioner.Schema register(SchemaProvisioner.Schema schema) {
            try {
                List compatibilityMessages = this.client.testCompatibilityVerbose(schema.subject(), schema.schema());
                if (!compatibilityMessages.isEmpty()) {
                    schema.messages(schema.messages() + "\nCompatibility test output:" + String.valueOf(compatibilityMessages));
                    schema.exception(new ProvisioningException("Schema compatibility issue detected for subject: " + schema.subject() + ", issues: " + String.valueOf(compatibilityMessages)));
                    return schema;
                }
                int schemaId = this.client.register(schema.subject(), schema.schema());
                schema.state(Status.STATE.UPDATED);
                schema.messages("Subject:" + schema.subject() + " Updated with id: " + schemaId);
            }
            catch (RestClientException | IOException e) {
                schema.exception(new ProvisioningException("Failed to update schema:" + schema.subject(), e));
            }
            return schema;
        }
    }

    private static final class EnsureSharedRegistered
    implements SchemaMutator {
        private final String domainId;
        private final SchemaRegistryClient client;

        private EnsureSharedRegistered(String domainId, SchemaRegistryClient client) {
            this.domainId = domainId;
            this.client = client;
        }

        @Override
        public List<SchemaProvisioner.Schema> mutate(Collection<SchemaProvisioner.Schema> schemas) {
            return schemas.stream().filter(SchemaProvisioner.Schema::topicSchema).filter(this::notOwnedByDomain).filter(schema -> schema.state().equals((Object)Status.STATE.CREATE) || schema.state().equals((Object)Status.STATE.UPDATE)).map(this::failIfNotRegistered).filter(schema -> schema.state().equals((Object)Status.STATE.FAILED)).collect(Collectors.toList());
        }

        private boolean notOwnedByDomain(SchemaProvisioner.Schema schema) {
            boolean named = schema.schema().name() != null;
            return named && !SchemaOwnership.schemaOwnedByDomain(schema, this.domainId);
        }

        private SchemaProvisioner.Schema failIfNotRegistered(SchemaProvisioner.Schema schema) {
            String name = schema.schema().name();
            try {
                int id = this.client.getId(name, schema.schema());
                schema.messages(schema.messages() + "\nSchema registered with id:" + id);
            }
            catch (Exception e) {
                schema.exception(new ProvisioningException("Topic schema that are not owned by the domain must already be registered under subject matching fully qualified name. name: " + name, e));
            }
            return schema;
        }
    }

    public static final class CleanUnspecifiedMutator
    implements SchemaMutator {
        private final boolean dryRun;
        private final SchemaRegistryClient srClient;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="client passed as param to prevent API pollution")
        public CleanUnspecifiedMutator(boolean dryRun, SchemaRegistryClient srClient) {
            this.dryRun = dryRun;
            this.srClient = srClient;
        }

        @Override
        public List<SchemaProvisioner.Schema> mutate(Collection<SchemaProvisioner.Schema> schemas) {
            return schemas.stream().filter(schema -> !schema.state().equals((Object)Status.STATE.UPDATE) && !schema.state().equals((Object)Status.STATE.CREATE) && !schema.state().equals((Object)Status.STATE.IGNORED)).peek(schema -> {
                try {
                    schema.state(Status.STATE.DELETE);
                    if (!this.dryRun) {
                        List schemaIds = this.srClient.deleteSubject(schema.subject());
                        schema.state(Status.STATE.DELETED);
                        schema.messages("Subject:" + schema.subject() + " DELETED ids: " + String.valueOf(schemaIds));
                    }
                }
                catch (RestClientException | IOException e) {
                    schema.exception(new ProvisioningException("Failed to update schema:" + schema.subject(), e));
                }
            }).collect(Collectors.toList());
        }
    }

    public static final class CollectiveMutator
    implements SchemaMutator {
        private final Stream<SchemaMutator> mutators;

        private CollectiveMutator(SchemaMutator ... mutators) {
            this.mutators = Arrays.stream(mutators);
        }

        @Override
        public List<SchemaProvisioner.Schema> mutate(Collection<SchemaProvisioner.Schema> schemas) {
            return this.mutators.map(mutator -> mutator.mutate(schemas)).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }
}

