/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.specmesh.kafka.Clients;
import io.specmesh.kafka.KafkaApiSpec;
import io.specmesh.kafka.provision.AclProvisioner;
import io.specmesh.kafka.provision.Status;
import io.specmesh.kafka.provision.TopicProvisioner;
import io.specmesh.kafka.provision.schema.SchemaProvisioner;
import java.util.Collection;
import lombok.Generated;
import org.apache.kafka.clients.admin.Admin;

@SuppressFBWarnings
public final class Provisioner {
    static final int REQUEST_TIMEOUT = 60;
    private String brokerUrl;
    private boolean srDisabled;
    private boolean aclDisabled;
    private String schemaRegistryUrl;
    private String srApiKey;
    private String srApiSecret;
    private SchemaRegistryClient schemaRegistryClient;
    private boolean closeSchemaClient;
    private String schemaPath;
    private String specPath;
    private String domainUserAlias;
    private KafkaApiSpec apiSpec;
    private String username;
    private String secret;
    private Admin adminClient;
    private boolean closeAdminClient;
    private boolean dryRun;
    private boolean cleanUnspecified;
    private double partitionCountFactor;

    public Status provision() {
        return this.provision(Clients::adminClient, Clients::schemaRegistryClient, KafkaApiSpec::loadFromClassPath, TopicProvisioner::provision, SchemaProvisioner::provision, AclProvisioner::provision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Status provision(AdminFactory adminFactory, SrClientFactory srClientFactory, SpecLoader specLoader, TopicProvision topicProvision, SchemaProvision schemaProvision, AclProvision aclProvision) {
        try {
            this.ensureApiSpec(specLoader);
            this.ensureAdminClient(adminFactory);
            this.ensureSrClient(srClientFactory);
            Status status = this.provision(topicProvision, schemaProvision, aclProvision);
            System.out.println(status);
            Status status2 = status;
            return status2;
        }
        finally {
            if (this.closeAdminClient) {
                try {
                    this.adminClient.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                this.adminClient = null;
            }
            if (this.closeSchemaClient) {
                try {
                    this.schemaRegistryClient.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                this.schemaRegistryClient = null;
            }
        }
    }

    private Status provision(TopicProvision topicProvision, SchemaProvision schemaProvision, AclProvision aclProvision) {
        String userName = this.domainUserAlias.isBlank() ? this.apiSpec.id() : this.domainUserAlias;
        Status.StatusBuilder status = Status.builder().topics(topicProvision.provision(this.dryRun, this.cleanUnspecified, this.partitionCountFactor, this.apiSpec, this.adminClient));
        if (!this.srDisabled) {
            status.schemas(schemaProvision.provision(this.dryRun, this.cleanUnspecified, this.apiSpec, this.schemaPath, this.schemaRegistryClient));
        }
        if (!this.aclDisabled) {
            status.acls(aclProvision.provision(this.dryRun, this.cleanUnspecified, this.apiSpec, userName, this.adminClient));
        }
        return status.build();
    }

    private void ensureSrClient(SrClientFactory srClientFactory) {
        if (this.srDisabled || this.schemaRegistryClient != null) {
            return;
        }
        if (this.schemaRegistryUrl.isBlank()) {
            throw new IllegalStateException("Please set a schema registry url");
        }
        this.schemaRegistryClient = srClientFactory.schemaRegistryClient(this.schemaRegistryUrl, this.srApiKey, this.srApiSecret);
        this.closeSchemaClient = true;
    }

    private void ensureAdminClient(AdminFactory adminFactory) {
        if (this.adminClient != null) {
            return;
        }
        if (this.brokerUrl.isBlank()) {
            throw new IllegalStateException("Please set a broker url");
        }
        this.adminClient = adminFactory.adminClient(this.brokerUrl, this.username, this.secret);
        this.closeAdminClient = true;
    }

    private void ensureApiSpec(SpecLoader specLoader) {
        if (this.apiSpec != null) {
            return;
        }
        if (this.specPath.isBlank()) {
            throw new IllegalStateException("Please set the path to the specification file");
        }
        this.apiSpec = specLoader.loadFromClassPath(this.specPath, Provisioner.class.getClassLoader());
    }

    @Generated
    private static String $default$brokerUrl() {
        return "";
    }

    @Generated
    private static String $default$schemaRegistryUrl() {
        return "";
    }

    @Generated
    private static boolean $default$closeSchemaClient() {
        return false;
    }

    @Generated
    private static String $default$schemaPath() {
        return "";
    }

    @Generated
    private static String $default$specPath() {
        return "";
    }

    @Generated
    private static String $default$domainUserAlias() {
        return "";
    }

    @Generated
    private static boolean $default$closeAdminClient() {
        return false;
    }

    @Generated
    private static double $default$partitionCountFactor() {
        return 1.0;
    }

    @Generated
    Provisioner(String brokerUrl, boolean srDisabled, boolean aclDisabled, String schemaRegistryUrl, String srApiKey, String srApiSecret, SchemaRegistryClient schemaRegistryClient, boolean closeSchemaClient, String schemaPath, String specPath, String domainUserAlias, KafkaApiSpec apiSpec, String username, String secret, Admin adminClient, boolean closeAdminClient, boolean dryRun, boolean cleanUnspecified, double partitionCountFactor) {
        this.brokerUrl = brokerUrl;
        this.srDisabled = srDisabled;
        this.aclDisabled = aclDisabled;
        this.schemaRegistryUrl = schemaRegistryUrl;
        this.srApiKey = srApiKey;
        this.srApiSecret = srApiSecret;
        this.schemaRegistryClient = schemaRegistryClient;
        this.closeSchemaClient = closeSchemaClient;
        this.schemaPath = schemaPath;
        this.specPath = specPath;
        this.domainUserAlias = domainUserAlias;
        this.apiSpec = apiSpec;
        this.username = username;
        this.secret = secret;
        this.adminClient = adminClient;
        this.closeAdminClient = closeAdminClient;
        this.dryRun = dryRun;
        this.cleanUnspecified = cleanUnspecified;
        this.partitionCountFactor = partitionCountFactor;
    }

    @Generated
    public static ProvisionerBuilder builder() {
        return new ProvisionerBuilder();
    }

    @Generated
    public String brokerUrl() {
        return this.brokerUrl;
    }

    @Generated
    public boolean srDisabled() {
        return this.srDisabled;
    }

    @Generated
    public boolean aclDisabled() {
        return this.aclDisabled;
    }

    @Generated
    public String schemaRegistryUrl() {
        return this.schemaRegistryUrl;
    }

    @Generated
    public String srApiKey() {
        return this.srApiKey;
    }

    @Generated
    public String srApiSecret() {
        return this.srApiSecret;
    }

    @Generated
    public SchemaRegistryClient schemaRegistryClient() {
        return this.schemaRegistryClient;
    }

    @Generated
    public boolean closeSchemaClient() {
        return this.closeSchemaClient;
    }

    @Generated
    public String schemaPath() {
        return this.schemaPath;
    }

    @Generated
    public String specPath() {
        return this.specPath;
    }

    @Generated
    public String domainUserAlias() {
        return this.domainUserAlias;
    }

    @Generated
    public KafkaApiSpec apiSpec() {
        return this.apiSpec;
    }

    @Generated
    public String username() {
        return this.username;
    }

    @Generated
    public String secret() {
        return this.secret;
    }

    @Generated
    public Admin adminClient() {
        return this.adminClient;
    }

    @Generated
    public boolean closeAdminClient() {
        return this.closeAdminClient;
    }

    @Generated
    public boolean dryRun() {
        return this.dryRun;
    }

    @Generated
    public boolean cleanUnspecified() {
        return this.cleanUnspecified;
    }

    @Generated
    public double partitionCountFactor() {
        return this.partitionCountFactor;
    }

    @VisibleForTesting
    static interface AdminFactory {
        public Admin adminClient(String var1, String var2, String var3);
    }

    @VisibleForTesting
    static interface SrClientFactory {
        public SchemaRegistryClient schemaRegistryClient(String var1, String var2, String var3);
    }

    @VisibleForTesting
    static interface SpecLoader {
        public KafkaApiSpec loadFromClassPath(String var1, ClassLoader var2);
    }

    @VisibleForTesting
    static interface TopicProvision {
        public Collection<TopicProvisioner.Topic> provision(boolean var1, boolean var2, double var3, KafkaApiSpec var5, Admin var6);
    }

    @VisibleForTesting
    static interface SchemaProvision {
        public Collection<SchemaProvisioner.Schema> provision(boolean var1, boolean var2, KafkaApiSpec var3, String var4, SchemaRegistryClient var5);
    }

    @VisibleForTesting
    static interface AclProvision {
        public Collection<AclProvisioner.Acl> provision(boolean var1, boolean var2, KafkaApiSpec var3, String var4, Admin var5);
    }

    @Generated
    public static class ProvisionerBuilder {
        @Generated
        private boolean brokerUrl$set;
        @Generated
        private String brokerUrl$value;
        @Generated
        private boolean srDisabled;
        @Generated
        private boolean aclDisabled;
        @Generated
        private boolean schemaRegistryUrl$set;
        @Generated
        private String schemaRegistryUrl$value;
        @Generated
        private String srApiKey;
        @Generated
        private String srApiSecret;
        @Generated
        private SchemaRegistryClient schemaRegistryClient;
        @Generated
        private boolean closeSchemaClient$set;
        @Generated
        private boolean closeSchemaClient$value;
        @Generated
        private boolean schemaPath$set;
        @Generated
        private String schemaPath$value;
        @Generated
        private boolean specPath$set;
        @Generated
        private String specPath$value;
        @Generated
        private boolean domainUserAlias$set;
        @Generated
        private String domainUserAlias$value;
        @Generated
        private KafkaApiSpec apiSpec;
        @Generated
        private String username;
        @Generated
        private String secret;
        @Generated
        private Admin adminClient;
        @Generated
        private boolean closeAdminClient$set;
        @Generated
        private boolean closeAdminClient$value;
        @Generated
        private boolean dryRun;
        @Generated
        private boolean cleanUnspecified;
        @Generated
        private boolean partitionCountFactor$set;
        @Generated
        private double partitionCountFactor$value;

        @Generated
        ProvisionerBuilder() {
        }

        @Generated
        public ProvisionerBuilder brokerUrl(String brokerUrl) {
            this.brokerUrl$value = brokerUrl;
            this.brokerUrl$set = true;
            return this;
        }

        @Generated
        public ProvisionerBuilder srDisabled(boolean srDisabled) {
            this.srDisabled = srDisabled;
            return this;
        }

        @Generated
        public ProvisionerBuilder aclDisabled(boolean aclDisabled) {
            this.aclDisabled = aclDisabled;
            return this;
        }

        @Generated
        public ProvisionerBuilder schemaRegistryUrl(String schemaRegistryUrl) {
            this.schemaRegistryUrl$value = schemaRegistryUrl;
            this.schemaRegistryUrl$set = true;
            return this;
        }

        @Generated
        public ProvisionerBuilder srApiKey(String srApiKey) {
            this.srApiKey = srApiKey;
            return this;
        }

        @Generated
        public ProvisionerBuilder srApiSecret(String srApiSecret) {
            this.srApiSecret = srApiSecret;
            return this;
        }

        @Generated
        public ProvisionerBuilder schemaRegistryClient(SchemaRegistryClient schemaRegistryClient) {
            this.schemaRegistryClient = schemaRegistryClient;
            return this;
        }

        @Generated
        public ProvisionerBuilder closeSchemaClient(boolean closeSchemaClient) {
            this.closeSchemaClient$value = closeSchemaClient;
            this.closeSchemaClient$set = true;
            return this;
        }

        @Generated
        public ProvisionerBuilder schemaPath(String schemaPath) {
            this.schemaPath$value = schemaPath;
            this.schemaPath$set = true;
            return this;
        }

        @Generated
        public ProvisionerBuilder specPath(String specPath) {
            this.specPath$value = specPath;
            this.specPath$set = true;
            return this;
        }

        @Generated
        public ProvisionerBuilder domainUserAlias(String domainUserAlias) {
            this.domainUserAlias$value = domainUserAlias;
            this.domainUserAlias$set = true;
            return this;
        }

        @Generated
        public ProvisionerBuilder apiSpec(KafkaApiSpec apiSpec) {
            this.apiSpec = apiSpec;
            return this;
        }

        @Generated
        public ProvisionerBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public ProvisionerBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        @Generated
        public ProvisionerBuilder adminClient(Admin adminClient) {
            this.adminClient = adminClient;
            return this;
        }

        @Generated
        public ProvisionerBuilder closeAdminClient(boolean closeAdminClient) {
            this.closeAdminClient$value = closeAdminClient;
            this.closeAdminClient$set = true;
            return this;
        }

        @Generated
        public ProvisionerBuilder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Generated
        public ProvisionerBuilder cleanUnspecified(boolean cleanUnspecified) {
            this.cleanUnspecified = cleanUnspecified;
            return this;
        }

        @Generated
        public ProvisionerBuilder partitionCountFactor(double partitionCountFactor) {
            this.partitionCountFactor$value = partitionCountFactor;
            this.partitionCountFactor$set = true;
            return this;
        }

        @Generated
        public Provisioner build() {
            String brokerUrl$value = this.brokerUrl$value;
            if (!this.brokerUrl$set) {
                brokerUrl$value = Provisioner.$default$brokerUrl();
            }
            String schemaRegistryUrl$value = this.schemaRegistryUrl$value;
            if (!this.schemaRegistryUrl$set) {
                schemaRegistryUrl$value = Provisioner.$default$schemaRegistryUrl();
            }
            boolean closeSchemaClient$value = this.closeSchemaClient$value;
            if (!this.closeSchemaClient$set) {
                closeSchemaClient$value = Provisioner.$default$closeSchemaClient();
            }
            String schemaPath$value = this.schemaPath$value;
            if (!this.schemaPath$set) {
                schemaPath$value = Provisioner.$default$schemaPath();
            }
            String specPath$value = this.specPath$value;
            if (!this.specPath$set) {
                specPath$value = Provisioner.$default$specPath();
            }
            String domainUserAlias$value = this.domainUserAlias$value;
            if (!this.domainUserAlias$set) {
                domainUserAlias$value = Provisioner.$default$domainUserAlias();
            }
            boolean closeAdminClient$value = this.closeAdminClient$value;
            if (!this.closeAdminClient$set) {
                closeAdminClient$value = Provisioner.$default$closeAdminClient();
            }
            double partitionCountFactor$value = this.partitionCountFactor$value;
            if (!this.partitionCountFactor$set) {
                partitionCountFactor$value = Provisioner.$default$partitionCountFactor();
            }
            return new Provisioner(brokerUrl$value, this.srDisabled, this.aclDisabled, schemaRegistryUrl$value, this.srApiKey, this.srApiSecret, this.schemaRegistryClient, closeSchemaClient$value, schemaPath$value, specPath$value, domainUserAlias$value, this.apiSpec, this.username, this.secret, this.adminClient, closeAdminClient$value, this.dryRun, this.cleanUnspecified, partitionCountFactor$value);
        }

        @Generated
        public String toString() {
            return "Provisioner.ProvisionerBuilder(brokerUrl$value=" + this.brokerUrl$value + ", srDisabled=" + this.srDisabled + ", aclDisabled=" + this.aclDisabled + ", schemaRegistryUrl$value=" + this.schemaRegistryUrl$value + ", srApiKey=" + this.srApiKey + ", srApiSecret=" + this.srApiSecret + ", schemaRegistryClient=" + String.valueOf(this.schemaRegistryClient) + ", closeSchemaClient$value=" + this.closeSchemaClient$value + ", schemaPath$value=" + this.schemaPath$value + ", specPath$value=" + this.specPath$value + ", domainUserAlias$value=" + this.domainUserAlias$value + ", apiSpec=" + String.valueOf(this.apiSpec) + ", username=" + this.username + ", secret=" + this.secret + ", adminClient=" + String.valueOf(this.adminClient) + ", closeAdminClient$value=" + this.closeAdminClient$value + ", dryRun=" + this.dryRun + ", cleanUnspecified=" + this.cleanUnspecified + ", partitionCountFactor$value=" + this.partitionCountFactor$value + ")";
        }
    }
}

