/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.kafka.KafkaApiSpec;
import io.specmesh.kafka.provision.AclChangeSetCalculators;
import io.specmesh.kafka.provision.AclMutators;
import io.specmesh.kafka.provision.AclReaders;
import io.specmesh.kafka.provision.ExceptionWrapper;
import io.specmesh.kafka.provision.ProvisioningTask;
import io.specmesh.kafka.provision.Status;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.acl.AclBinding;

public final class AclProvisioner {
    private AclProvisioner() {
    }

    @Deprecated(forRemoval=true, since="0.10.1")
    public static Collection<Acl> provision(boolean dryRun, boolean cleanUnspecified, KafkaApiSpec apiSpec, Admin adminClient) {
        return AclProvisioner.provision(dryRun, cleanUnspecified, apiSpec, apiSpec.id(), adminClient);
    }

    public static Collection<Acl> provision(boolean dryRun, boolean cleanUnspecified, KafkaApiSpec apiSpec, String userName, Admin adminClient) {
        Collection<Acl> requiredAcls = AclProvisioner.bindingsToAcls(apiSpec.requiredAcls(userName));
        Collection<Acl> existing = AclProvisioner.reader(adminClient).read(apiSpec.id(), requiredAcls);
        Collection<Acl> required = AclProvisioner.calculator(cleanUnspecified).calculate(existing, requiredAcls);
        return AclProvisioner.writer(dryRun, cleanUnspecified, adminClient).mutate(required);
    }

    private static AclChangeSetCalculators.ChangeSetCalculator calculator(boolean cleanUnspecified) {
        return AclChangeSetCalculators.ChangeSetBuilder.builder().build(cleanUnspecified);
    }

    private static AclReaders.AclReader reader(Admin adminClient) {
        return AclReaders.AclReaderBuilder.builder().adminClient(adminClient).build();
    }

    private static AclMutators.AclMutator writer(boolean dryRun, boolean cleanUnspecified, Admin adminClient) {
        return AclMutators.AclMutatorBuilder.builder().noop(dryRun).unspecified(cleanUnspecified).adminClient(adminClient).build();
    }

    private static Collection<Acl> bindingsToAcls(Set<AclBinding> allAcls) {
        return allAcls.stream().map(aclBinding -> Acl.builder().aclBinding((AclBinding)aclBinding).name(aclBinding.toString()).state(Status.STATE.CREATE).build()).collect(Collectors.toList());
    }

    @SuppressFBWarnings
    public static final class Acl
    implements ProvisioningTask {
        private String name;
        private Status.STATE state;
        private AclBinding aclBinding;
        private Exception exception;
        private String messages;

        @Override
        public String id() {
            return "ACL:" + this.name;
        }

        public Acl exception(Exception exception) {
            this.exception = new ExceptionWrapper(exception);
            this.state = Status.STATE.FAILED;
            return this;
        }

        @Generated
        private static String $default$messages() {
            return "";
        }

        @Generated
        public static AclBuilder builder() {
            return new AclBuilder();
        }

        @Generated
        public String name() {
            return this.name;
        }

        @Override
        @Generated
        public Status.STATE state() {
            return this.state;
        }

        @Generated
        public AclBinding aclBinding() {
            return this.aclBinding;
        }

        @Override
        @Generated
        public Exception exception() {
            return this.exception;
        }

        @Generated
        public String messages() {
            return this.messages;
        }

        @Generated
        public Acl name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public Acl state(Status.STATE state) {
            this.state = state;
            return this;
        }

        @Generated
        public Acl aclBinding(AclBinding aclBinding) {
            this.aclBinding = aclBinding;
            return this;
        }

        @Generated
        public Acl messages(String messages) {
            this.messages = messages;
            return this;
        }

        @Generated
        public String toString() {
            return "AclProvisioner.Acl(name=" + this.name() + ", state=" + String.valueOf((Object)this.state()) + ", aclBinding=" + String.valueOf(this.aclBinding()) + ", exception=" + String.valueOf(this.exception()) + ", messages=" + this.messages() + ")";
        }

        @Generated
        private Acl(String name, Status.STATE state, AclBinding aclBinding, Exception exception, String messages) {
            this.name = name;
            this.state = state;
            this.aclBinding = aclBinding;
            this.exception = exception;
            this.messages = messages;
        }

        @Generated
        private Acl() {
            this.messages = Acl.$default$messages();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Acl)) {
                return false;
            }
            Acl other = (Acl)o;
            String this$name = this.name();
            String other$name = other.name();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public static class AclBuilder {
            @Generated
            private String name;
            @Generated
            private Status.STATE state;
            @Generated
            private AclBinding aclBinding;
            @Generated
            private Exception exception;
            @Generated
            private boolean messages$set;
            @Generated
            private String messages$value;

            @Generated
            AclBuilder() {
            }

            @Generated
            public AclBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public AclBuilder state(Status.STATE state) {
                this.state = state;
                return this;
            }

            @Generated
            public AclBuilder aclBinding(AclBinding aclBinding) {
                this.aclBinding = aclBinding;
                return this;
            }

            @Generated
            public AclBuilder exception(Exception exception) {
                this.exception = exception;
                return this;
            }

            @Generated
            public AclBuilder messages(String messages) {
                this.messages$value = messages;
                this.messages$set = true;
                return this;
            }

            @Generated
            public Acl build() {
                String messages$value = this.messages$value;
                if (!this.messages$set) {
                    messages$value = Acl.$default$messages();
                }
                return new Acl(this.name, this.state, this.aclBinding, this.exception, messages$value);
            }

            @Generated
            public String toString() {
                return "AclProvisioner.Acl.AclBuilder(name=" + this.name + ", state=" + String.valueOf((Object)this.state) + ", aclBinding=" + String.valueOf(this.aclBinding) + ", exception=" + String.valueOf(this.exception) + ", messages$value=" + this.messages$value + ")";
            }
        }
    }
}

