/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.kafka.provision.AclProvisioner;
import io.specmesh.kafka.provision.ProvisioningException;
import io.specmesh.kafka.provision.Status;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.acl.AclBindingFilter;

public class AclMutators {

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="adminClient() passed as param to prevent API pollution")
    public static final class AclMutatorBuilder {
        private Admin adminClient;
        private boolean dryRun;
        private boolean cleanUnspecified;

        private AclMutatorBuilder() {
        }

        public static AclMutatorBuilder builder() {
            return new AclMutatorBuilder();
        }

        public AclMutatorBuilder adminClient(Admin adminClient) {
            this.adminClient = adminClient;
            return this;
        }

        public AclMutatorBuilder noop(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public AclMutatorBuilder unspecified(boolean cleanUnspecified) {
            this.cleanUnspecified = cleanUnspecified;
            return this;
        }

        public AclMutator build() {
            if (this.cleanUnspecified) {
                return new AclUnspecCleaner(this.adminClient, this.dryRun);
            }
            if (this.dryRun) {
                return new NoopAclMutator();
            }
            return new AclWriter(this.adminClient);
        }
    }

    static interface AclMutator {
        public Collection<AclProvisioner.Acl> mutate(Collection<AclProvisioner.Acl> var1);
    }

    public static final class NoopAclMutator
    implements AclMutator {
        @Override
        public Collection<AclProvisioner.Acl> mutate(Collection<AclProvisioner.Acl> acls) {
            return acls;
        }
    }

    public static final class AclWriter
    implements AclMutator {
        private final Admin adminClient;

        private AclWriter(Admin adminClient) {
            this.adminClient = adminClient;
        }

        @Override
        public Collection<AclProvisioner.Acl> mutate(Collection<AclProvisioner.Acl> acls) {
            if (this.deleteAclsInPrepForUpdate(acls)) {
                return acls;
            }
            List<AclProvisioner.Acl> createAcls = acls.stream().filter(acl -> acl.state().equals((Object)Status.STATE.CREATE) || acl.state().equals((Object)Status.STATE.UPDATE)).collect(Collectors.toList());
            List bindingsToCreate = createAcls.stream().map(AclProvisioner.Acl::aclBinding).collect(Collectors.toList());
            try {
                this.adminClient.createAcls(bindingsToCreate).all().get(60L, TimeUnit.SECONDS);
                createAcls.forEach(acl -> acl.state(Status.STATE.CREATED));
            }
            catch (Exception ex) {
                createAcls.forEach(acl -> acl.exception(new ProvisioningException("Failed to provision set of Acls", ex)));
            }
            return acls;
        }

        private boolean deleteAclsInPrepForUpdate(Collection<AclProvisioner.Acl> acls) {
            Collection<AclBindingFilter> updateBindingsFilters = this.bindingFiltersForUpdates(acls);
            try {
                this.adminClient.deleteAcls(updateBindingsFilters);
            }
            catch (Exception ex) {
                acls.stream().filter(acl -> acl.state().equals((Object)Status.STATE.UPDATE)).peek(acl -> acl.messages(acl.messages() + "\n Failed to delete ACLs").exception(new ProvisioningException("Failed to delete ACL", ex)));
                return true;
            }
            return false;
        }

        private Collection<AclBindingFilter> bindingFiltersForUpdates(Collection<AclProvisioner.Acl> acls) {
            return acls.stream().filter(acl -> acl.state().equals((Object)Status.STATE.UPDATE)).map(acl -> acl.aclBinding().toFilter()).collect(Collectors.toList());
        }
    }

    public static final class AclUnspecCleaner
    implements AclMutator {
        private final Admin adminClient;
        private final boolean dryRun;

        private AclUnspecCleaner(Admin adminClient, boolean dryRun) {
            this.adminClient = adminClient;
            this.dryRun = dryRun;
        }

        @Override
        public Collection<AclProvisioner.Acl> mutate(Collection<AclProvisioner.Acl> acls) {
            List<AclProvisioner.Acl> aclsToDelete = acls.stream().filter(acl -> !acl.state().equals((Object)Status.STATE.CREATE) && !acl.state().equals((Object)Status.STATE.UPDATE)).collect(Collectors.toList());
            List aclBindingFilters = aclsToDelete.stream().map(acl -> acl.aclBinding().toFilter()).collect(Collectors.toList());
            try {
                aclsToDelete.forEach(acl -> acl.state(Status.STATE.DELETE));
                if (!this.dryRun) {
                    this.adminClient.deleteAcls(aclBindingFilters);
                    aclsToDelete.forEach(acl -> acl.state(Status.STATE.DELETED));
                }
            }
            catch (Exception ex) {
                acls.stream().peek(acl -> acl.messages(acl.messages() + "\n Failed to delete ACLs").exception(new ProvisioningException("Failed to delete ACL", ex)));
                return acls;
            }
            return aclsToDelete;
        }
    }
}

