/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.admin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.kafka.admin.SimpleAdminClient;
import java.util.List;
import lombok.Generated;
import org.apache.kafka.clients.admin.Admin;

public interface SmAdminClient {
    public List<ConsumerGroup> groupsForTopicPrefix(String var1);

    public long topicVolumeUsingLogDirs(String var1);

    public List<Integer> brokerIds();

    public long topicVolumeOffsets(String var1);

    public static SmAdminClient create(Admin client) {
        return new SimpleAdminClient(client);
    }

    public static class Partition {
        private int id;
        private String topic;
        private long offset;

        @Generated
        public static PartitionBuilder builder() {
            return new PartitionBuilder();
        }

        @Generated
        public int id() {
            return this.id;
        }

        @Generated
        public String topic() {
            return this.topic;
        }

        @Generated
        public long offset() {
            return this.offset;
        }

        @Generated
        public Partition id(int id) {
            this.id = id;
            return this;
        }

        @Generated
        public Partition topic(String topic) {
            this.topic = topic;
            return this;
        }

        @Generated
        public Partition offset(long offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public String toString() {
            return "SmAdminClient.Partition(id=" + this.id() + ", topic=" + this.topic() + ", offset=" + this.offset() + ")";
        }

        @Generated
        private Partition(int id, String topic, long offset) {
            this.id = id;
            this.topic = topic;
            this.offset = offset;
        }

        @Generated
        private Partition() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Partition)) {
                return false;
            }
            Partition other = (Partition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.id() == other.id();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Partition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.id();
            return result;
        }

        @Generated
        public static class PartitionBuilder {
            @Generated
            private int id;
            @Generated
            private String topic;
            @Generated
            private long offset;

            @Generated
            PartitionBuilder() {
            }

            @Generated
            public PartitionBuilder id(int id) {
                this.id = id;
                return this;
            }

            @Generated
            public PartitionBuilder topic(String topic) {
                this.topic = topic;
                return this;
            }

            @Generated
            public PartitionBuilder offset(long offset) {
                this.offset = offset;
                return this;
            }

            @Generated
            public Partition build() {
                return new Partition(this.id, this.topic, this.offset);
            }

            @Generated
            public String toString() {
                return "SmAdminClient.Partition.PartitionBuilder(id=" + this.id + ", topic=" + this.topic + ", offset=" + this.offset + ")";
            }
        }
    }

    public static class Member {
        private String id;
        private String clientId;
        private String host;

        @Generated
        public static MemberBuilder builder() {
            return new MemberBuilder();
        }

        @Generated
        public String id() {
            return this.id;
        }

        @Generated
        public String clientId() {
            return this.clientId;
        }

        @Generated
        public String host() {
            return this.host;
        }

        @Generated
        public Member id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public Member clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public Member host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public String toString() {
            return "SmAdminClient.Member(id=" + this.id() + ", clientId=" + this.clientId() + ", host=" + this.host() + ")";
        }

        @Generated
        private Member(String id, String clientId, String host) {
            this.id = id;
            this.clientId = clientId;
            this.host = host;
        }

        @Generated
        private Member() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Member)) {
                return false;
            }
            Member other = (Member)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Member;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public static class MemberBuilder {
            @Generated
            private String id;
            @Generated
            private String clientId;
            @Generated
            private String host;

            @Generated
            MemberBuilder() {
            }

            @Generated
            public MemberBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public MemberBuilder clientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            @Generated
            public MemberBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public Member build() {
                return new Member(this.id, this.clientId, this.host);
            }

            @Generated
            public String toString() {
                return "SmAdminClient.Member.MemberBuilder(id=" + this.id + ", clientId=" + this.clientId + ", host=" + this.host + ")";
            }
        }
    }

    @SuppressFBWarnings
    public static class ConsumerGroup {
        private String id;
        private List<Member> members;
        private List<Partition> partitions;
        private long offsetTotal;

        void calculateTotalOffset() {
            this.partitions.forEach(p -> this.offsetTotal += p.offset());
        }

        @Generated
        public static ConsumerGroupBuilder builder() {
            return new ConsumerGroupBuilder();
        }

        @Generated
        public String id() {
            return this.id;
        }

        @Generated
        public List<Member> members() {
            return this.members;
        }

        @Generated
        public List<Partition> partitions() {
            return this.partitions;
        }

        @Generated
        public long offsetTotal() {
            return this.offsetTotal;
        }

        @Generated
        public ConsumerGroup id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ConsumerGroup members(List<Member> members) {
            this.members = members;
            return this;
        }

        @Generated
        public ConsumerGroup partitions(List<Partition> partitions) {
            this.partitions = partitions;
            return this;
        }

        @Generated
        public ConsumerGroup offsetTotal(long offsetTotal) {
            this.offsetTotal = offsetTotal;
            return this;
        }

        @Generated
        public String toString() {
            return "SmAdminClient.ConsumerGroup(id=" + this.id() + ", members=" + String.valueOf(this.members()) + ", partitions=" + String.valueOf(this.partitions()) + ", offsetTotal=" + this.offsetTotal() + ")";
        }

        @Generated
        private ConsumerGroup(String id, List<Member> members, List<Partition> partitions, long offsetTotal) {
            this.id = id;
            this.members = members;
            this.partitions = partitions;
            this.offsetTotal = offsetTotal;
        }

        @Generated
        private ConsumerGroup() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsumerGroup)) {
                return false;
            }
            ConsumerGroup other = (ConsumerGroup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConsumerGroup;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public static class ConsumerGroupBuilder {
            @Generated
            private String id;
            @Generated
            private List<Member> members;
            @Generated
            private List<Partition> partitions;
            @Generated
            private long offsetTotal;

            @Generated
            ConsumerGroupBuilder() {
            }

            @Generated
            public ConsumerGroupBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public ConsumerGroupBuilder members(List<Member> members) {
                this.members = members;
                return this;
            }

            @Generated
            public ConsumerGroupBuilder partitions(List<Partition> partitions) {
                this.partitions = partitions;
                return this;
            }

            @Generated
            public ConsumerGroupBuilder offsetTotal(long offsetTotal) {
                this.offsetTotal = offsetTotal;
                return this;
            }

            @Generated
            public ConsumerGroup build() {
                return new ConsumerGroup(this.id, this.members, this.partitions, this.offsetTotal);
            }

            @Generated
            public String toString() {
                return "SmAdminClient.ConsumerGroup.ConsumerGroupBuilder(id=" + this.id + ", members=" + String.valueOf(this.members) + ", partitions=" + String.valueOf(this.partitions) + ", offsetTotal=" + this.offsetTotal + ")";
            }
        }
    }

    public static class ClientException
    extends RuntimeException {
        ClientException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

