/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision.schema;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.specmesh.kafka.provision.Status;
import io.specmesh.kafka.provision.schema.SchemaOwnership;
import io.specmesh.kafka.provision.schema.SchemaProvisioner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class SchemaChangeSetCalculators {
    private SchemaChangeSetCalculators() {
    }

    static ChangeSetBuilder builder() {
        return ChangeSetBuilder.builder();
    }

    static final class ChangeSetBuilder {
        private ChangeSetBuilder() {
        }

        static ChangeSetBuilder builder() {
            return new ChangeSetBuilder();
        }

        ChangeSetCalculator build(boolean cleanUnspecified) {
            if (cleanUnspecified) {
                return new CleanUnspecifiedCalculator();
            }
            return new Collective(new IgnorePreprocessor(), new IgnoreCalculator(), new UpdateCalculator(), new CreateCalculator());
        }
    }

    static interface ChangeSetCalculator {
        public Collection<SchemaProvisioner.Schema> calculate(Collection<SchemaProvisioner.Schema> var1, Collection<SchemaProvisioner.Schema> var2, String var3);
    }

    static final class IgnoreCalculator
    implements ChangeSetCalculator {
        IgnoreCalculator() {
        }

        @Override
        public Collection<SchemaProvisioner.Schema> calculate(Collection<SchemaProvisioner.Schema> existing, Collection<SchemaProvisioner.Schema> required, String domainId) {
            return required.stream().filter(schema -> schema.state().equals((Object)Status.STATE.IGNORED)).toList();
        }
    }

    static final class IgnorePreprocessor {
        IgnorePreprocessor() {
        }

        public Collection<SchemaProvisioner.Schema> calculate(Collection<SchemaProvisioner.Schema> required, String domainId) {
            return required.stream().map(schema -> this.markIgnoredIfOutsideDomain((SchemaProvisioner.Schema)schema, domainId)).toList();
        }

        private SchemaProvisioner.Schema markIgnoredIfOutsideDomain(SchemaProvisioner.Schema schema, String domainId) {
            if (!schema.topicSchema() && !SchemaOwnership.schemaOwnedByDomain(schema, domainId)) {
                return schema.state(Status.STATE.IGNORED).messages("\n ignored as it does not belong to the domain");
            }
            return schema;
        }
    }

    static final class CreateCalculator
    implements ChangeSetCalculator {
        CreateCalculator() {
        }

        @Override
        public Collection<SchemaProvisioner.Schema> calculate(Collection<SchemaProvisioner.Schema> existing, Collection<SchemaProvisioner.Schema> required, String domainId) {
            return required.stream().filter(schema -> CreateCalculator.needsToBeCreated(schema, existing, domainId)).map(schema -> schema.state(Status.STATE.CREATE)).peek(schema -> schema.messages(schema.messages() + "\n Create")).toList();
        }

        private static boolean needsToBeCreated(SchemaProvisioner.Schema schema, Collection<SchemaProvisioner.Schema> existing, String domainId) {
            if (!schema.state().equals((Object)Status.STATE.READ) && !schema.state().equals((Object)Status.STATE.CREATE)) {
                return false;
            }
            if (!schema.topicSchema() && !SchemaOwnership.schemaOwnedByDomain(schema, domainId)) {
                return false;
            }
            return !existing.contains(schema);
        }
    }

    static final class UpdateCalculator
    implements ChangeSetCalculator {
        UpdateCalculator() {
        }

        @Override
        public Collection<SchemaProvisioner.Schema> calculate(Collection<SchemaProvisioner.Schema> existing, Collection<SchemaProvisioner.Schema> required, String domainId) {
            ArrayList<SchemaProvisioner.Schema> existingList = new ArrayList<SchemaProvisioner.Schema>(existing);
            return required.stream().filter(needs -> this.hasChanged((SchemaProvisioner.Schema)needs, (List<SchemaProvisioner.Schema>)existingList)).peek(schema -> schema.messages(schema.messages() + "\n Update").state(Status.STATE.UPDATE)).toList();
        }

        private boolean hasChanged(SchemaProvisioner.Schema needs, List<SchemaProvisioner.Schema> existingList) {
            int foundAt = existingList.indexOf(needs);
            if (foundAt != -1) {
                SchemaProvisioner.Schema existing = existingList.get(foundAt);
                return !this.normalizeSchema(existing.schema()).equals(this.normalizeSchema(needs.schema()));
            }
            return false;
        }

        private ParsedSchema normalizeSchema(ParsedSchema schema) {
            if (!(schema instanceof AvroSchema)) {
                return schema.normalize();
            }
            AvroSchema avroSchema = (AvroSchema)schema.normalize();
            List<SchemaReference> references = avroSchema.references().stream().map(ref -> new SchemaReference(ref.getName(), ref.getSubject(), Integer.valueOf(-1))).toList();
            return new AvroSchema(avroSchema.canonicalString(), references, avroSchema.resolvedReferences(), avroSchema.metadata(), avroSchema.ruleSet(), Integer.valueOf(-1), false);
        }
    }

    static class CleanUnspecifiedCalculator
    implements ChangeSetCalculator {
        CleanUnspecifiedCalculator() {
        }

        @Override
        public Collection<SchemaProvisioner.Schema> calculate(Collection<SchemaProvisioner.Schema> existing, Collection<SchemaProvisioner.Schema> required, String domainId) {
            existing.removeAll(required);
            return existing;
        }
    }

    static final class Collective
    implements ChangeSetCalculator {
        private final IgnorePreprocessor preprocessor;
        private final List<ChangeSetCalculator> calculatorStream;

        private Collective(IgnorePreprocessor preprocessor, ChangeSetCalculator ... writers) {
            this.preprocessor = Objects.requireNonNull(preprocessor, "preprocessor");
            this.calculatorStream = List.of(writers);
        }

        @Override
        public Collection<SchemaProvisioner.Schema> calculate(Collection<SchemaProvisioner.Schema> existing, Collection<SchemaProvisioner.Schema> required, String domainId) {
            Collection<SchemaProvisioner.Schema> preprocessed = this.preprocessor.calculate(required, domainId);
            return this.calculatorStream.stream().map(calculator -> calculator.calculate(existing, preprocessed, domainId)).flatMap(Collection::stream).toList();
        }
    }
}

