/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision.schema;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;

final class AvroReferenceFinder {
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS})).build();
    private static final Map<String, Schema.Type> STD_TYPE_NAMES = Arrays.stream(Schema.Type.values()).filter(type -> type != Schema.Type.UNION).collect(Collectors.toUnmodifiableMap(type -> type.toString().toLowerCase(), type -> type));
    private final SchemaLoader schemaLoader;

    AvroReferenceFinder(SchemaLoader schemaLoader) {
        this.schemaLoader = Objects.requireNonNull(schemaLoader, "schemaLoader");
    }

    List<DetectedSchema> findReferences(String schemaPath, String schemaContent) {
        Route route = new Route(schemaPath);
        ConcurrentHashMap<TypeName, List<DetectedSchema>> visitedTypes = new ConcurrentHashMap<TypeName, List<DetectedSchema>>();
        return this.findReferences(route, schemaContent, Optional.empty(), visitedTypes);
    }

    private List<DetectedSchema> findReferences(Route route, String schemaContent, Optional<TypeName> knownTypeName, Map<TypeName, List<DetectedSchema>> visitedTypes) {
        SchemaInfo schema = this.parseSchema(route, schemaContent, knownTypeName);
        schema.name.ifPresent(name -> visitedTypes.put((TypeName)name, List.of()));
        List<DetectedSchema> externalRefs = schema.externalReferences().stream().map(typeRef -> {
            List existing = (List)visitedTypes.get(typeRef);
            if (existing != null) {
                return existing;
            }
            LoadedSchema loaded = this.loadSchema(typeRef.fullyQualifiedName(), route);
            return this.findReferences(route.push(loaded.path()), loaded.content(), Optional.of(typeRef), visitedTypes);
        }).flatMap(Collection::stream).distinct().toList();
        ArrayList detected = new ArrayList(externalRefs);
        detected.add(new DetectedSchema(schema.name().map(TypeName::fullyQualifiedName).orElse(""), schema.content(), externalRefs));
        List<DetectedSchema> immutable = List.copyOf(detected);
        schema.name.ifPresent(name -> visitedTypes.put((TypeName)name, immutable));
        return immutable;
    }

    private SchemaInfo parseSchema(Route route, String content, Optional<TypeName> expectedName) {
        try {
            JsonNode rootNode = MAPPER.readTree(content);
            Optional<TypeName> actualName = AvroReferenceFinder.namedTypeName(rootNode);
            if (expectedName.isPresent()) {
                if (actualName.isEmpty()) {
                    throw new IllegalArgumentException("Not a named type. Avro only supports named types, e.g. record, fixed, enum, in external schema.");
                }
                if (!expectedName.get().equals(actualName.get())) {
                    throw new IllegalArgumentException("Expected schema file to contain type '%s', but contained '%s'".formatted(expectedName.get(), actualName.get()));
                }
            }
            TypeCollector typeCollector = new TypeCollector();
            typeCollector.collect(rootNode);
            return new SchemaInfo(route.current(), content, actualName, typeCollector.externalReferences);
        }
        catch (Exception e) {
            throw new InvalidSchemaException(route, content, e);
        }
    }

    private static Optional<String> textChild(String name, JsonNode node) {
        return Optional.ofNullable(node.get(name)).filter(JsonNode::isTextual).map(JsonNode::asText);
    }

    private static TypeInfo type(JsonNode typeNode, String currentNamespace) {
        if (typeNode.isArray()) {
            return TypeInfo.stdType(Schema.Type.UNION);
        }
        if (typeNode.isTextual()) {
            String typeName = typeNode.asText();
            Schema.Type stdType = STD_TYPE_NAMES.get(typeName);
            return stdType != null ? TypeInfo.stdType(stdType) : TypeInfo.typeReference(typeName, currentNamespace);
        }
        return AvroReferenceFinder.textChild("type", typeNode).map(String::toUpperCase).flatMap(name -> {
            try {
                return Optional.of(Schema.Type.valueOf((String)name));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }).map(TypeInfo::stdType).orElseGet(TypeInfo::empty);
    }

    private static Optional<TypeName> namedTypeName(JsonNode rootNode) {
        Optional<Schema.Type> namedType = AvroReferenceFinder.type(rootNode, "").stdType().filter(type -> type == Schema.Type.RECORD || type == Schema.Type.ENUM || type == Schema.Type.FIXED);
        if (namedType.isEmpty()) {
            return Optional.empty();
        }
        String namespace = AvroReferenceFinder.textChild("namespace", rootNode).orElse("");
        String name = AvroReferenceFinder.textChild("name", rootNode).orElse("");
        return Optional.of(new TypeName(namespace, name));
    }

    private LoadedSchema loadSchema(String type, Route route) {
        try {
            return Objects.requireNonNull(this.schemaLoader.load(type), "loader returned null");
        }
        catch (Exception e) {
            throw new SchemaLoadException(type, route, e);
        }
    }

    static interface SchemaLoader {
        public LoadedSchema load(String var1);
    }

    private record Route(List<String> paths) {
        Route(String initial) {
            this(new ArrayList<String>(List.of(initial)));
        }

        Route push(String schemaPath) {
            Route copy = new Route(new ArrayList<String>(this.paths));
            copy.paths.add(schemaPath);
            return copy;
        }

        private String current() {
            return this.paths.get(this.paths.size() - 1);
        }

        @Override
        public String toString() {
            return this.paths.stream().map(arg_0 -> Route.lambda$toString$0(" -> %s", arg_0)).collect(Collectors.joining()).substring(4);
        }

        private static /* synthetic */ String lambda$toString$0(String rec$, Object xva$0) {
            return " -> %s".formatted(xva$0);
        }
    }

    private record SchemaInfo(String schemaPath, String content, Optional<TypeName> name, List<TypeName> externalReferences) {
    }

    record DetectedSchema(String typeName, String content, List<DetectedSchema> references) {
        public DetectedSchema {
            Objects.requireNonNull(typeName, "typeName");
            Objects.requireNonNull(content, "content");
            references = List.copyOf((Collection)Objects.requireNonNull(references, "references"));
        }
    }

    private record TypeName(String namespace, String name) {
        TypeName {
            Objects.requireNonNull(namespace, "namespace");
            Objects.requireNonNull(name, "name");
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name can not be empty");
            }
        }

        String fullyQualifiedName() {
            return this.namespace.isEmpty() ? this.name : "%s.%s".formatted(this.namespace, this.name);
        }

        @Override
        public String toString() {
            return this.fullyQualifiedName();
        }
    }

    private static final class TypeCollector {
        private final Set<TypeName> definedTypes = new HashSet<TypeName>();
        private final List<TypeName> externalReferences = new ArrayList<TypeName>(0);

        private TypeCollector() {
        }

        void collect(JsonNode rootNode) {
            this.findTypes(rootNode, "");
        }

        private void findTypes(JsonNode node, String currentNamespace) {
            TypeName referencedType;
            TypeInfo type = AvroReferenceFinder.type(node, currentNamespace);
            if (type.referencedType().isPresent() && !this.definedTypes.contains(referencedType = type.referencedType().get()) && !this.externalReferences.contains(referencedType)) {
                this.externalReferences.add(referencedType);
            }
            if (type.stdType().isPresent()) {
                switch (type.stdType().get()) {
                    case RECORD: {
                        this.handleRecord(node, currentNamespace);
                        break;
                    }
                    case ARRAY: {
                        this.handleArray(node, currentNamespace);
                        break;
                    }
                    case MAP: {
                        this.handleMap(node, currentNamespace);
                        break;
                    }
                    case UNION: {
                        this.handleUnion(node, currentNamespace);
                        break;
                    }
                    case ENUM: 
                    case FIXED: {
                        this.handleNamedType(node, currentNamespace);
                        break;
                    }
                }
            }
        }

        private String handleNamedType(JsonNode node, String currentNamespace) {
            String name = AvroReferenceFinder.textChild("name", node).orElse("");
            String namespace = AvroReferenceFinder.textChild("namespace", node).orElse(currentNamespace);
            this.definedTypes.add(new TypeName(namespace, name));
            return namespace;
        }

        private void handleRecord(JsonNode node, String currentNamespace) {
            String namespace = this.handleNamedType(node, currentNamespace);
            Iterator fields = Optional.ofNullable(node.get("fields")).map(JsonNode::elements).orElse(ClassUtil.emptyIterator());
            while (fields.hasNext()) {
                JsonNode field = (JsonNode)fields.next();
                Optional.ofNullable(field.get("type")).ifPresent(type -> this.findTypes((JsonNode)type, namespace));
            }
        }

        private void handleArray(JsonNode node, String currentNamespace) {
            JsonNode items = node.get("items");
            if (items != null) {
                this.findTypes(items, currentNamespace);
            }
        }

        private void handleMap(JsonNode node, String currentNamespace) {
            JsonNode values = node.get("values");
            if (values != null) {
                this.findTypes(values, currentNamespace);
            }
        }

        private void handleUnion(JsonNode node, String currentNamespace) {
            for (JsonNode unionType : node) {
                this.findTypes(unionType, currentNamespace);
            }
        }
    }

    private static final class InvalidSchemaException
    extends RuntimeException {
        InvalidSchemaException(Route route, String content, Exception cause) {
            super("Schema content invalid. schema file chain: %s, content: %s".formatted(route, content), cause);
        }
    }

    private record TypeInfo(Optional<Schema.Type> stdType, Optional<TypeName> referencedType) {
        private static final TypeInfo EMPTY = new TypeInfo(Optional.empty(), Optional.empty());

        TypeInfo {
            Objects.requireNonNull(stdType, "stdType");
            Objects.requireNonNull(referencedType, "referencedType");
        }

        static TypeInfo empty() {
            return EMPTY;
        }

        static TypeInfo stdType(Schema.Type stdType) {
            return new TypeInfo(Optional.of(stdType), Optional.empty());
        }

        static TypeInfo typeReference(String referencedType, String currentNamespace) {
            return new TypeInfo(Optional.empty(), Optional.of(TypeInfo.parseTypeName(referencedType, currentNamespace)));
        }

        private static TypeName parseTypeName(String type, String currentNamespace) {
            int nsEnd = type.lastIndexOf(46);
            return nsEnd < 0 ? new TypeName(currentNamespace, type) : new TypeName(type.substring(0, nsEnd), type.substring(nsEnd + 1));
        }
    }

    record LoadedSchema(String path, String content) {
        LoadedSchema {
            Objects.requireNonNull(path, "path");
            Objects.requireNonNull(content, "content");
        }
    }

    private static final class SchemaLoadException
    extends RuntimeException {
        SchemaLoadException(String type, Route route, Throwable cause) {
            super("Failed to load schema for type: %s, referenced via schema file chain: %s".formatted(type, route), cause);
        }
    }
}

