/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import io.specmesh.kafka.provision.Status;
import io.specmesh.kafka.provision.TopicProvisioner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TopicChangeSetCalculators {

    public static final class ChangeSetBuilder {
        private ChangeSetBuilder() {
        }

        public static ChangeSetBuilder builder() {
            return new ChangeSetBuilder();
        }

        public ChangeSetCalculator build(boolean cleanUnspecified) {
            if (cleanUnspecified) {
                return new UnspecifiedCalculator();
            }
            return new CollectiveCalculator(new CreateCalculator(), new UpdateCalculator());
        }
    }

    static interface ChangeSetCalculator {
        public Collection<TopicProvisioner.Topic> calculate(Collection<TopicProvisioner.Topic> var1, Collection<TopicProvisioner.Topic> var2);
    }

    public static final class UnspecifiedCalculator
    implements ChangeSetCalculator {
        @Override
        public Collection<TopicProvisioner.Topic> calculate(Collection<TopicProvisioner.Topic> existingTopics, Collection<TopicProvisioner.Topic> requiredTopics) {
            existingTopics.removeAll(requiredTopics);
            return existingTopics;
        }
    }

    public static final class CreateCalculator
    implements ChangeSetCalculator {
        @Override
        public Collection<TopicProvisioner.Topic> calculate(Collection<TopicProvisioner.Topic> existingTopics, Collection<TopicProvisioner.Topic> requiredTopics) {
            return requiredTopics.stream().filter(dTopic -> !existingTopics.contains(dTopic)).map(dTopic -> dTopic.state(Status.STATE.CREATE)).collect(Collectors.toList());
        }
    }

    public static final class UpdateCalculator
    implements ChangeSetCalculator {
        @Override
        public Collection<TopicProvisioner.Topic> calculate(Collection<TopicProvisioner.Topic> existing, Collection<TopicProvisioner.Topic> required) {
            ArrayList<TopicProvisioner.Topic> existTopicsList = new ArrayList<TopicProvisioner.Topic>(existing);
            return required.stream().filter(rtopic -> {
                boolean plannedUpdates = false;
                if (existing.contains(rtopic)) {
                    TopicProvisioner.Topic existingTopic = (TopicProvisioner.Topic)existTopicsList.get(existTopicsList.indexOf(rtopic));
                    if (UpdateCalculator.isPartitionChange(rtopic, existingTopic)) {
                        rtopic.messages(rtopic.messages() + "\nUpdate partitions:" + existingTopic.partitions() + " -> " + rtopic.partitions());
                        plannedUpdates = true;
                    }
                    List<Map.Entry<String, String>> configChanges = UpdateCalculator.configChanges(rtopic, existingTopic);
                    configChanges.forEach(change -> rtopic.messages(rtopic.messages() + "\nUpdate config " + (String)change.getKey() + ":" + existingTopic.config().get(change.getKey()) + " -> " + (String)change.getValue()));
                    plannedUpdates = plannedUpdates || !configChanges.isEmpty();
                }
                return plannedUpdates;
            }).map(dTopic -> dTopic.state(Status.STATE.UPDATE)).collect(Collectors.toList());
        }

        private static boolean isPartitionChange(TopicProvisioner.Topic requested, TopicProvisioner.Topic existing) {
            return requested.partitions() > existing.partitions();
        }

        private static List<Map.Entry<String, String>> configChanges(TopicProvisioner.Topic requested, TopicProvisioner.Topic existing) {
            return requested.config().entrySet().stream().filter(requestedChange -> existing.config().containsKey(requestedChange.getKey()) && !existing.config().get(requestedChange.getKey()).equals(requestedChange.getValue())).collect(Collectors.toList());
        }
    }

    public static final class CollectiveCalculator
    implements ChangeSetCalculator {
        private final Stream<ChangeSetCalculator> calculators;

        private CollectiveCalculator(ChangeSetCalculator ... calculators) {
            this.calculators = Arrays.stream(calculators);
        }

        @Override
        public Collection<TopicProvisioner.Topic> calculate(Collection<TopicProvisioner.Topic> existingTopics, Collection<TopicProvisioner.Topic> requiredTopics) {
            return this.calculators.map(calculator -> calculator.calculate(existingTopics, requiredTopics)).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }
}

