/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import io.specmesh.kafka.provision.AclProvisioner;
import io.specmesh.kafka.provision.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class AclChangeSetCalculators {

    public static final class ChangeSetBuilder {
        private ChangeSetBuilder() {
        }

        public static ChangeSetBuilder builder() {
            return new ChangeSetBuilder();
        }

        public ChangeSetCalculator build(boolean cleanUnspecified) {
            if (cleanUnspecified) {
                return new CleanUnspecifiedCalculator();
            }
            return new CreateOrUpdateCalculator();
        }
    }

    static interface ChangeSetCalculator {
        public Collection<AclProvisioner.Acl> calculate(Collection<AclProvisioner.Acl> var1, Collection<AclProvisioner.Acl> var2);
    }

    public static final class CreateOrUpdateCalculator
    implements ChangeSetCalculator {
        @Override
        public Collection<AclProvisioner.Acl> calculate(Collection<AclProvisioner.Acl> existingAcls, Collection<AclProvisioner.Acl> requiredAcls) {
            List<AclProvisioner.Acl> createAcls = requiredAcls.stream().filter(neededAcl -> !existingAcls.contains(neededAcl)).map(neededAcl -> neededAcl.state(Status.STATE.CREATE)).collect(Collectors.toList());
            ArrayList<AclProvisioner.Acl> existingAcls1 = new ArrayList<AclProvisioner.Acl>(existingAcls);
            createAcls.addAll(requiredAcls.stream().filter(neededAcl -> this.hasChanged((AclProvisioner.Acl)neededAcl, (List<AclProvisioner.Acl>)existingAcls1)).map(neededAcl -> neededAcl.state(Status.STATE.UPDATE)).collect(Collectors.toList()));
            return createAcls;
        }

        private boolean hasChanged(AclProvisioner.Acl neededAcl, List<AclProvisioner.Acl> existingAcls) {
            int indexOfExisting = existingAcls.indexOf(neededAcl);
            if (indexOfExisting != -1) {
                return !existingAcls.get(indexOfExisting).aclBinding().equals((Object)neededAcl.aclBinding());
            }
            return false;
        }
    }

    public static final class CleanUnspecifiedCalculator
    implements ChangeSetCalculator {
        @Override
        public Collection<AclProvisioner.Acl> calculate(Collection<AclProvisioner.Acl> existingAcls, Collection<AclProvisioner.Acl> requiredAcls) {
            existingAcls.removeAll(requiredAcls);
            return existingAcls;
        }
    }
}

