/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision.schema;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.specmesh.apiparser.model.RecordPart;
import io.specmesh.apiparser.model.SchemaInfo;
import io.specmesh.kafka.KafkaApiSpec;
import io.specmesh.kafka.provision.ExceptionWrapper;
import io.specmesh.kafka.provision.ProvisioningException;
import io.specmesh.kafka.provision.ProvisioningTask;
import io.specmesh.kafka.provision.Status;
import io.specmesh.kafka.provision.schema.SchemaChangeSetCalculators;
import io.specmesh.kafka.provision.schema.SchemaMutators;
import io.specmesh.kafka.provision.schema.SchemaReaders;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class SchemaProvisioner {
    private SchemaProvisioner() {
    }

    public static List<Schema> provision(boolean dryRun, boolean cleanUnspecified, KafkaApiSpec apiSpec, String baseResourcePath, SchemaRegistryClient client) {
        SchemaReaders.SchemaReader reader = SchemaProvisioner.reader(client);
        Collection<Schema> existing = reader.read(apiSpec.id());
        List<Schema> required = SchemaProvisioner.requiredSchemas(apiSpec, baseResourcePath);
        if (required.stream().anyMatch(schema -> schema.state.equals((Object)Status.STATE.FAILED))) {
            throw new SchemaProvisioningException("Required Schemas Failed to load:" + String.valueOf(required));
        }
        Collection<Schema> schemas = SchemaProvisioner.calculator(cleanUnspecified).calculate(existing, required, apiSpec.id());
        return SchemaProvisioner.mutator(dryRun, cleanUnspecified, apiSpec.id(), client).mutate(schemas);
    }

    private static SchemaMutators.SchemaMutator mutator(boolean dryRun, boolean cleanUnspecified, String domainId, SchemaRegistryClient schemaRegistryClient) {
        return SchemaMutators.builder().schemaRegistryClient(schemaRegistryClient).noop(dryRun).cleanUnspecified(cleanUnspecified).build(domainId);
    }

    private static SchemaChangeSetCalculators.ChangeSetCalculator calculator(boolean cleanUnspecified) {
        return SchemaChangeSetCalculators.builder().build(cleanUnspecified);
    }

    private static List<Schema> requiredSchemas(KafkaApiSpec apiSpec, String baseResourcePath) {
        Path basePath = Paths.get(baseResourcePath, new String[0]);
        HashSet seenSubjects = new HashSet();
        return apiSpec.listDomainOwnedTopics().stream().flatMap(topic -> SchemaProvisioner.topicSchemas(apiSpec, basePath, topic.name())).filter(e -> seenSubjects.add(e.subject())).collect(Collectors.toList());
    }

    private static Stream<Schema> topicSchemas(KafkaApiSpec apiSpec, Path baseResourcePath, String topicName) {
        return apiSpec.ownedTopicSchemas(topicName).map(si -> Stream.of(si.key().flatMap(RecordPart::schemaRef).map(keySchema -> SchemaProvisioner.partSchemas("key", keySchema, si, baseResourcePath, topicName)), si.value().schemaRef().map(valueSchema -> SchemaProvisioner.partSchemas("value", valueSchema, si, baseResourcePath, topicName))).flatMap(Optional::stream).flatMap(Function.identity())).orElse(Stream.empty());
    }

    private static Stream<Schema> partSchemas(String partName, String schemaRef, SchemaInfo si, Path baseResourcePath, String topicName) {
        try {
            Path schemaPath = Path.of(baseResourcePath.toString(), schemaRef);
            List<SchemaReaders.NamedSchema> schemas = new SchemaReaders.LocalSchemaReader().read(schemaPath);
            SchemaReaders.NamedSchema topicSchema = schemas.get(schemas.size() - 1);
            return schemas.stream().map(ns -> {
                ParsedSchema schema = ns.schema();
                boolean isTopicSchema = ns.equals(topicSchema);
                String subject = isTopicSchema ? SchemaProvisioner.resolveSubjectName(topicName, schema, si, partName) : ns.subject();
                return Schema.builder().schema(schema).type(schema.schemaType()).subject(subject).state(Status.STATE.CREATE).topicSchema(isTopicSchema).build();
            });
        }
        catch (ProvisioningException ex) {
            return Stream.of(Schema.builder().messages("Failed to parse: " + schemaRef).exception(ex).build());
        }
    }

    private static String resolveSubjectName(String topicName, ParsedSchema schema, SchemaInfo schemaInfo, String partName) {
        String lookup = schemaInfo.schemaLookupStrategy().orElse("");
        if (lookup.equalsIgnoreCase("SimpleTopicIdStrategy")) {
            return topicName;
        }
        if (lookup.equalsIgnoreCase("RecordNameStrategy") || lookup.equalsIgnoreCase("RecordIdStrategy")) {
            if (!SchemaProvisioner.isAvro(schema)) {
                throw new UnsupportedOperationException("Currently, only avro schemas support RecordNameStrategy and RecordIdStrategy");
            }
            return ((AvroSchema)schema).rawSchema().getFullName();
        }
        if (lookup.equalsIgnoreCase("TopicRecordIdStrategy") || lookup.equalsIgnoreCase("TopicRecordNameStrategy")) {
            if (!SchemaProvisioner.isAvro(schema)) {
                throw new UnsupportedOperationException("Currently, only avro schemas support TopicRecordNameStrategy and TopicRecordIdStrategy");
            }
            return topicName + "-" + ((AvroSchema)schema).rawSchema().getFullName();
        }
        return topicName + "-" + partName;
    }

    private static boolean isAvro(ParsedSchema schema) {
        return schema.schemaType().equals("AVRO") && schema instanceof AvroSchema;
    }

    private static SchemaReaders.SchemaReader reader(SchemaRegistryClient schemaRegistryClient) {
        return SchemaReaders.builder().schemaRegistryClient(schemaRegistryClient).build();
    }

    public static class SchemaProvisioningException
    extends RuntimeException {
        public SchemaProvisioningException(String msg) {
            super(msg);
        }

        public SchemaProvisioningException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    @SuppressFBWarnings
    public static final class Schema
    implements ProvisioningTask {
        private String subject;
        private Status.STATE state;
        private String type;
        private Exception exception;
        private String messages;
        private boolean topicSchema;
        private ParsedSchema schema;

        @Override
        public String id() {
            return "Schema subject:" + this.subject;
        }

        public Schema exception(Exception exception) {
            this.exception = new ExceptionWrapper(exception);
            this.state = Status.STATE.FAILED;
            return this;
        }

        @Generated
        private static String $default$messages() {
            return "";
        }

        @Generated
        private static boolean $default$topicSchema() {
            return false;
        }

        @Generated
        public static SchemaBuilder builder() {
            return new SchemaBuilder();
        }

        @Generated
        public String subject() {
            return this.subject;
        }

        @Override
        @Generated
        public Status.STATE state() {
            return this.state;
        }

        @Generated
        public String type() {
            return this.type;
        }

        @Override
        @Generated
        public Exception exception() {
            return this.exception;
        }

        @Generated
        public String messages() {
            return this.messages;
        }

        @Generated
        public boolean topicSchema() {
            return this.topicSchema;
        }

        @Generated
        public ParsedSchema schema() {
            return this.schema;
        }

        @Generated
        public Schema subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Generated
        public Schema state(Status.STATE state) {
            this.state = state;
            return this;
        }

        @Generated
        public Schema type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public Schema messages(String messages) {
            this.messages = messages;
            return this;
        }

        @Generated
        public Schema topicSchema(boolean topicSchema) {
            this.topicSchema = topicSchema;
            return this;
        }

        @Generated
        public Schema schema(ParsedSchema schema) {
            this.schema = schema;
            return this;
        }

        @Generated
        public String toString() {
            return "SchemaProvisioner.Schema(subject=" + this.subject() + ", state=" + String.valueOf((Object)this.state()) + ", type=" + this.type() + ", exception=" + String.valueOf(this.exception()) + ", messages=" + this.messages() + ", topicSchema=" + this.topicSchema() + ", schema=" + String.valueOf(this.schema()) + ")";
        }

        @Generated
        private Schema(String subject, Status.STATE state, String type, Exception exception, String messages, boolean topicSchema, ParsedSchema schema) {
            this.subject = subject;
            this.state = state;
            this.type = type;
            this.exception = exception;
            this.messages = messages;
            this.topicSchema = topicSchema;
            this.schema = schema;
        }

        @Generated
        private Schema() {
            this.messages = Schema.$default$messages();
            this.topicSchema = Schema.$default$topicSchema();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Schema)) {
                return false;
            }
            Schema other = (Schema)o;
            String this$subject = this.subject();
            String other$subject = other.subject();
            return !(this$subject == null ? other$subject != null : !this$subject.equals(other$subject));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $subject = this.subject();
            result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
            return result;
        }

        @Generated
        public static class SchemaBuilder {
            @Generated
            private String subject;
            @Generated
            private Status.STATE state;
            @Generated
            private String type;
            @Generated
            private Exception exception;
            @Generated
            private boolean messages$set;
            @Generated
            private String messages$value;
            @Generated
            private boolean topicSchema$set;
            @Generated
            private boolean topicSchema$value;
            @Generated
            private ParsedSchema schema;

            @Generated
            SchemaBuilder() {
            }

            @Generated
            public SchemaBuilder subject(String subject) {
                this.subject = subject;
                return this;
            }

            @Generated
            public SchemaBuilder state(Status.STATE state) {
                this.state = state;
                return this;
            }

            @Generated
            public SchemaBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public SchemaBuilder exception(Exception exception) {
                this.exception = exception;
                return this;
            }

            @Generated
            public SchemaBuilder messages(String messages) {
                this.messages$value = messages;
                this.messages$set = true;
                return this;
            }

            @Generated
            public SchemaBuilder topicSchema(boolean topicSchema) {
                this.topicSchema$value = topicSchema;
                this.topicSchema$set = true;
                return this;
            }

            @Generated
            public SchemaBuilder schema(ParsedSchema schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public Schema build() {
                String messages$value = this.messages$value;
                if (!this.messages$set) {
                    messages$value = Schema.$default$messages();
                }
                boolean topicSchema$value = this.topicSchema$value;
                if (!this.topicSchema$set) {
                    topicSchema$value = Schema.$default$topicSchema();
                }
                return new Schema(this.subject, this.state, this.type, this.exception, messages$value, topicSchema$value, this.schema);
            }

            @Generated
            public String toString() {
                return "SchemaProvisioner.Schema.SchemaBuilder(subject=" + this.subject + ", state=" + String.valueOf((Object)this.state) + ", type=" + this.type + ", exception=" + String.valueOf(this.exception) + ", messages$value=" + this.messages$value + ", topicSchema$value=" + this.topicSchema$value + ", schema=" + String.valueOf(this.schema) + ")";
            }
        }
    }
}

