/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import io.specmesh.kafka.provision.ProvisioningException;
import io.specmesh.kafka.provision.Status;
import io.specmesh.kafka.provision.TopicProvisioner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;

public final class TopicReaders {

    public static final class TopicsReaderBuilder {
        private Admin adminClient;
        private String prefix;

        private TopicsReaderBuilder() {
        }

        public static TopicsReaderBuilder builder(Admin adminClient, String prefix) {
            return new TopicsReaderBuilder(adminClient, prefix);
        }

        private TopicsReaderBuilder(Admin adminClient, String prefix) {
            this.adminClient = adminClient;
            this.prefix = prefix;
        }

        public TopicReader build() {
            return new SimpleTopicReader(this.adminClient, this.prefix);
        }
    }

    public static interface TopicReader {
        public Collection<TopicProvisioner.Topic> readall();
    }

    public static final class SimpleTopicReader
    implements TopicReader {
        private final Admin adminClient;
        private final String prefix;

        private SimpleTopicReader(Admin adminClient, String prefix) {
            this.adminClient = adminClient;
            this.prefix = prefix;
        }

        @Override
        public Collection<TopicProvisioner.Topic> readall() {
            List<String> topicList = SimpleTopicReader.topicsForPrefix(this.adminClient, this.prefix);
            if (topicList.isEmpty()) {
                return List.of();
            }
            Map<String, KafkaFuture<TopicDescription>> topicDescriptions = this.topicDescriptions(topicList);
            Map<ConfigResource, Config> topicConfigs = this.topicConfigs(topicList);
            return topicList.stream().map(topicName -> {
                TopicProvisioner.Topic.TopicBuilder topicBuilder = TopicProvisioner.Topic.builder().name((String)topicName).state(Status.STATE.READ);
                try {
                    TopicDescription description = (TopicDescription)((KafkaFuture)topicDescriptions.get(topicName)).get();
                    Map<String, String> config = ((Config)topicConfigs.get(new ConfigResource(ConfigResource.Type.TOPIC, topicName))).entries().stream().collect(Collectors.toMap(ConfigEntry::name, ConfigEntry::value));
                    int replicationFactor = ((TopicPartitionInfo)description.partitions().iterator().next()).replicas().size();
                    topicBuilder.partitions(description.partitions().size()).replication((short)replicationFactor).config(config);
                }
                catch (Exception e) {
                    topicBuilder.exception(e);
                }
                return topicBuilder.build();
            }).collect(Collectors.toList());
        }

        private Map<ConfigResource, Config> topicConfigs(List<String> topicList) throws ProvisioningException {
            try {
                return (Map)this.adminClient.describeConfigs(this.generateConfigs(topicList)).all().get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new ProvisioningException("Failed to get topic configs", e);
            }
        }

        private Map<String, KafkaFuture<TopicDescription>> topicDescriptions(List<String> topicList) {
            return this.adminClient.describeTopics(topicList).topicNameValues();
        }

        private Set<ConfigResource> generateConfigs(List<String> topicList) {
            return topicList.stream().map(topicName -> new ConfigResource(ConfigResource.Type.TOPIC, topicName)).collect(Collectors.toSet());
        }

        private static List<String> topicsForPrefix(Admin adminClient, String prefix) {
            try {
                return ((Collection)adminClient.listTopics().listings().get(60L, TimeUnit.SECONDS)).stream().map(TopicListing::name).filter(name -> name.startsWith(prefix)).collect(Collectors.toList());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new ProvisioningException("Failed to list topics", e);
            }
        }
    }
}

