/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.kafka.KafkaApiSpec;
import io.specmesh.kafka.provision.ExceptionWrapper;
import io.specmesh.kafka.provision.ProvisioningTask;
import io.specmesh.kafka.provision.Status;
import io.specmesh.kafka.provision.TopicChangeSetCalculators;
import io.specmesh.kafka.provision.TopicMutators;
import io.specmesh.kafka.provision.TopicReaders;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kafka.clients.admin.Admin;

public final class TopicProvisioner {
    private TopicProvisioner() {
    }

    public static Collection<Topic> provision(boolean dryRun, boolean cleanUnspecified, double partitionCountFactor, KafkaApiSpec apiSpec, Admin adminClient) {
        Collection<Topic> domain = TopicProvisioner.domainTopicsFromApiSpec(apiSpec, partitionCountFactor);
        Collection<Topic> existing = TopicProvisioner.reader(apiSpec, adminClient).readall();
        Collection<Topic> changeSet = TopicProvisioner.comparator(cleanUnspecified).calculate(existing, domain);
        return TopicProvisioner.mutate(dryRun, cleanUnspecified, adminClient).mutate(changeSet);
    }

    private static TopicChangeSetCalculators.ChangeSetCalculator comparator(boolean cleanUnspecified) {
        return TopicChangeSetCalculators.ChangeSetBuilder.builder().build(cleanUnspecified);
    }

    private static TopicMutators.TopicMutator mutate(boolean dryRun, boolean cleanupUnspecified, Admin adminClient) {
        TopicMutators.TopicMutatorBuilder topicWriterBuilder = TopicMutators.TopicMutatorBuilder.builder().noopMutator(dryRun).cleanUnspecified(cleanupUnspecified, dryRun);
        return topicWriterBuilder.adminClient(adminClient).build();
    }

    private static TopicReaders.TopicReader reader(KafkaApiSpec apiSpec, Admin adminClient) {
        return TopicReaders.TopicsReaderBuilder.builder(adminClient, apiSpec.id()).build();
    }

    private static Collection<Topic> domainTopicsFromApiSpec(KafkaApiSpec apiSpec, double partitionCountFactor) {
        return apiSpec.listDomainOwnedTopics().stream().map(newTopic -> Topic.builder().name(newTopic.name()).state(Status.STATE.READ).partitions(TopicProvisioner.topicPartitions(newTopic.numPartitions(), partitionCountFactor)).replication(newTopic.replicationFactor()).config(newTopic.configs()).build()).collect(Collectors.toList());
    }

    private static int topicPartitions(int specPartitionCount, double partitionCountFactor) {
        Preconditions.checkArgument((0.0 < partitionCountFactor && partitionCountFactor <= 1.0 ? 1 : 0) != 0, (Object)("0.0 < partitionCountFactor <= 1.0, but was: " + partitionCountFactor));
        int min = specPartitionCount < 2 ? 1 : 2;
        return Math.max(min, (int)((double)specPartitionCount * partitionCountFactor));
    }

    @SuppressFBWarnings
    public static final class Topic
    implements ProvisioningTask {
        private String name;
        private Status.STATE state;
        private int partitions;
        private short replication;
        private Map<String, String> config;
        private Exception exception;
        private String messages;

        @Override
        public String id() {
            return "Topic:" + this.name;
        }

        public Topic exception(Exception exception) {
            this.exception = new ExceptionWrapper(exception);
            this.state = Status.STATE.FAILED;
            return this;
        }

        @Generated
        private static Map<String, String> $default$config() {
            return Map.of();
        }

        @Generated
        private static String $default$messages() {
            return "";
        }

        @Generated
        public static TopicBuilder builder() {
            return new TopicBuilder();
        }

        @Generated
        public String name() {
            return this.name;
        }

        @Override
        @Generated
        public Status.STATE state() {
            return this.state;
        }

        @Generated
        public int partitions() {
            return this.partitions;
        }

        @Generated
        public short replication() {
            return this.replication;
        }

        @Generated
        public Map<String, String> config() {
            return this.config;
        }

        @Override
        @Generated
        public Exception exception() {
            return this.exception;
        }

        @Generated
        public String messages() {
            return this.messages;
        }

        @Generated
        public Topic name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public Topic state(Status.STATE state) {
            this.state = state;
            return this;
        }

        @Generated
        public Topic partitions(int partitions) {
            this.partitions = partitions;
            return this;
        }

        @Generated
        public Topic replication(short replication) {
            this.replication = replication;
            return this;
        }

        @Generated
        public Topic config(Map<String, String> config) {
            this.config = config;
            return this;
        }

        @Generated
        public Topic messages(String messages) {
            this.messages = messages;
            return this;
        }

        @Generated
        public String toString() {
            return "TopicProvisioner.Topic(name=" + this.name() + ", state=" + String.valueOf((Object)this.state()) + ", partitions=" + this.partitions() + ", replication=" + this.replication() + ", config=" + String.valueOf(this.config()) + ", exception=" + String.valueOf(this.exception()) + ", messages=" + this.messages() + ")";
        }

        @Generated
        private Topic(String name, Status.STATE state, int partitions, short replication, Map<String, String> config, Exception exception, String messages) {
            this.name = name;
            this.state = state;
            this.partitions = partitions;
            this.replication = replication;
            this.config = config;
            this.exception = exception;
            this.messages = messages;
        }

        @Generated
        private Topic() {
            this.config = Topic.$default$config();
            this.messages = Topic.$default$messages();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Topic)) {
                return false;
            }
            Topic other = (Topic)o;
            String this$name = this.name();
            String other$name = other.name();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public static class TopicBuilder {
            @Generated
            private String name;
            @Generated
            private Status.STATE state;
            @Generated
            private int partitions;
            @Generated
            private short replication;
            @Generated
            private boolean config$set;
            @Generated
            private Map<String, String> config$value;
            @Generated
            private Exception exception;
            @Generated
            private boolean messages$set;
            @Generated
            private String messages$value;

            @Generated
            TopicBuilder() {
            }

            @Generated
            public TopicBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public TopicBuilder state(Status.STATE state) {
                this.state = state;
                return this;
            }

            @Generated
            public TopicBuilder partitions(int partitions) {
                this.partitions = partitions;
                return this;
            }

            @Generated
            public TopicBuilder replication(short replication) {
                this.replication = replication;
                return this;
            }

            @Generated
            public TopicBuilder config(Map<String, String> config) {
                this.config$value = config;
                this.config$set = true;
                return this;
            }

            @Generated
            public TopicBuilder exception(Exception exception) {
                this.exception = exception;
                return this;
            }

            @Generated
            public TopicBuilder messages(String messages) {
                this.messages$value = messages;
                this.messages$set = true;
                return this;
            }

            @Generated
            public Topic build() {
                Map<String, String> config$value = this.config$value;
                if (!this.config$set) {
                    config$value = Topic.$default$config();
                }
                String messages$value = this.messages$value;
                if (!this.messages$set) {
                    messages$value = Topic.$default$messages();
                }
                return new Topic(this.name, this.state, this.partitions, this.replication, config$value, this.exception, messages$value);
            }

            @Generated
            public String toString() {
                return "TopicProvisioner.Topic.TopicBuilder(name=" + this.name + ", state=" + String.valueOf((Object)this.state) + ", partitions=" + this.partitions + ", replication=" + this.replication + ", config$value=" + String.valueOf(this.config$value) + ", exception=" + String.valueOf(this.exception) + ", messages$value=" + this.messages$value + ")";
            }
        }
    }
}

