/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.kafka.provision.AclProvisioner;
import io.specmesh.kafka.provision.ProvisioningTask;
import io.specmesh.kafka.provision.TopicProvisioner;
import io.specmesh.kafka.provision.schema.SchemaProvisioner;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@SuppressFBWarnings
public class Status {
    private Collection<TopicProvisioner.Topic> topics;
    private Collection<SchemaProvisioner.Schema> schemas;
    private Collection<AclProvisioner.Acl> acls;

    public boolean failed() {
        return this.all().anyMatch(e -> e.state() == STATE.FAILED);
    }

    public void check() {
        List<Exception> exceptions = this.all().flatMap(e -> Optional.ofNullable(e.exception()).stream()).collect(Collectors.toList());
        if (!exceptions.isEmpty() || this.failed()) {
            throw new CompositeException(exceptions);
        }
    }

    public List<ProvisioningTask> failures() {
        return this.all().filter(ws -> ws.state() == STATE.FAILED).collect(Collectors.toList());
    }

    public Stream<ProvisioningTask> all() {
        return Stream.concat(Stream.concat(this.topics.stream(), this.schemas.stream()), this.acls.stream());
    }

    @Generated
    private static Collection<TopicProvisioner.Topic> $default$topics() {
        return List.of();
    }

    @Generated
    private static Collection<SchemaProvisioner.Schema> $default$schemas() {
        return List.of();
    }

    @Generated
    private static Collection<AclProvisioner.Acl> $default$acls() {
        return List.of();
    }

    @Generated
    public static StatusBuilder builder() {
        return new StatusBuilder();
    }

    @Generated
    public Collection<TopicProvisioner.Topic> topics() {
        return this.topics;
    }

    @Generated
    public Collection<SchemaProvisioner.Schema> schemas() {
        return this.schemas;
    }

    @Generated
    public Collection<AclProvisioner.Acl> acls() {
        return this.acls;
    }

    @Generated
    public Status topics(Collection<TopicProvisioner.Topic> topics) {
        this.topics = topics;
        return this;
    }

    @Generated
    public Status schemas(Collection<SchemaProvisioner.Schema> schemas) {
        this.schemas = schemas;
        return this;
    }

    @Generated
    public Status acls(Collection<AclProvisioner.Acl> acls) {
        this.acls = acls;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Status)) {
            return false;
        }
        Status other = (Status)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<TopicProvisioner.Topic> this$topics = this.topics();
        Collection<TopicProvisioner.Topic> other$topics = other.topics();
        if (this$topics == null ? other$topics != null : !((Object)this$topics).equals(other$topics)) {
            return false;
        }
        Collection<SchemaProvisioner.Schema> this$schemas = this.schemas();
        Collection<SchemaProvisioner.Schema> other$schemas = other.schemas();
        if (this$schemas == null ? other$schemas != null : !((Object)this$schemas).equals(other$schemas)) {
            return false;
        }
        Collection<AclProvisioner.Acl> this$acls = this.acls();
        Collection<AclProvisioner.Acl> other$acls = other.acls();
        return !(this$acls == null ? other$acls != null : !((Object)this$acls).equals(other$acls));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Status;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<TopicProvisioner.Topic> $topics = this.topics();
        result = result * 59 + ($topics == null ? 43 : ((Object)$topics).hashCode());
        Collection<SchemaProvisioner.Schema> $schemas = this.schemas();
        result = result * 59 + ($schemas == null ? 43 : ((Object)$schemas).hashCode());
        Collection<AclProvisioner.Acl> $acls = this.acls();
        result = result * 59 + ($acls == null ? 43 : ((Object)$acls).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Status(topics=" + String.valueOf(this.topics()) + ", schemas=" + String.valueOf(this.schemas()) + ", acls=" + String.valueOf(this.acls()) + ")";
    }

    @Generated
    private Status(Collection<TopicProvisioner.Topic> topics, Collection<SchemaProvisioner.Schema> schemas, Collection<AclProvisioner.Acl> acls) {
        this.topics = topics;
        this.schemas = schemas;
        this.acls = acls;
    }

    @Generated
    private Status() {
        this.topics = Status.$default$topics();
        this.schemas = Status.$default$schemas();
        this.acls = Status.$default$acls();
    }

    private static final class CompositeException
    extends RuntimeException {
        CompositeException(List<Exception> exceptions) {
            super(exceptions.stream().map(CompositeException::fullMessage).collect(Collectors.joining(System.lineSeparator())));
        }

        private static String fullMessage(Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return e.getMessage() + System.lineSeparator() + String.valueOf(sw);
        }
    }

    @Generated
    public static class StatusBuilder {
        @Generated
        private boolean topics$set;
        @Generated
        private Collection<TopicProvisioner.Topic> topics$value;
        @Generated
        private boolean schemas$set;
        @Generated
        private Collection<SchemaProvisioner.Schema> schemas$value;
        @Generated
        private boolean acls$set;
        @Generated
        private Collection<AclProvisioner.Acl> acls$value;

        @Generated
        StatusBuilder() {
        }

        @Generated
        public StatusBuilder topics(Collection<TopicProvisioner.Topic> topics) {
            this.topics$value = topics;
            this.topics$set = true;
            return this;
        }

        @Generated
        public StatusBuilder schemas(Collection<SchemaProvisioner.Schema> schemas) {
            this.schemas$value = schemas;
            this.schemas$set = true;
            return this;
        }

        @Generated
        public StatusBuilder acls(Collection<AclProvisioner.Acl> acls) {
            this.acls$value = acls;
            this.acls$set = true;
            return this;
        }

        @Generated
        public Status build() {
            Collection<TopicProvisioner.Topic> topics$value = this.topics$value;
            if (!this.topics$set) {
                topics$value = Status.$default$topics();
            }
            Collection<SchemaProvisioner.Schema> schemas$value = this.schemas$value;
            if (!this.schemas$set) {
                schemas$value = Status.$default$schemas();
            }
            Collection<AclProvisioner.Acl> acls$value = this.acls$value;
            if (!this.acls$set) {
                acls$value = Status.$default$acls();
            }
            return new Status(topics$value, schemas$value, acls$value);
        }

        @Generated
        public String toString() {
            return "Status.StatusBuilder(topics$value=" + String.valueOf(this.topics$value) + ", schemas$value=" + String.valueOf(this.schemas$value) + ", acls$value=" + String.valueOf(this.acls$value) + ")";
        }
    }

    public static enum STATE {
        READ,
        CREATE,
        CREATED,
        UPDATE,
        UPDATED,
        DELETE,
        DELETED,
        IGNORED,
        FAILED;

    }
}

