/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka.provision;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.kafka.provision.AclProvisioner;
import io.specmesh.kafka.provision.ProvisioningException;
import io.specmesh.kafka.provision.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;

public class AclReaders {

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="adminClient() passed as param to prevent API pollution")
    public static final class AclReaderBuilder {
        private Admin adminClient;

        private AclReaderBuilder() {
        }

        public static AclReaderBuilder builder() {
            return new AclReaderBuilder();
        }

        public AclReaderBuilder adminClient(Admin adminClient) {
            this.adminClient = adminClient;
            return this;
        }

        public AclReader build() {
            return new SimpleAclReader(this.adminClient);
        }
    }

    static interface AclReader {
        public Collection<AclProvisioner.Acl> read(String var1, Collection<AclProvisioner.Acl> var2);
    }

    public static final class SimpleAclReader
    implements AclReader {
        private final Admin adminClient;

        private SimpleAclReader(Admin adminClient) {
            this.adminClient = adminClient;
        }

        @Override
        public Collection<AclProvisioner.Acl> read(String prefixPattern, Collection<AclProvisioner.Acl> specAclsBindingsNeeded) {
            try {
                Collection allAcls = (Collection)this.adminClient.describeAcls(AclBindingFilter.ANY).values().get(60L, TimeUnit.SECONDS);
                Set existingAclsSuperSet = allAcls.stream().filter(aclBinding -> aclBinding.toFilter().patternFilter().name().contains(prefixPattern)).collect(Collectors.toSet());
                Set aclNeededAsStringSet = specAclsBindingsNeeded.stream().map(acl -> acl.aclBinding().toString()).collect(Collectors.toSet());
                List allAclsSpecifiedAndFound = allAcls.stream().filter(anAcl -> aclNeededAsStringSet.contains(anAcl.toString())).collect(Collectors.toList());
                existingAclsSuperSet.addAll(allAclsSpecifiedAndFound);
                return existingAclsSuperSet.stream().map(aclBinding -> AclProvisioner.Acl.builder().name(aclBinding.toString()).aclBinding((AclBinding)aclBinding).state(Status.STATE.READ).build()).collect(Collectors.toList());
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause().toString().contains("org.apache.kafka.common.errors.SecurityDisabledException")) {
                    return new ArrayList<AclProvisioner.Acl>();
                }
                throw new ProvisioningException("Failed to read ACLs", e);
            }
        }
    }
}

