/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka;

import io.specmesh.apiparser.AsyncApiParser;
import io.specmesh.apiparser.model.ApiSpec;
import io.specmesh.apiparser.model.Channel;
import io.specmesh.apiparser.model.Operation;
import io.specmesh.apiparser.model.SchemaInfo;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;

public final class KafkaApiSpec {
    private static final String GRANT_ACCESS_TAG = "grant-access:";
    private final ApiSpec apiSpec;

    public KafkaApiSpec(ApiSpec apiSpec) {
        this.apiSpec = Objects.requireNonNull(apiSpec, "apiSpec");
        this.validateTopicConfig();
    }

    public String id() {
        return this.apiSpec.id();
    }

    public List<NewTopic> listDomainOwnedTopics() {
        return this.apiSpec.channels().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(this.id())).map(e -> new NewTopic((String)e.getKey(), ((Channel)e.getValue()).bindings().kafka().partitions(), ((Channel)e.getValue()).bindings().kafka().replicas()).configs(((Channel)e.getValue()).bindings().kafka().configs())).collect(Collectors.toList());
    }

    @Deprecated
    public List<AclBinding> listACLsForDomainOwnedTopics() {
        return this.listACLsForDomainOwnedTopics(this.id());
    }

    private List<AclBinding> listACLsForDomainOwnedTopics(String user) {
        this.validateTopicConfig();
        ArrayList<AclBinding> topicAcls = new ArrayList<AclBinding>();
        topicAcls.addAll(this.ownTopicAcls(user));
        topicAcls.addAll(this.ownTransactionIdsAcls(user));
        topicAcls.addAll(this.publicTopicAcls());
        topicAcls.addAll(this.protectedTopicAcls());
        topicAcls.addAll(this.privateTopicAcls(user));
        topicAcls.addAll(KafkaApiSpec.prefixedAcls(ResourceType.CLUSTER, "kafka-cluster", this.principal(user), AclOperation.IDEMPOTENT_WRITE));
        return topicAcls;
    }

    public Set<AclBinding> requiredAcls() {
        return this.requiredAcls(this.id());
    }

    public Set<AclBinding> requiredAcls(String userName) {
        HashSet<AclBinding> acls = new HashSet<AclBinding>();
        acls.addAll(this.ownGroupAcls(userName));
        acls.addAll(this.listACLsForDomainOwnedTopics(userName));
        acls.addAll(this.grantAccessControlUsingGrantTagOnly());
        return acls;
    }

    public SchemaInfo schemaInfoForTopic(String topicName) {
        return this.ownedTopicSchemas(topicName).orElseThrow(() -> new APIException("No schema defined for topic: " + topicName));
    }

    public Optional<SchemaInfo> ownedTopicSchemas(String topicName) {
        Channel channel = (Channel)this.apiSpec.channels().get(topicName);
        if (channel == null) {
            throw new APIException("Unknown topic:" + topicName);
        }
        return Optional.ofNullable(channel.publish()).flatMap(Operation::schemaInfo);
    }

    public Stream<SchemaInfo> topicSchemas(String topicName) {
        Channel channel = (Channel)this.apiSpec.channels().get(topicName);
        if (channel == null) {
            throw new APIException("Unknown topic:" + topicName);
        }
        return Stream.of(channel.publish(), channel.subscribe()).filter(Objects::nonNull).map(Operation::schemaInfo).flatMap(Optional::stream);
    }

    private static String formatPrincipal(String domainIdAsUsername) {
        return domainIdAsUsername.equals(ApiSpec.PUBLIC) ? "User:*" : "User:" + domainIdAsUsername;
    }

    private void validateTopicConfig() {
        this.apiSpec.channels().forEach((name, channel) -> {
            if (name.startsWith(this.id()) && channel.publish() != null && (channel.bindings() == null || channel.bindings().kafka() == null)) {
                throw new IllegalStateException("'publish' channels require Kafka bindings for kafka bindings for topic config (partitions, replicas etc) and the root channel level.  channel: [" + name + "] Domain owner: [" + this.id() + "]");
            }
        });
    }

    private String principal(String user) {
        return KafkaApiSpec.formatPrincipal(user);
    }

    private Set<AclBinding> ownGroupAcls(String user) {
        return KafkaApiSpec.prefixedAcls(ResourceType.GROUP, this.id(), this.principal(user), AclOperation.READ, AclOperation.DELETE);
    }

    private Set<AclBinding> ownTopicAcls(String user) {
        return KafkaApiSpec.prefixedAcls(ResourceType.TOPIC, this.id(), this.principal(user), AclOperation.DESCRIBE, AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE);
    }

    private Set<AclBinding> ownTransactionIdsAcls(String user) {
        return KafkaApiSpec.prefixedAcls(ResourceType.TRANSACTIONAL_ID, this.id(), this.principal(user), AclOperation.DESCRIBE, AclOperation.WRITE);
    }

    private Set<AclBinding> publicTopicAcls() {
        return KafkaApiSpec.prefixedAcls(ResourceType.TOPIC, this.id() + ApiSpec.DELIMITER + ApiSpec.PUBLIC, "User:*", AclOperation.DESCRIBE, AclOperation.READ);
    }

    private List<AclBinding> protectedTopicAcls() {
        return this.apiSpec.channels().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(this.id() + ApiSpec.DELIMITER + ApiSpec.PROTECTED + ApiSpec.DELIMITER)).filter(e -> ((Channel)e.getValue()).publish().tags().toString().contains(GRANT_ACCESS_TAG)).flatMap(e -> ((Channel)e.getValue()).publish().tags().stream().filter(tag -> tag.name().startsWith(GRANT_ACCESS_TAG)).map(tag -> tag.name().substring(GRANT_ACCESS_TAG.length())).map(user -> KafkaApiSpec.literalAcls(ResourceType.TOPIC, (String)e.getKey(), KafkaApiSpec.formatPrincipal(user), AclOperation.DESCRIBE, AclOperation.READ)).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    private List<AclBinding> grantAccessControlUsingGrantTagOnly() {
        return this.apiSpec.channels().entrySet().stream().filter(e -> ((Channel)e.getValue()).publish() != null && !this.isUsingPathPerms((String)e.getKey()) && ((Channel)e.getValue()).publish().tags().toString().contains(GRANT_ACCESS_TAG)).flatMap(e -> ((Channel)e.getValue()).publish().tags().stream().filter(tag -> tag.name().startsWith(GRANT_ACCESS_TAG)).map(tag -> tag.name().substring(GRANT_ACCESS_TAG.length())).map(user -> KafkaApiSpec.literalAcls(ResourceType.TOPIC, (String)e.getKey(), KafkaApiSpec.formatPrincipal(user), AclOperation.DESCRIBE, AclOperation.READ)).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    private boolean isUsingPathPerms(String key) {
        return key.startsWith(this.id() + ApiSpec.DELIMITER + ApiSpec.PRIVATE + ApiSpec.DELIMITER) || key.startsWith(this.id() + ApiSpec.DELIMITER + ApiSpec.PROTECTED + ApiSpec.DELIMITER) || key.startsWith(this.id() + ApiSpec.DELIMITER + ApiSpec.PUBLIC + ApiSpec.DELIMITER);
    }

    private Set<AclBinding> privateTopicAcls(String user) {
        return KafkaApiSpec.prefixedAcls(ResourceType.TOPIC, this.id() + ApiSpec.DELIMITER + ApiSpec.PRIVATE, this.principal(user), AclOperation.CREATE);
    }

    private static Set<AclBinding> literalAcls(ResourceType resourceType, String resourceName, String principal, AclOperation ... operations) {
        return KafkaApiSpec.acls(resourceType, resourceName, principal, PatternType.LITERAL, operations);
    }

    private static Set<AclBinding> prefixedAcls(ResourceType resourceType, String resourceName, String principal, AclOperation ... operations) {
        return KafkaApiSpec.acls(resourceType, resourceName, principal, PatternType.PREFIXED, operations);
    }

    private static Set<AclBinding> acls(ResourceType resourceType, String resourceName, String principal, PatternType type, AclOperation ... operations) {
        ResourcePattern resourcePattern = new ResourcePattern(resourceType, resourceName, type);
        return Arrays.stream(operations).map(op -> new AccessControlEntry(principal, "*", op, AclPermissionType.ALLOW)).map(ace -> new AclBinding(resourcePattern, ace)).collect(Collectors.toSet());
    }

    public static KafkaApiSpec loadFromClassPath(String spec, ClassLoader classLoader) {
        KafkaApiSpec kafkaApiSpec;
        block8: {
            InputStream clis = classLoader.getResourceAsStream(spec);
            try {
                kafkaApiSpec = new KafkaApiSpec(new AsyncApiParser().loadResource(clis));
                if (clis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (clis != null) {
                        try {
                            clis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return KafkaApiSpec.loadFromFileSystem(spec);
                }
            }
            clis.close();
        }
        return kafkaApiSpec;
    }

    public static KafkaApiSpec loadFromFileSystem(String spec) {
        KafkaApiSpec kafkaApiSpec;
        FileInputStream fis = new FileInputStream(spec);
        try {
            kafkaApiSpec = new KafkaApiSpec(new AsyncApiParser().loadResource((InputStream)fis));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new APIException("Failed to load spec:" + spec, ex);
            }
        }
        ((InputStream)fis).close();
        return kafkaApiSpec;
    }

    public static KafkaApiSpec loadFromString(String spec) {
        try {
            return new KafkaApiSpec(new AsyncApiParser().loadResource(spec));
        }
        catch (Exception ex) {
            throw new APIException("Failed to load spec:" + spec, ex);
        }
    }

    public ApiSpec apiSpec() {
        return this.apiSpec;
    }

    private static class APIException
    extends RuntimeException {
        APIException(String message, Exception cause) {
            super(message, cause);
        }

        APIException(String message) {
            super(message);
        }
    }
}

