/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.kafka;

import io.specmesh.apiparser.model.ApiSpec;
import io.specmesh.apiparser.model.Bindings;
import io.specmesh.apiparser.model.Channel;
import io.specmesh.apiparser.model.KafkaBinding;
import io.specmesh.apiparser.model.Operation;
import io.specmesh.kafka.provision.TopicProvisioner;
import io.specmesh.kafka.provision.TopicReaders;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;

public final class Exporter {
    private Exporter() {
    }

    public static ApiSpec export(String aggregateId, Admin adminClient) throws ExporterException {
        return ApiSpec.builder().id("urn:" + aggregateId).version(LocalDate.now().toString()).asyncapi("2.5.0").channels(Exporter.channels(aggregateId.replace(":", "."), adminClient)).build();
    }

    private static Map<String, Channel> channels(String aggregateId, Admin adminClient) throws ExporterException {
        return Exporter.reader(aggregateId, adminClient).readall().stream().collect(Collectors.toMap(topic -> topic.name().substring(aggregateId.length() + 1), Exporter::channel));
    }

    private static TopicReaders.TopicReader reader(String aggregateId, Admin adminClient) {
        return TopicReaders.TopicsReaderBuilder.builder(adminClient, aggregateId).build();
    }

    private static Channel channel(TopicProvisioner.Topic topic) {
        return Channel.builder().bindings(Bindings.builder().kafka(Exporter.kafkaBindings(topic)).build()).publish(Operation.builder().operationId("OnPublish").build()).build();
    }

    private static KafkaBinding kafkaBindings(TopicProvisioner.Topic topic) {
        return KafkaBinding.builder().bindingVersion("unknown").replicas(Optional.of(topic.replication())).partitions(Optional.of(topic.partitions())).configs(topic.config()).build();
    }

    public static class ExporterException
    extends RuntimeException {
        ExporterException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

