/*
 * Decompiled with CFR 0.152.
 */
package io.specmesh.cli;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.specmesh.kafka.Clients;
import io.specmesh.kafka.KafkaApiSpec;
import io.specmesh.kafka.admin.SmAdminClient;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import picocli.CommandLine;

@CommandLine.Command(name="consumption", description={"Given a spec, break down the consumption volume against each of its topic"})
@SuppressFBWarnings
public class Consumption
implements Callable<Integer> {
    private Map<String, SmAdminClient.ConsumerGroup> state;
    @CommandLine.Option(names={"-bs", "--bootstrap-server"}, description={"Kafka bootstrap server url"})
    private String brokerUrl;
    @CommandLine.Option(names={"-spec", "--spec"}, description={"specmesh specification file"})
    private String spec;
    @CommandLine.Option(names={"-u", "--username"}, description={"username or api key for the cluster connection"})
    private String username;
    @CommandLine.Option(names={"-s", "--secret"}, description={"secret credential for the cluster connection"})
    private String secret;

    public static void main(String[] args) {
        System.exit(new CommandLine((Object)Consumption.builder().build()).execute(args));
    }

    @CommandLine.Option(names={"-D"}, mapFallbackValue="", description={"Specify Java runtime system properties for Apache Kafka. Note: bulk properties can be set via '-Dconfig.properties=somefile.properties "})
    void setProperty(Map<String, String> props) {
        props.forEach((k, v) -> System.setProperty(k, v));
    }

    @Override
    public Integer call() throws Exception {
        SmAdminClient client = SmAdminClient.create((Admin)Clients.adminClient((String)this.brokerUrl, (String)this.username, (String)this.secret));
        KafkaApiSpec apiSpec = this.specMeshSpec();
        List<String> topics = apiSpec.listDomainOwnedTopics().stream().map(NewTopic::name).collect(Collectors.toList());
        TreeMap<String, SmAdminClient.ConsumerGroup> results = new TreeMap<String, SmAdminClient.ConsumerGroup>();
        topics.forEach(topic -> {
            List groups = client.groupsForTopicPrefix(topic);
            groups.forEach(group -> results.put((String)topic, (SmAdminClient.ConsumerGroup)group));
        });
        ObjectMapper mapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        System.out.println(mapper.writeValueAsString(results));
        this.state = results;
        return 0;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="meh")
    public Map<String, SmAdminClient.ConsumerGroup> state() {
        return this.state;
    }

    private KafkaApiSpec specMeshSpec() {
        return KafkaApiSpec.loadFromClassPath((String)this.spec, (ClassLoader)Consumption.class.getClassLoader());
    }

    @Generated
    private static String $default$brokerUrl() {
        return "";
    }

    @Generated
    Consumption(Map<String, SmAdminClient.ConsumerGroup> state, String brokerUrl, String spec, String username, String secret) {
        this.state = state;
        this.brokerUrl = brokerUrl;
        this.spec = spec;
        this.username = username;
        this.secret = secret;
    }

    @Generated
    public static ConsumptionBuilder builder() {
        return new ConsumptionBuilder();
    }

    @Generated
    public String brokerUrl() {
        return this.brokerUrl;
    }

    @Generated
    public String spec() {
        return this.spec;
    }

    @Generated
    public String username() {
        return this.username;
    }

    @Generated
    public String secret() {
        return this.secret;
    }

    @Generated
    public static class ConsumptionBuilder {
        @Generated
        private Map<String, SmAdminClient.ConsumerGroup> state;
        @Generated
        private boolean brokerUrl$set;
        @Generated
        private String brokerUrl$value;
        @Generated
        private String spec;
        @Generated
        private String username;
        @Generated
        private String secret;

        @Generated
        ConsumptionBuilder() {
        }

        @Generated
        public ConsumptionBuilder state(Map<String, SmAdminClient.ConsumerGroup> state) {
            this.state = state;
            return this;
        }

        @Generated
        public ConsumptionBuilder brokerUrl(String brokerUrl) {
            this.brokerUrl$value = brokerUrl;
            this.brokerUrl$set = true;
            return this;
        }

        @Generated
        public ConsumptionBuilder spec(String spec) {
            this.spec = spec;
            return this;
        }

        @Generated
        public ConsumptionBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public ConsumptionBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        @Generated
        public Consumption build() {
            String brokerUrl$value = this.brokerUrl$value;
            if (!this.brokerUrl$set) {
                brokerUrl$value = Consumption.$default$brokerUrl();
            }
            return new Consumption(this.state, brokerUrl$value, this.spec, this.username, this.secret);
        }

        @Generated
        public String toString() {
            return "Consumption.ConsumptionBuilder(state=" + String.valueOf(this.state) + ", brokerUrl$value=" + this.brokerUrl$value + ", spec=" + this.spec + ", username=" + this.username + ", secret=" + this.secret + ")";
        }
    }
}

