/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.mcp.report;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.specmatic.mcp.test.McpAutoTestKt;
import io.specmatic.mcp.test.ScenarioExecutionResult;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/specmatic/mcp/report/McpJsonReport;", "", "executionResults", "", "Lio/specmatic/mcp/test/ScenarioExecutionResult;", "reportBaseDirectory", "", "(Ljava/util/List;Ljava/lang/String;)V", "generate", "", "specmatic-mcp"})
public final class McpJsonReport {
    @NotNull
    private final List<ScenarioExecutionResult> executionResults;
    @NotNull
    private final String reportBaseDirectory;

    public McpJsonReport(@NotNull List<ScenarioExecutionResult> executionResults, @NotNull String reportBaseDirectory) {
        Intrinsics.checkNotNullParameter(executionResults, (String)"executionResults");
        Intrinsics.checkNotNullParameter((Object)reportBaseDirectory, (String)"reportBaseDirectory");
        this.executionResults = executionResults;
        this.reportBaseDirectory = reportBaseDirectory;
    }

    public /* synthetic */ McpJsonReport(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = ".";
        }
        this(list, string);
    }

    public final void generate() {
        try {
            File directory = FilesKt.resolve((File)new File(this.reportBaseDirectory), (String)"./build/reports/specmatic");
            directory.mkdirs();
            File file = new File(directory, "mcp_test_report.json");
            McpAutoTestKt.logWithTag("Saving JSON test report to " + file.getCanonicalPath() + " ...");
            String reportJson = new ObjectMapper().writeValueAsString(this.executionResults);
            Intrinsics.checkNotNull((Object)reportJson);
            FilesKt.writeText$default((File)file, (String)reportJson, null, (int)2, null);
        }
        catch (Throwable e) {
            McpAutoTestKt.logWithTag("Failed to save JSON test report: " + e.getMessage());
        }
    }
}

