/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.mcp.report;

import io.specmatic.core.log.LogStrategy;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.mcp.test.ScenarioExecutionResult;
import io.specmatic.mcp.test.ToolStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\u0007H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/specmatic/mcp/report/McpConsoleReport;", "", "executionResults", "Lkotlin/sequences/Sequence;", "Lio/specmatic/mcp/test/ScenarioExecutionResult;", "(Lkotlin/sequences/Sequence;)V", "generate", "", "printSummary", "specmatic-mcp"})
@SourceDebugExtension(value={"SMAP\nMcpConsoleReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpConsoleReport.kt\nio/specmatic/mcp/report/McpConsoleReport\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n992#2:76\n1021#2,3:77\n1024#2,3:87\n1272#2,3:107\n1272#2,3:110\n381#3,7:80\n126#4:90\n153#4,2:91\n155#4:101\n1782#5,4:93\n1782#5,4:97\n1053#5:102\n1872#5,3:104\n1#6:103\n*S KotlinDebug\n*F\n+ 1 McpConsoleReport.kt\nio/specmatic/mcp/report/McpConsoleReport\n*L\n25#1:76\n25#1:77,3\n25#1:87,3\n63#1:107,3\n64#1:110,3\n25#1:80,7\n26#1:90\n26#1:91,2\n26#1:101\n27#1:93,4\n28#1:97,4\n34#1:102\n50#1:104,3\n*E\n"})
public final class McpConsoleReport {
    @NotNull
    private final Sequence<ScenarioExecutionResult> executionResults;

    public McpConsoleReport(@NotNull Sequence<ScenarioExecutionResult> executionResults) {
        Intrinsics.checkNotNullParameter(executionResults, (String)"executionResults");
        this.executionResults = executionResults;
    }

    /*
     * WARNING - void declaration
     */
    public final void generate() {
        Object object;
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Object list$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        LoggingKt.getLogger().newLine();
        LoggingKt.getLogger().log(StringsKt.repeat((CharSequence)"=", (int)80));
        LoggingKt.getLogger().log("MCP AUTO TEST REPORT");
        LoggingKt.getLogger().log(StringsKt.repeat((CharSequence)"=", (int)80));
        String noHeader = "Sr.";
        String toolNameHeader = "Tool Name";
        String functionalHeader = "Passed";
        String brokenHeader = "Failed";
        String totalHeader = "Total";
        String successRateHeader = "Success %";
        Sequence<ScenarioExecutionResult> sequence = this.executionResults;
        boolean $i$f$groupBy = false;
        void var10_10 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            ScenarioExecutionResult it = (ScenarioExecutionResult)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getToolName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            int n;
            int n2;
            list$iv$iv = item$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            String toolName = (String)list$iv$iv.getKey();
            List results = (List)list$iv$iv.getValue();
            Iterable $this$count$iv = results;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ScenarioExecutionResult it = (ScenarioExecutionResult)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getVerdict(), (Object)"PASSED") || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int functional = n2;
            Iterable $this$count$iv2 = results;
            boolean $i$f$count2 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n = 0;
            } else {
                Object element$iv;
                int count$iv = 0;
                element$iv = $this$count$iv2.iterator();
                while (element$iv.hasNext()) {
                    Object element$iv2 = element$iv.next();
                    ScenarioExecutionResult it = (ScenarioExecutionResult)element$iv2;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getVerdict(), (Object)"FAILED") || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int broken = n;
            int total = results.size();
            double successRate = total > 0 ? (double)functional * 100.0 / (double)total : 0.0;
            object3.add(new ToolStats(toolName, functional, broken, total, successRate));
        }
        $this$map$iv = (List)destination$iv$iv;
        int $i$f$sortedBy = 0;
        List toolStats = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ToolStats it = (ToolStats)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getToolName());
                it = (ToolStats)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getToolName())));
            }
        });
        $i$f$sortedBy = toolNameHeader.length();
        Iterator $i$f$mapTo22 = ((Iterable)toolStats).iterator();
        if (!$i$f$mapTo22.hasNext()) {
            object = null;
        } else {
            Object it = (ToolStats)$i$f$mapTo22.next();
            boolean bl = false;
            it = ((ToolStats)it).getToolName().length();
            while ($i$f$mapTo22.hasNext()) {
                Object it2 = (ToolStats)$i$f$mapTo22.next();
                $i$a$-maxOfOrNull-McpConsoleReport$generate$maxToolNameLength$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(((ToolStats)it2).getToolName().length())) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n = (Integer)object;
        int $this$mapTo$iv$iv2 = n != null ? n : 0;
        int maxToolNameLength = Math.max($i$f$sortedBy, $this$mapTo$iv$iv2);
        int noWidth = 4;
        int functionalWidth = 10;
        int brokenWidth = 8;
        int totalWidth = 6;
        int successRateWidth = 10;
        String headerSeparator = StringsKt.repeat((CharSequence)"-", (int)(noWidth + maxToolNameLength + functionalWidth + brokenWidth + totalWidth + successRateWidth + 17));
        LoggingKt.getLogger().log(headerSeparator);
        LoggingKt.getLogger().log("| " + StringsKt.padEnd$default((String)noHeader, (int)noWidth, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)toolNameHeader, (int)maxToolNameLength, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)functionalHeader, (int)functionalWidth, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)brokenHeader, (int)brokenWidth, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)totalHeader, (int)totalWidth, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)successRateHeader, (int)successRateWidth, (char)'\u0000', (int)2, null) + " |");
        LoggingKt.getLogger().log(headerSeparator);
        Iterable $this$forEachIndexed$iv = toolStats;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String successRateFormatted;
            void stats;
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ToolStats $i$f$count2 = (ToolStats)item$iv;
            int index = n3;
            boolean bl = false;
            String serialNo = String.valueOf(index + 1);
            String string = "%.1f%%";
            Object[] objectArray = new Object[]{stats.getSuccessRate()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
            LoggingKt.getLogger().log("| " + StringsKt.padEnd$default((String)serialNo, (int)noWidth, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)stats.getToolName(), (int)maxToolNameLength, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)String.valueOf(stats.getFunctional()), (int)functionalWidth, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)String.valueOf(stats.getBroken()), (int)brokenWidth, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)String.valueOf(stats.getTotal()), (int)totalWidth, (char)'\u0000', (int)2, null) + " | " + StringsKt.padEnd$default((String)successRateFormatted, (int)successRateWidth, (char)'\u0000', (int)2, null) + " |");
        }
        LoggingKt.getLogger().log(headerSeparator);
        this.printSummary();
    }

    private final void printSummary() {
        int totalScenarios = SequencesKt.toList(this.executionResults).size();
        Sequence<ScenarioExecutionResult> $this$count$iv = this.executionResults;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            ScenarioExecutionResult it = (ScenarioExecutionResult)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getVerdict(), (Object)"PASSED") || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int totalPassed = count$iv;
        Sequence<ScenarioExecutionResult> $this$count$iv2 = this.executionResults;
        boolean $i$f$count2 = false;
        int count$iv2 = 0;
        for (Object element$iv : $this$count$iv2) {
            ScenarioExecutionResult it = (ScenarioExecutionResult)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getVerdict(), (Object)"FAILED") || ++count$iv2 >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int totalFailed = count$iv2;
        double overallSuccessRate = totalScenarios > 0 ? (double)totalPassed * 100.0 / (double)totalScenarios : 0.0;
        LoggingKt.getLogger().newLine();
        LoggingKt.getLogger().log("SUMMARY:");
        LoggingKt.getLogger().log("Total: " + totalScenarios);
        LoggingKt.getLogger().log("Passed: " + totalPassed);
        LoggingKt.getLogger().log("Failed: " + totalFailed);
        LogStrategy logStrategy = LoggingKt.getLogger();
        String string = "%.1f%%";
        Object[] objectArray = new Object[]{overallSuccessRate};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        logStrategy.log("Overall Success Rate: " + string2);
    }
}

