/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.server;

import com.gemstone.gemfire.internal.cache.locks.NonReentrantLock;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineStatement;
import com.pivotal.gemfirexd.internal.jdbc.EmbedXAConnection;
import io.snappydata.thrift.OpenConnectionArgs;
import io.snappydata.thrift.SecurityMechanism;
import io.snappydata.thrift.StatementAttrs;
import io.snappydata.thrift.common.ThriftExceptionUtil;
import io.snappydata.thrift.server.ClientTracker;
import io.snappydata.thrift.server.SnappyDataServiceImpl;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;

final class ConnectionHolder {
    private final EngineConnection conn;
    private final EmbedXAConnection xaConn;
    private final long connId;
    private final Properties props;
    private final ByteBuffer token;
    private final String clientHostName;
    private final String clientID;
    private final String clientHostId;
    private final String userName;
    private final boolean useStringForDecimal;
    private EngineStatement reusableStatement;
    private volatile StatementHolder activeStatement;
    private final ArrayList<StatementHolder> registeredStatements;
    private final NonReentrantLock sync;
    private final long startTime;

    ConnectionHolder(EngineConnection conn, EmbedXAConnection xaConn, OpenConnectionArgs args, long connId, Properties props, SecureRandom rnd) throws SQLException {
        int tokenSize;
        this.conn = conn;
        this.xaConn = xaConn;
        this.connId = connId;
        this.props = props;
        if (args.getSecurity() == SecurityMechanism.PLAIN || args.getSecurity() == SecurityMechanism.DIFFIE_HELLMAN) {
            tokenSize = 16;
            if (args.isSetTokenSize()) {
                if (args.getTokenSize() < tokenSize) {
                    throw ThriftExceptionUtil.newSQLException((String)"08004.C.1", null, (Object[])new Object[]{"specified connection token size " + args.getTokenSize() + " smaller than minimum allowed of " + tokenSize});
                }
                tokenSize = args.getTokenSize();
            }
        } else {
            throw ThriftExceptionUtil.newSQLException((String)"08004.C.1", null, (Object[])new Object[]{"unsupported security mechanism " + args.getSecurity()});
        }
        byte[] rndBytes = new byte[tokenSize];
        rnd.nextBytes(rndBytes);
        this.token = ByteBuffer.wrap(rndBytes);
        this.clientHostName = args.getClientHostName();
        this.clientID = args.getClientID();
        this.clientHostId = ClientTracker.getClientHostId(this.clientHostName, this.clientID);
        this.userName = args.getUserName();
        this.useStringForDecimal = args.isSetUseStringForDecimal() && args.useStringForDecimal;
        this.reusableStatement = (EngineStatement)conn.createStatement();
        this.registeredStatements = new ArrayList(4);
        this.sync = new NonReentrantLock(true);
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EngineStatement createNewStatement(StatementAttrs attrs) throws SQLException {
        int resultSetType = SnappyDataServiceImpl.getResultType(attrs);
        int resultSetConcurrency = SnappyDataServiceImpl.getResultSetConcurrency(attrs);
        int resultSetHoldability = SnappyDataServiceImpl.getResultSetHoldability(attrs);
        this.sync.lock();
        try {
            EngineStatement stmt = this.reusableStatement;
            if (stmt != null) {
                stmt.reset(resultSetType, resultSetConcurrency, resultSetHoldability);
                this.reusableStatement = null;
                EngineStatement engineStatement = stmt;
                return engineStatement;
            }
        }
        finally {
            this.sync.unlock();
        }
        return (EngineStatement)this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    final EngineConnection getConnection() {
        return this.conn;
    }

    final EmbedXAConnection getXAConnection() {
        return this.xaConn;
    }

    final long getConnectionId() {
        return this.connId;
    }

    final Properties getProperties() {
        return this.props;
    }

    final ByteBuffer getToken() {
        return this.token;
    }

    static String getTokenAsString(ByteBuffer token) {
        if (token != null) {
            return ClientSharedUtils.toHexString((ByteBuffer)token);
        }
        return "NULL";
    }

    final String getClientHostName() {
        return this.clientHostName;
    }

    final String getClientID() {
        return this.clientID;
    }

    final String getClientHostId() {
        return this.clientHostId;
    }

    final String getUserName() {
        return this.userName;
    }

    final boolean useStringForDecimal() {
        return this.useStringForDecimal;
    }

    final long getStartTime() {
        return this.startTime;
    }

    void setStatementForReuse(EngineStatement stmt) throws SQLException {
        this.sync.lock();
        try {
            this.setStatementForReuseNoLock(stmt);
        }
        finally {
            this.sync.unlock();
        }
    }

    private void setStatementForReuseNoLock(EngineStatement stmt) throws SQLException {
        if (this.reusableStatement == null) {
            stmt.resetForReuse();
            this.reusableStatement = stmt;
        } else {
            stmt.close();
        }
    }

    StatementHolder getActiveStatement() {
        return this.activeStatement;
    }

    void setActiveStatement(StatementHolder stmtHolder) {
        this.sync.lock();
        this.activeStatement = stmtHolder;
        this.sync.unlock();
    }

    void clearActiveStatement(Statement stmt) {
        if (stmt != null) {
            this.sync.lock();
            StatementHolder activeStatement = this.activeStatement;
            if (activeStatement != null && stmt == activeStatement.stmt) {
                this.activeStatement = null;
            }
            this.sync.unlock();
        }
    }

    StatementHolder newStatementHolder(Statement stmt, StatementAttrs attrs, long stmtId, Object sql, boolean recordStart, String status) {
        long startTime = recordStart ? System.nanoTime() : 0L;
        return new StatementHolder(stmt, attrs, stmtId, sql, startTime, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementHolder registerPreparedStatement(PreparedStatement pstmt, StatementAttrs attrs, long stmtId, String sql, boolean recordStart) {
        StatementHolder stmtHolder;
        this.sync.lock();
        try {
            stmtHolder = this.newStatementHolder(pstmt, attrs, stmtId, sql, recordStart, "PREPARED");
            this.registeredStatements.add(stmtHolder);
            this.activeStatement = stmtHolder;
        }
        finally {
            this.sync.unlock();
        }
        return stmtHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Statement uniqueActiveStatement(boolean skipPrepared) throws SQLException {
        Statement result = null;
        this.sync.lock();
        try {
            StatementHolder activeStatement = this.activeStatement;
            if (activeStatement != null) {
                result = activeStatement.getStatement();
                if (skipPrepared && result instanceof PreparedStatement) {
                    result = null;
                }
            }
            for (StatementHolder holder : this.registeredStatements) {
                Statement stmt = holder.getStatement();
                if (stmt == result || skipPrepared && stmt instanceof PreparedStatement) continue;
                if (result != null) {
                    throw ThriftExceptionUtil.newSQLException((String)"0A000.S.35", null, (Object[])new Object[0]);
                }
                result = stmt;
            }
            Statement statement = result;
            return statement;
        }
        finally {
            this.sync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSetHolder registerResultSet(StatementHolder stmtHolder, ResultSet rs, long cursorId) {
        this.sync.lock();
        try {
            ResultSetHolder holder = stmtHolder.addResultSetNoLock(rs, cursorId);
            this.registeredStatements.add(stmtHolder);
            ResultSetHolder resultSetHolder = holder;
            return resultSetHolder;
        }
        finally {
            this.sync.unlock();
        }
    }

    StatementHolder registerResultSet(Statement stmt, StatementAttrs attrs, long stmtId, ResultSet rs, long cursorId, String sql, boolean recordStart) {
        StatementHolder stmtHolder = this.newStatementHolder(stmt, attrs, stmtId, sql, recordStart, "INIT");
        this.registerResultSet(stmtHolder, rs, cursorId);
        return stmtHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStatement(StatementHolder stmtHolder, SnappyDataServiceImpl service) {
        long stmtId = stmtHolder.getStatementId();
        this.sync.lock();
        try {
            EngineStatement estmt;
            this.removeActiveStatementNoLock(stmtHolder);
            stmtHolder.closeAllResultSets(service);
            Statement stmt = stmtHolder.getStatement();
            if (stmt instanceof EngineStatement && !(estmt = (EngineStatement)stmt).isPrepared()) {
                this.setStatementForReuseNoLock(estmt);
            } else if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.sync.unlock();
            service.statementMap.removePrimitive(stmtId);
        }
    }

    private void removeActiveStatementNoLock(StatementHolder stmtHolder) {
        ArrayList<StatementHolder> statements = this.registeredStatements;
        int size = statements.size();
        while (--size >= 0) {
            if (statements.get(size) != stmtHolder) continue;
            statements.remove(size);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(SnappyDataServiceImpl service, boolean forceClose) {
        block26: {
            if (service.logger.isDebugEnabled()) {
                service.logger.debug("ConnectionHolder closing connection with ID=" + this.connId + " (force=" + forceClose + ')');
            }
            this.sync.lock();
            try {
                for (StatementHolder stmtHolder : this.registeredStatements) {
                    stmtHolder.closeAllResultSets(service);
                    Statement stmt = stmtHolder.getStatement();
                    if (stmt == null) continue;
                    try {
                        if (forceClose) {
                            if (!(stmt instanceof EngineStatement)) continue;
                            EngineStatement estmt = (EngineStatement)stmt;
                            if (!estmt.isClosed()) {
                                estmt.cancel();
                                estmt.resetForReuse();
                            }
                            estmt.clearFinalizer();
                            continue;
                        }
                        stmt.close();
                    }
                    catch (SQLException sqle) {
                        service.logger.error("unexpected exception in Statement.close()", (Throwable)sqle);
                    }
                    finally {
                        service.statementMap.removePrimitive(stmtHolder.getStatementId());
                    }
                }
                EngineStatement reusableStatement = this.reusableStatement;
                if (reusableStatement != null) {
                    try {
                        if (forceClose) {
                            if (!reusableStatement.isClosed()) {
                                reusableStatement.cancel();
                                reusableStatement.resetForReuse();
                            }
                            reusableStatement.clearFinalizer();
                        } else {
                            reusableStatement.close();
                        }
                    }
                    catch (SQLException sqle) {
                        service.logger.error("unexpected exception in Statement.close()", (Throwable)sqle);
                    }
                }
                if (forceClose) {
                    FinalizeObject finalizer = this.conn.getAndClearFinalizer();
                    this.conn.forceClose();
                    if (finalizer != null) {
                        finalizer.clear();
                        finalizer.getHolder().addToPendingQueue(finalizer);
                    }
                    break block26;
                }
                if (this.xaConn != null) {
                    try {
                        this.xaConn.close();
                    }
                    catch (SQLException finalizer) {
                        // empty catch block
                    }
                }
                try {
                    if (!this.conn.isClosed()) {
                        this.conn.close();
                    }
                }
                catch (SQLException sqle) {
                    this.conn.forceClose();
                }
            }
            finally {
                this.sync.unlock();
            }
        }
    }

    final boolean sameToken(ByteBuffer otherId) {
        ByteBuffer connToken = this.token;
        if (connToken == otherId) {
            return true;
        }
        assert (ClientSharedUtils.wrapsFullArray((ByteBuffer)connToken));
        if (otherId != null) {
            if (ClientSharedUtils.wrapsFullArray((ByteBuffer)otherId)) {
                return Arrays.equals(otherId.array(), connToken.array());
            }
            return GemFireXDUtils.equalBuffers(connToken.array(), otherId);
        }
        return false;
    }

    public final int hashCode() {
        return (int)(this.connId ^ this.connId >>> 32);
    }

    final class StatementHolder
    extends ResultSetHolder {
        private final Statement stmt;
        private final StatementAttrs statementAttrs;
        private final long stmtId;
        private final Object sql;
        private final long startTime;
        private volatile String status;
        private volatile int accessFrequency;
        private ArrayList<ResultSetHolder> moreResultSets;

        private StatementHolder(Statement stmt, StatementAttrs attrs, long stmtId, Object sql, long startTime, String status) {
            super(null, 0L, 0);
            this.stmt = stmt;
            this.statementAttrs = attrs;
            this.stmtId = stmtId;
            this.sql = sql;
            this.startTime = startTime;
            this.status = status;
            this.accessFrequency = 1;
        }

        final ConnectionHolder getConnectionHolder() {
            return ConnectionHolder.this;
        }

        final Statement getStatement() {
            return this.stmt;
        }

        final long getStatementId() {
            return this.stmtId;
        }

        final Object getSQL() {
            return this.sql;
        }

        final StatementAttrs getStatementAttrs() {
            return this.statementAttrs;
        }

        final long getStartTime() {
            return this.startTime;
        }

        final String getStatus() {
            return this.status;
        }

        final int getAccessFrequency() {
            return this.accessFrequency;
        }

        final void setStatus(String newStatus) {
            this.status = newStatus;
        }

        final void incrementAccessFrequency() {
            int accessFrequency = this.accessFrequency;
            this.accessFrequency = accessFrequency + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSetHolder addResultSet(ResultSet rs, long cursorId) {
            NonReentrantLock sync = ConnectionHolder.this.sync;
            sync.lock();
            try {
                ResultSetHolder resultSetHolder = this.addResultSetNoLock(rs, cursorId);
                return resultSetHolder;
            }
            finally {
                sync.unlock();
            }
        }

        private ResultSetHolder addResultSetNoLock(ResultSet rs, long cursorId) {
            if (this.resultSet == null) {
                this.resultSet = rs;
                this.rsCursorId = cursorId;
                this.rsOffset = 0;
                return this;
            }
            if (this.moreResultSets == null) {
                this.moreResultSets = new ArrayList(4);
            }
            ResultSetHolder holder = new ResultSetHolder(rs, cursorId, 0);
            this.moreResultSets.add(holder);
            return holder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSetHolder findResultSet(long cursorId) {
            block7: {
                NonReentrantLock sync = ConnectionHolder.this.sync;
                sync.lock();
                try {
                    if (this.rsCursorId == cursorId) {
                        StatementHolder statementHolder = this;
                        return statementHolder;
                    }
                    ArrayList<ResultSetHolder> moreResults = this.moreResultSets;
                    if (moreResults == null) break block7;
                    for (ResultSetHolder holder : moreResults) {
                        if (holder.rsCursorId != cursorId) continue;
                        ResultSetHolder resultSetHolder = holder;
                        return resultSetHolder;
                    }
                }
                finally {
                    sync.unlock();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSet removeResultSet(long cursorId) {
            block10: {
                NonReentrantLock sync = ConnectionHolder.this.sync;
                sync.lock();
                try {
                    if (this.rsCursorId == cursorId) {
                        Object holder;
                        ResultSet rs = this.resultSet;
                        ArrayList<ResultSetHolder> moreResults = this.moreResultSets;
                        if (moreResults != null) {
                            holder = moreResults.remove(moreResults.size() - 1);
                            this.resultSet = ((ResultSetHolder)holder).resultSet;
                            this.rsCursorId = ((ResultSetHolder)holder).rsCursorId;
                            this.rsOffset = ((ResultSetHolder)holder).rsOffset;
                        } else {
                            this.resultSet = null;
                            this.rsCursorId = 0L;
                            this.rsOffset = 0;
                        }
                        holder = rs;
                        return holder;
                    }
                    ArrayList<ResultSetHolder> moreResults = this.moreResultSets;
                    if (moreResults == null) break block10;
                    Iterator<ResultSetHolder> itr = moreResults.iterator();
                    while (itr.hasNext()) {
                        ResultSetHolder holder = itr.next();
                        if (holder.rsCursorId != cursorId) continue;
                        itr.remove();
                        if (moreResults.isEmpty()) {
                            this.moreResultSets = null;
                        }
                        ResultSet resultSet = holder.resultSet;
                        return resultSet;
                    }
                }
                finally {
                    sync.unlock();
                }
            }
            return null;
        }

        void closeResultSet(long cursorId, SnappyDataServiceImpl service) {
            ResultSet rs = this.removeResultSet(cursorId);
            if (rs != null) {
                service.resultSetMap.removePrimitive(cursorId);
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeAllResultSets(SnappyDataServiceImpl service) {
            ResultSet rs = this.resultSet;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {
                    service.logger.error("unexpected exception in ResultSet.close()", (Throwable)sqle);
                }
                finally {
                    service.resultSetMap.removePrimitive(this.rsCursorId);
                    this.resultSet = null;
                    this.rsCursorId = 0L;
                    this.rsOffset = 0;
                }
                ArrayList<ResultSetHolder> moreResults = this.moreResultSets;
                if (moreResults != null) {
                    for (ResultSetHolder holder : moreResults) {
                        try {
                            holder.resultSet.close();
                        }
                        catch (SQLException sqle) {
                            service.logger.error("unexpected exception in ResultSet.close()", (Throwable)sqle);
                        }
                        finally {
                            service.resultSetMap.removePrimitive(holder.rsCursorId);
                        }
                    }
                    this.moreResultSets = null;
                }
            }
        }
    }

    static class ResultSetHolder {
        protected ResultSet resultSet;
        protected long rsCursorId;
        protected int rsOffset;

        ResultSetHolder(ResultSet rs, long cursorId, int offset) {
            this.resultSet = rs;
            this.rsCursorId = cursorId;
            this.rsOffset = offset;
        }
    }
}

