/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.sizer;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSParallelGatewaySenderQueue;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisee;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.ProxyBucketRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.cache.partitioned.PREntriesIterator;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderQueue;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTHashSet;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.gemstone.gnu.trove.TObjectIdentityHashingStrategy;
import com.pivotal.gemfirexd.Constants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableHashtable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.snappy.ColumnBatchKey;
import com.pivotal.gemfirexd.tools.sizer.GemFireXDInstrumentation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

public class ObjectSizer {
    static GemFireXDInstrumentation SIZE_OF_UTIL = GemFireXDInstrumentation.getInstance();
    static final com.gemstone.gemfire.cache.util.ObjectSizer GEM_SIZER = o -> (int)SIZE_OF_UTIL.sizeof(o);
    private static final ObjectSizer _this = new ObjectSizer();
    static Runtime runtime = Runtime.getRuntime();
    private boolean withMemoryFootPrint;
    private boolean logObjectGraph;
    private boolean logTopConsumers;
    private boolean traceOutput;
    private boolean traceVerbose;
    private boolean withSecondaries;
    private boolean initializeMode = true;
    private boolean isForInternalUse = false;
    private final Map<Object, ArrayList<Object>> initialset = new IdentityHashMap<Object, ArrayList<Object>>();
    private final THashMap seen = new THashMap((TObjectHashingStrategy)TObjectIdentityHashingStrategy.getInstance());
    private final HashMap<Class<?>, Pair> classBreakup = new HashMap();
    private long gemfirexdSize = 0L;
    private long gfeSize = 0L;
    private long othersSize = 0L;
    private String keyDelimeter;
    public static final String logPrefix = "objectsizer: ";
    public static final String sizerHints = "gemfirexd.__rt..sizerHints";
    public static final long SZ_REF = ReflectionSingleObjectSizer.REFERENCE_SIZE;
    LinkedBlockingDeque<ClassTraverser> sink = new LinkedBlockingDeque();

    private ObjectSizer() {
    }

    public static ObjectSizer getInstance(boolean isNew) {
        return isNew ? new ObjectSizer() : _this;
    }

    public void initialize(boolean isForInternalUse, String keyDelimiter) {
        this.initializeMode = true;
        this.withMemoryFootPrint = false;
        this.logObjectGraph = false;
        this.logTopConsumers = false;
        this.traceOutput = false;
        this.traceVerbose = false;
        this.withSecondaries = true;
        this.isForInternalUse = isForInternalUse;
        this.keyDelimeter = keyDelimiter;
        GemFireContainer regionContainer = null;
        GemFireContainer indexContainer = null;
        for (GemFireContainer c : Misc.getMemStore().getAllContainers()) {
            if (c == null) continue;
            LocalRegion region = c.getRegion();
            if (region == null) {
                if (c.getBaseContainer() == null || indexContainer != null || !c.getBaseContainer().getQualifiedTableName().equalsIgnoreCase("SYS.SYSTABLES")) continue;
                indexContainer = c;
                continue;
            }
            if (!c.getQualifiedTableName().equalsIgnoreCase("SYS.SYSTABLES")) continue;
            regionContainer = c;
        }
        if (!(regionContainer != null && indexContainer != null || this.isForInternalUse)) {
            SanityManager.THROWASSERT((String)("ObjectSizer: No initialization regions found, table=" + regionContainer + ", index=" + indexContainer));
        }
        try {
            if (this.withMemoryFootPrint) {
                if (!this.isForInternalUse) {
                    SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Initializing region footprint with " + regionContainer));
                }
                this.determineRegionMemoryFootPrint(regionContainer, null, null, null);
                if (!this.isForInternalUse) {
                    SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Initializing index footprint with " + indexContainer));
                }
                this.estimateIndexFootPrint(indexContainer);
                this.initializeMode = false;
            }
        }
        catch (Exception e) {
            throw GemFireXDRuntimeException.newRuntimeException("GfxdConfigMessage#getTargetContainers", e);
        }
        finally {
            this.reset(true);
        }
    }

    public void setForInternalUse(boolean isForInternalUse) {
        this.isForInternalUse = isForInternalUse;
    }

    public void setQueryHints(FormatableHashtable queryHints) {
        if (queryHints == null) {
            return;
        }
        Object o = queryHints.get(sizerHints);
        if (o != null) {
            String[] settings;
            assert (o instanceof String);
            block9: for (String v : settings = ((String)o).split(",")) {
                Constants.QueryHints.SizerHints hint;
                if (v == null || v.length() <= 0) continue;
                try {
                    hint = Constants.QueryHints.SizerHints.valueOf(v);
                }
                catch (RuntimeException re) {
                    continue;
                }
                switch (hint) {
                    case withMemoryFootPrint: {
                        this.withMemoryFootPrint = true;
                        continue block9;
                    }
                    case logObjectReferenceGraph: {
                        this.logObjectGraph = true;
                        continue block9;
                    }
                    case logTopConsumers: {
                        this.logTopConsumers = true;
                        continue block9;
                    }
                    case traceOutput: {
                        this.traceOutput = true;
                        continue block9;
                    }
                    case traceVerbose: {
                        this.traceVerbose = true;
                        continue block9;
                    }
                }
            }
        }
        if ((o = queryHints.get(Constants.QueryHints.withSecondaries.name())) != null) {
            assert (o instanceof String);
            this.withSecondaries = Boolean.parseBoolean((String)o);
        }
    }

    public static void getTargetContainers(ArrayList<GemFireContainer> targetRegions) {
        for (GemFireContainer c : Misc.getMemStore().getAllContainers()) {
            if (c == null || !c.isApplicationTable() || c.isTemporaryContainer() || !c.isInitialized()) continue;
            targetRegions.add(c);
        }
    }

    public void logSizes(LinkedHashMap<String, Object[]> sizes) {
        long totalSz = 0L;
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, Object[]>> sz = sizes.entrySet().iterator();
        int i = 0;
        int size = sizes.size();
        while (sz.hasNext()) {
            Map.Entry<String, Object[]> sze = sz.next();
            String profiledObjectName = sze.getKey();
            long[] szeVal = (long[])sze.getValue()[0];
            long gemfirexdSize = szeVal[0];
            long gfeSize = szeVal[1];
            long otherSize = szeVal[2];
            totalSz += gemfirexdSize + gfeSize + otherSize;
            if (i == 0) {
                sb.append(logPrefix).append("Table (").append(profiledObjectName).append("\n\tsize ").append(totalSz).append(" = ").append(gemfirexdSize).append("+").append(gfeSize).append("+").append(otherSize).append(" (").append((double)totalSz / 1048576.0).append(" mb)").append("\n");
            } else if (i < size - 1) {
                long tSz = gemfirexdSize + gfeSize + otherSize;
                sb.append("\t").append(logPrefix).append("Index (").append(profiledObjectName).append(") ").append(tSz).append(" = ").append(gemfirexdSize).append("+").append(gfeSize).append("+").append(otherSize).append(" (").append((double)tSz / 1048576.0).append(" mb)").append("\n");
            } else {
                long entrySz = szeVal[0];
                long entryCount = szeVal[1];
                long maxEntrySz = szeVal[2];
                sb.append("\t").append(logPrefix).append("Region Entry Size ").append(entrySz).append(" (").append((double)entrySz / 1048576.0).append(" mb) for ").append(entryCount).append(" rows with max entry size ").append(maxEntrySz).append("\n");
            }
            ++i;
        }
        sb.append("\t\t").append(logPrefix).append("Total: ").append(totalSz).append(" (").append((double)totalSz / 1048576.0).append(" mb) ").append("\n");
        if (!this.isForInternalUse) {
            SanityManager.DEBUG_PRINT((String)"info:LOG_SIZES", (String)sb.toString());
        }
    }

    public long sizeOfObject(Object root, Exclusions exclusions) throws IllegalArgumentException, IllegalAccessException, InterruptedException {
        if (exclusions == null) {
            exclusions = new Exclusions();
        }
        long retVal = this.startEstimation(root, exclusions);
        this.reset(false);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, Object[]> size(GemFireContainer c, PreQualifier preQualifier) throws IllegalArgumentException, IllegalAccessException, InterruptedException, StandardException {
        LinkedHashMap<String, Object[]> retEstimates = new LinkedHashMap<String, Object[]>();
        try {
            String baseTableContainerName = c.getQualifiedTableName();
            LocalRegion reg = c.getRegion();
            GfxdIndexManager idxMgr = (GfxdIndexManager)reg.getIndexUpdater();
            List<GemFireContainer> indexes = idxMgr != null ? idxMgr.getAllIndexes() : Collections.emptyList();
            this.estimateRegionEntryValueSizes(c, retEstimates, preQualifier);
            if (!this.isForInternalUse) {
                Set<GatewaySender> senders = c.getGatewaySenders(c.getRegion());
                Set<AsyncEventQueue> asyncQueues = c.getAsyncEventQueues(c.getRegion());
                this.estimateQueueSizes(c, senders, asyncQueues, retEstimates, baseTableContainerName, preQualifier);
            }
            this.estimateIndexEntryValueSizes(baseTableContainerName, indexes, retEstimates, preQualifier);
            this.reset(true);
            if (this.withMemoryFootPrint) {
                this.determineRegionMemoryFootPrint(c, baseTableContainerName, retEstimates, preQualifier);
                this.determineIndexMemoryFootPrint(baseTableContainerName, indexes, retEstimates, preQualifier);
            }
        }
        finally {
            this.initializeMode = false;
            this.reset(true);
        }
        return retEstimates.size() > 0 ? retEstimates : null;
    }

    public void done() {
        this.initialset.clear();
        this.initializeMode = true;
        this.cleanupGarbage();
    }

    public long getConsumedMemory() throws InterruptedException {
        this.cleanupGarbage();
        if (!this.isForInternalUse) {
            System.out.println("objectsizer: Total: " + runtime.totalMemory() + " free " + runtime.freeMemory());
        }
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private void estimateRegionEntryValueSizes(GemFireContainer c, LinkedHashMap<String, Object[]> retEstimates, PreQualifier preQualifier) throws StandardException {
        long constantOverhead = c.estimateMemoryOverhead(SIZE_OF_UTIL);
        if (preQualifier != null && !preQualifier.qualifyPartialRow(c.getQualifiedTableName(), null, null, null, null, constantOverhead)) {
            return;
        }
        if (!this.isForInternalUse) {
            SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Estimating Entry Size/Value Size for " + c));
        }
        String containerName = c.getQualifiedTableName();
        Iterator<?> entryIter = c.getEntrySetIterator(null, !this.withSecondaries, 0, false);
        this.iterateRegionEntries(c, retEstimates, containerName, constantOverhead, entryIter);
    }

    private void estimateQueueSizes(GemFireContainer container, Set<GatewaySender> senders, Set<AsyncEventQueue> asyncQueues, LinkedHashMap<String, Object[]> retEstimates, String baseTableContainerName, PreQualifier preQualifier) throws StandardException {
        long constantOverhead;
        for (AsyncEventQueue q : asyncQueues) {
            AsyncEventQueueImpl asyncQ = (AsyncEventQueueImpl)q;
            constantOverhead = asyncQ.estimateMemoryFootprint((SingleObjectSizer)SIZE_OF_UTIL);
            String qId = q.getId();
            String qType = (q.isParallel() ? "PARALLEL " : "SERIAL ") + (qId.startsWith("GEMFIRE_HDFS_BUCKETSORTED_QUEUE") ? "HDFS " : "") + "QUEUE";
            if (preQualifier != null && !preQualifier.qualifyPartialRow(baseTableContainerName, null, null, qId, qType, constantOverhead)) continue;
            SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Estimating Entry Size/Value Size for asyncqueue " + qId));
            this.iterateRegionQueue(container, asyncQ.getSender().getQueues(), retEstimates, baseTableContainerName + this.keyDelimeter + "" + this.keyDelimeter + "" + this.keyDelimeter + qId + this.keyDelimeter + qType, constantOverhead);
        }
        for (GatewaySender g : senders) {
            AbstractGatewaySender sender = (AbstractGatewaySender)g;
            constantOverhead = sender.estimateMemoryFootprint((SingleObjectSizer)SIZE_OF_UTIL);
            String qType = (g.isParallel() ? "PARALLEL " : "SERIAL ") + "GATEWAY";
            if (preQualifier != null && !preQualifier.qualifyPartialRow(baseTableContainerName, null, null, g.getId(), qType, constantOverhead)) continue;
            SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Estimating Entry Size/Value Size for gateway " + g.getId()));
            this.iterateRegionQueue(container, sender.getQueues(), retEstimates, baseTableContainerName + this.keyDelimeter + "" + this.keyDelimeter + "" + this.keyDelimeter + g.getId() + this.keyDelimeter + qType, constantOverhead);
        }
    }

    private void iterateRegionQueue(GemFireContainer container, Set<RegionQueue> queues, LinkedHashMap<String, Object[]> retEstimates, String key, long constantOverhead) throws StandardException {
        for (RegionQueue q : queues) {
            LocalRegion r;
            Class<?> c = q.getClass();
            if (c == SerialGatewaySenderQueue.class) {
                SerialGatewaySenderQueue serialQ = (SerialGatewaySenderQueue)q;
                r = (LocalRegion)serialQ.getRegion();
            } else if (c == ConcurrentParallelGatewaySenderQueue.class) {
                ConcurrentParallelGatewaySenderQueue parallelQ = (ConcurrentParallelGatewaySenderQueue)q;
                r = (LocalRegion)parallelQ.getRegion();
            } else if (c == HDFSParallelGatewaySenderQueue.class) {
                HDFSParallelGatewaySenderQueue hdfsParallelQ = (HDFSParallelGatewaySenderQueue)q;
                r = (LocalRegion)hdfsParallelQ.getRegion();
            } else {
                SanityManager.THROWASSERT((String)("UnKnown Queue type " + c));
                r = null;
                throw StandardException.newException("0A000.S.33");
            }
            Iterator<?> entryIter = GemFireContainer.getEntrySetIteratorForRegion(r);
            this.iterateRegionEntries(container, retEstimates, key, constantOverhead, entryIter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void iterateRegionEntries(GemFireContainer c, LinkedHashMap<String, Object[]> retEstimates, String key, long constantOverhead, Iterator<?> entryIter) throws StandardException {
        if (!this.isForInternalUse && entryIter instanceof PREntriesIterator) {
            prEntryIter = (PREntriesIterator)entryIter;
            generatDistributionInfo = true;
        } else {
            prEntryIter = null;
            generatDistributionInfo = false;
        }
        isSingleEntrySizeComputed = false;
        singleEntrySize = 0L;
        entrySize = 0L;
        keySize = 0L;
        valInMemorySize = 0L;
        valInOffheapSize = 0L;
        maxSize = 0L;
        maxOffheapSize = 0L;
        rowCount = 0L;
        columnRowCount = 0L;
        keyInMemoryCount = 0L;
        valInMemoryCount = 0L;
        valInOffheapCount = 0L;
        agentAttached = ObjectSizer.SIZE_OF_UTIL.isAgentAttached();
        isValueTypeEvaluated = false;
        isColumnTable = c.isColumnStore();
        numColumnsInColumnTable = -1;
        dvdArraySize = 0L;
        gatewayEntries = false;
        offHeapEntries = false;
        region = c.getRegion();
        maxPrimaryBucketKeyLength = 0;
        maxSecondaryBucketKeyLength = 0;
        maxPrimaryBucketValueLength = 0;
        maxSecondaryBucketValueLength = 0;
        primaryBucketDist = generatDistributionInfo != false ? new TreeMap<Integer, Long>() : null;
        secondaryBucketDist = generatDistributionInfo != false ? new TreeMap<Integer, Long>() : null;
        currentBucketEntryCount = 0L;
        currentBucketId = -1;
        while (entryIter.hasNext()) {
            block64: {
                block65: {
                    entry = entryIter.next();
                    if (entry == null) continue;
                    ++rowCount;
                    if (generatDistributionInfo) {
                        if (!ObjectSizer.$assertionsDisabled && prEntryIter == null) {
                            throw new AssertionError();
                        }
                        ++currentBucketEntryCount;
                        if (currentBucketId != prEntryIter.getBucketId()) {
                            if (currentBucketId != -1 && currentBucketEntryCount > 0L) {
                                if (prEntryIter.getBucket().getBucketAdvisor().isPrimary()) {
                                    primaryBucketDist.put(currentBucketId, currentBucketEntryCount);
                                    len = Misc.getLength(currentBucketId);
                                    maxPrimaryBucketKeyLength = len > maxPrimaryBucketKeyLength ? len : maxPrimaryBucketKeyLength;
                                    len = Misc.getLength(currentBucketEntryCount);
                                    maxPrimaryBucketValueLength = len > maxPrimaryBucketValueLength ? len : maxPrimaryBucketValueLength;
                                } else {
                                    secondaryBucketDist.put(currentBucketId, currentBucketEntryCount);
                                    len = Misc.getLength(currentBucketId);
                                    maxSecondaryBucketKeyLength = len > maxSecondaryBucketKeyLength ? len : maxSecondaryBucketKeyLength;
                                    len = Misc.getLength(currentBucketEntryCount);
                                    maxSecondaryBucketValueLength = len > maxSecondaryBucketValueLength ? len : maxSecondaryBucketValueLength;
                                }
                            }
                            currentBucketId = prEntryIter.getBucketId();
                            currentBucketEntryCount = 0L;
                        }
                    }
                    if (agentAttached) {
                        entrySize += ObjectSizer.SIZE_OF_UTIL.sizeof(entry);
                        if (entry instanceof DiskEntry) {
                            entrySize += ObjectSizer.SIZE_OF_UTIL.sizeof(((DiskEntry)entry).getDiskId());
                        }
                    } else if (!isSingleEntrySizeComputed) {
                        singleEntrySize = ObjectSizer.SIZE_OF_UTIL.sizeof(entry);
                        if (entry instanceof DiskEntry) {
                            singleEntrySize += ObjectSizer.SIZE_OF_UTIL.sizeof(((DiskEntry)entry).getDiskId());
                        }
                        isSingleEntrySizeComputed = true;
                    }
                    value = null;
                    batchKey = null;
                    re = null;
                    if (entry instanceof RowLocation) {
                        rl = (RowLocation)entry;
                        k = rl.getRawKey();
                        if (entry instanceof AbstractRegionEntry) {
                            re = (AbstractRegionEntry)entry;
                            SimpleMemoryAllocatorImpl.skipRefCountTracking();
                            value = RegionEntryUtils.getValueInVM((RegionEntry)((AbstractRegionEntry)entry), (RegionEntryContext)region);
                            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                        } else {
                            SimpleMemoryAllocatorImpl.skipRefCountTracking();
                            value = rl.getValueWithoutFaultIn(c);
                            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                        }
                    } else {
                        if (!ObjectSizer.$assertionsDisabled && !(entry instanceof AbstractRegionEntry)) {
                            throw new AssertionError();
                        }
                        re = (AbstractRegionEntry)entry;
                        k = re.getRawKey();
                        if (!ObjectSizer.$assertionsDisabled && k == null) {
                            throw new AssertionError();
                        }
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        value = re.getValue((RegionEntryContext)c.getRegion());
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                    }
                    if (k != null) {
                        ++keyInMemoryCount;
                        if (isColumnTable) {
                            batchKey = (ColumnBatchKey)k;
                            keySize += (long)batchKey.getSizeInBytes();
                        } else {
                            keySize += (long)CachedDeserializableFactory.calcMemSize((Object)k, (com.gemstone.gemfire.cache.util.ObjectSizer)ObjectSizer.GEM_SIZER, (boolean)true);
                        }
                    }
                    if (agentAttached) break block64;
                    if (value == null) break block65;
                    if (!isValueTypeEvaluated) {
                        if (isColumnTable) {
                            numColumnsInColumnTable = batchKey.getNumColumnsInTable(c.getQualifiedTableName());
                        } else if (value instanceof DataValueDescriptor[]) {
                            dvdArraySize = ObjectSizer.SIZE_OF_UTIL.sizeof(value);
                        } else if (value instanceof GatewaySenderEventImpl) {
                            gatewayEntries = true;
                        } else if (value instanceof SimpleMemoryAllocatorImpl.Chunk) {
                            offHeapEntries = true;
                        }
                        isValueTypeEvaluated = true;
                    }
                    if (isColumnTable) {
                        valueSize = ((Sizeable)value).getSizeInBytes();
                        columnRowCount += (long)batchKey.getColumnBatchRowCount(prEntryIter.getHostedBucketRegion(), re, numColumnsInColumnTable);
                        ++valInMemoryCount;
                        valInMemorySize += (long)valueSize;
                        if ((long)valueSize > maxSize) {
                            maxSize = valueSize;
                        }
                        break block65;
                    }
                    if (dvdArraySize > 0L) {
                        dvds = (DataValueDescriptor[])value;
                        ++valInMemoryCount;
                        valInMemorySize += dvdArraySize;
                        var58_48 = dvds;
                        var59_52 = var58_48.length;
                        for (var60_61 = 0; var60_61 < var59_52; ++var60_61) {
                            v = var58_48[var60_61];
                            valInMemorySize += (long)CachedDeserializableFactory.calcMemSize((Object)v.getObject(), (com.gemstone.gemfire.cache.util.ObjectSizer)ObjectSizer.GEM_SIZER, (boolean)true);
                        }
                        break block65;
                    }
                    if (gatewayEntries) {
                        event = (GatewaySenderEventImpl)value;
                        offHeapSize = 0;
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        value = event.getRawValue();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                        if (value instanceof SimpleMemoryAllocatorImpl.Chunk) {
                            chunkVal = (SimpleMemoryAllocatorImpl.Chunk)value;
                            ++valInOffheapCount;
                            offHeapSize = chunkVal.getSizeInBytes();
                            valInOffheapSize += (long)offHeapSize;
                            if ((long)offHeapSize > maxOffheapSize) {
                                maxOffheapSize = offHeapSize;
                            }
                        }
                        ++valInMemoryCount;
                        eventSize = event.getSizeInBytes() - offHeapSize;
                        valInMemorySize += (long)eventSize;
                        if ((long)eventSize > maxSize) {
                            maxSize = eventSize;
                        }
                        break block65;
                    }
                    if (offHeapEntries) {
                        chunkVal = (SimpleMemoryAllocatorImpl.Chunk)value;
                        offHeapSize = chunkVal.getSizeInBytes();
                        ++valInOffheapCount;
                        valInOffheapSize += (long)offHeapSize;
                        if ((long)offHeapSize > maxOffheapSize) {
                            maxOffheapSize = offHeapSize;
                        }
                        break block65;
                    }
                    valueSize = CachedDeserializableFactory.calcMemSize((Object)value, (com.gemstone.gemfire.cache.util.ObjectSizer)ObjectSizer.GEM_SIZER, (boolean)true);
                    ++valInMemoryCount;
                    valInMemorySize += (long)valueSize;
                    if ((long)valueSize <= maxSize) break block65;
                    maxSize = valueSize;
                }
                OffHeapHelper.releaseWithNoTracking((Object)value);
                continue;
            }
            try {
                while (value != null) {
                    valClass = value.getClass();
                    if (valClass == byte[].class) {
                        ++valInMemoryCount;
                        len = ObjectSizer.SIZE_OF_UTIL.sizeof(value);
                        valInMemorySize += len;
                        if (len <= maxSize) ** GOTO lbl258
                        maxSize = len;
                    }
                    if (valClass == byte[][].class) {
                        if (c.isColumnStore()) {
                            columnRowCount += (long)this.getRowCountFromColumnTable(c, (byte[][])value);
                        }
                        ++valInMemoryCount;
                        values /* !! */  = (byte[][])value;
                        len = ObjectSizer.SIZE_OF_UTIL.sizeof(value);
                        for (byte[] val : values /* !! */ ) {
                            if (val == null) continue;
                            len += ObjectSizer.SIZE_OF_UTIL.sizeof(val);
                        }
                        valInMemorySize += len;
                        if (len <= maxSize) ** GOTO lbl258
                        maxSize = len;
                    }
                    if (valClass == DataValueDescriptor[].class) {
                        ++valInMemoryCount;
                        valInMemorySize += ObjectSizer.SIZE_OF_UTIL.sizeof(value);
                        values /* !! */  = (byte[][])((DataValueDescriptor[])value);
                        len = values /* !! */ .length;
                        for (var60_61 = 0; var60_61 < len; ++var60_61) {
                            v = values /* !! */ [var60_61];
                            valInMemorySize += ObjectSizer.SIZE_OF_UTIL.sizeof(v.getObject());
                        }
                    }
                    if (valClass == OffHeapRowWithLobs.class) {
                        ++valInOffheapCount;
                        bs = (OffHeapRowWithLobs)value;
                        len = bs.getSize();
                        for (index = bs.readNumLobsColumns(true); index >= 1; --index) {
                            len += (long)bs.getLobDataSizeLength(index);
                        }
                        valInOffheapSize += len;
                        if (len <= maxOffheapSize) ** GOTO lbl258
                        maxOffheapSize = len;
                    }
                    if (valClass == OffHeapRow.class) {
                        ++valInOffheapCount;
                        bs = (OffHeapRow)value;
                        len = bs.getSize();
                        valInOffheapSize += len;
                        if (len <= maxOffheapSize) ** GOTO lbl258
                        maxOffheapSize = len;
                    }
                    if (SimpleMemoryAllocatorImpl.Chunk.class.isAssignableFrom(valClass)) {
                        ++valInOffheapCount;
                        chunkVal = (SimpleMemoryAllocatorImpl.Chunk)value;
                        len = chunkVal.getSizeInBytes();
                        valInOffheapSize += len;
                        if (len <= maxOffheapSize) ** GOTO lbl258
                        maxOffheapSize = len;
                    }
                    if (GatewaySenderEventImpl.class.isAssignableFrom(valClass)) {
                        valInMemorySize += ObjectSizer.SIZE_OF_UTIL.sizeof(value);
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        value = ((GatewaySenderEventImpl)value).getRawValue();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                        if (!(value instanceof SimpleMemoryAllocatorImpl.Chunk)) continue;
                        chunkVal = (SimpleMemoryAllocatorImpl.Chunk)value;
                        ++valInOffheapCount;
                        valInMemorySize += ObjectSizer.SIZE_OF_UTIL.sizeof(chunkVal);
                        len = chunkVal.getSize();
                        if (value instanceof OffHeapRowWithLobs) {
                            ohbytes = (OffHeapRowWithLobs)chunkVal;
                            for (index = ohbytes.readNumLobsColumns(true); index >= 1; --index) {
                                len += ohbytes.getLobDataSizeLength(index);
                            }
                        }
                        valInOffheapSize += (long)len;
                        if ((long)len <= maxOffheapSize) ** GOTO lbl258
                        maxOffheapSize = len;
                    }
                    SanityManager.THROWASSERT((String)("UnHandled Value Type " + valClass));
                }
                break block3;
            }
            catch (Throwable var65_71) {
                OffHeapHelper.releaseWithNoTracking(value);
                throw var65_71;
            }
lbl258:
            // 15 sources

            OffHeapHelper.releaseWithNoTracking((Object)value);
        }
        ** GOTO lbl258
        if (isSingleEntrySizeComputed) {
            entrySize = rowCount * singleEntrySize;
        }
        bucketDistInfo = new StringBuilder();
        if (generatDistributionInfo && primaryBucketDist.size() > 0) {
            ObjectSizer.createDistributionInfo(bucketDistInfo, "Primary Bucket Distribution: ", primaryBucketDist, maxPrimaryBucketKeyLength, maxPrimaryBucketValueLength);
            primaryBucketDist.clear();
        }
        if (generatDistributionInfo && secondaryBucketDist.size() > 0) {
            ObjectSizer.createDistributionInfo(bucketDistInfo, "Secondary Bucket Distribution: ", secondaryBucketDist, maxSecondaryBucketKeyLength, maxSecondaryBucketValueLength);
            secondaryBucketDist.clear();
        }
        if ((val = retEstimates.get(key)) == null) {
            retEstimates.put(key, new Object[]{new long[]{constantOverhead, entrySize, keySize, valInMemorySize, valInOffheapSize, rowCount, keyInMemoryCount, valInMemoryCount, valInOffheapCount, columnRowCount}, bucketDistInfo});
        } else {
            numericVals = (long[])val[0];
            i = 0;
            v0 = i++;
            numericVals[v0] = numericVals[v0] + constantOverhead;
            v1 = i++;
            numericVals[v1] = numericVals[v1] + entrySize;
            v2 = i++;
            numericVals[v2] = numericVals[v2] + keySize;
            v3 = i++;
            numericVals[v3] = numericVals[v3] + valInMemorySize;
            v4 = i++;
            numericVals[v4] = numericVals[v4] + valInOffheapSize;
            v5 = i++;
            numericVals[v5] = numericVals[v5] + rowCount;
            v6 = i++;
            numericVals[v6] = numericVals[v6] + keyInMemoryCount;
            v7 = i++;
            numericVals[v7] = numericVals[v7] + valInMemoryCount;
            v8 = i++;
            numericVals[v8] = numericVals[v8] + valInOffheapCount;
            v9 = i++;
            numericVals[v9] = numericVals[v9] + columnRowCount;
            if (bucketDistInfo.length() > 0) {
                info = (StringBuilder)val[1];
                info.append((CharSequence)bucketDistInfo);
            }
        }
    }

    private int getRowCountFromColumnTable(GemFireContainer c, byte[][] value) throws StandardException {
        int rowCount = 0;
        RowFormatter rf = c.getRowFormatter(value);
        ColumnDescriptor cd = c.getTableDescriptor().getColumnDescriptor("NUMROWS");
        if (cd != null) {
            rowCount = rf.getColumn(cd.getPosition(), value).getInt();
        }
        return rowCount;
    }

    private static void createDistributionInfo(StringBuilder miscInfo, String msg, TreeMap<Integer, Long> bucketDist, int maxKeyLength, int maxValueLength) {
        TreeSet<Map.Entry<Integer, Long>> bucketsByValue = Misc.sortByValue(bucketDist);
        Long min = bucketsByValue.last().getValue();
        Long max = bucketsByValue.first().getValue();
        int numIntervals = (int)Math.ceil(Math.sqrt(bucketDist.size()));
        miscInfo.append(msg).append(bucketDist.size()).append(" buckets with min ").append(min).append(" entries and max ").append(max).append(" entries.").append(SanityManager.lineSeparator);
        if (bucketDist.size() < 113) {
            boolean isFirst = true;
            int columns = 0;
            for (Map.Entry<Integer, Long> e : bucketsByValue) {
                int l;
                ++columns;
                if (isFirst) {
                    miscInfo.append("{");
                    isFirst = false;
                } else {
                    miscInfo.append(",");
                }
                miscInfo.append("B");
                for (l = Misc.getLength(e.getKey()); l < maxKeyLength; ++l) {
                    miscInfo.append('0');
                }
                miscInfo.append(e.getKey()).append("=");
                for (l = Misc.getLength(e.getValue()); l < maxValueLength; ++l) {
                    miscInfo.append(' ');
                }
                miscInfo.append(e.getValue());
                if (columns < numIntervals) continue;
                miscInfo.append(SanityManager.lineSeparator);
                columns = 0;
            }
            miscInfo.append("}").append(SanityManager.lineSeparator);
        }
        miscInfo.append(SanityManager.lineSeparator);
        Misc.histogramToString(Misc.createHistogram(null, bucketsByValue), miscInfo);
        miscInfo.append(SanityManager.lineSeparator);
    }

    public void estimateIndexEntryValueSizes(String baseTableContainerName, List<GemFireContainer> indexes, LinkedHashMap<String, Object[]> retEstimates, PreQualifier preQualifier) throws StandardException, IllegalArgumentException, IllegalAccessException, InterruptedException {
        for (GemFireContainer index : indexes) {
            if (!index.isLocalIndex()) continue;
            String indexName = index.getTableName();
            String indexType = "LOCAL";
            long constantOverhead = index.estimateMemoryOverhead(SIZE_OF_UTIL);
            if (preQualifier != null && !preQualifier.qualifyPartialRow(baseTableContainerName, indexName, "LOCAL", null, null, constantOverhead)) continue;
            if (!this.isForInternalUse && this.traceOutput) {
                SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Estimating Index Entry Size/Value Size for " + index));
            }
            ConcurrentSkipListMap<Object, Object> localIndex = index.getSkipListMap();
            Set entrySet = localIndex.entrySet();
            Iterator entryIter = entrySet.iterator();
            boolean agentAttached = SIZE_OF_UTIL.isAgentAttached();
            long[] entryOverhead = localIndex.estimateMemoryOverhead(entrySet, (SingleObjectSizer)SIZE_OF_UTIL, this.traceVerbose);
            if (this.traceOutput && entryOverhead != null) {
                SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Index Entry Overhead of " + index + " " + Arrays.toString(entryOverhead)));
            }
            assert (entryOverhead == null || entryOverhead.length == 3);
            long keySize = 0L;
            long valSize = 0L;
            long valOffheapSize = 0L;
            long rowCount = 0L;
            long keyInMemoryCount = 0L;
            long valInMemoryCount = 0L;
            long valOffheapCount = 0L;
            long ccikSize = -1L;
            long byteArraySize = -1L;
            long rlArraySize = -1L;
            while (entryIter.hasNext()) {
                ++rowCount;
                Map.Entry entry = (Map.Entry)entryIter.next();
                Object k = entry.getKey();
                if (k instanceof CompactCompositeIndexKey) {
                    byte[] keyBytes;
                    if (ccikSize < 0L) {
                        ccikSize = SIZE_OF_UTIL.sizeof(k);
                    }
                    if ((keyBytes = ((CompactCompositeIndexKey)k).getKeyBytes()) != null) {
                        if (byteArraySize < 0L) {
                            byteArraySize = SIZE_OF_UTIL.sizeof(keyBytes);
                        }
                        ++keyInMemoryCount;
                        keySize += (long)keyBytes.length;
                        keySize += byteArraySize;
                    }
                } else if (k instanceof DataValueDescriptor) {
                    keySize += SIZE_OF_UTIL.sizeof(k);
                }
                if (this.traceOutput) {
                    SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Index Key Size of " + index + " " + keySize));
                }
                Object v = entry.getValue();
                valSize += SZ_REF;
                if (agentAttached) {
                    valSize += this.sizeOfObject(v, new Exclusions(this){

                        @Override
                        boolean shallExclude(ClassTraverser c) {
                            if (super.shallExclude(c)) {
                                return true;
                            }
                            return c.member instanceof RowLocation;
                        }
                    });
                } else if (v != null) {
                    Class<?> valClass = v.getClass();
                    if (valClass == RowLocation[].class) {
                        if (rlArraySize < 0L) {
                            rlArraySize = SIZE_OF_UTIL.sizeof(v);
                        }
                        valSize += rlArraySize;
                        valSize += (long)((RowLocation[])v).length * SZ_REF;
                    } else if (valClass == ConcurrentTHashSet.class) {
                        valSize += ((ConcurrentTHashSet)v).estimateMemoryOverhead((SingleObjectSizer)SIZE_OF_UTIL);
                    }
                }
                if (!this.traceOutput) continue;
                SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Index Value Size of " + index + " " + valSize));
            }
            retEstimates.put(baseTableContainerName + this.keyDelimeter + indexName + this.keyDelimeter + "LOCAL", new Object[]{new long[]{constantOverhead, entryOverhead[0] + entryOverhead[1], keySize, valSize, valOffheapSize, rowCount, keyInMemoryCount, 0L, 0L}});
        }
    }

    private void determineRegionMemoryFootPrint(GemFireContainer c, String baseTableContainerName, LinkedHashMap<String, Object[]> retEstimates, PreQualifier preQualifier) throws IllegalArgumentException, IllegalAccessException, InterruptedException, StandardException {
        if (preQualifier != null && !preQualifier.qualifyPartialRow(c.getQualifiedTableName(), null, null, null, null, 0L)) {
            return;
        }
        if (!this.isForInternalUse) {
            SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Determining memory footprint for " + c));
        }
        LocalRegion root = c.getRegion();
        Exclusions regionExclusions = new Exclusions(this, (Region)root, c){
            private final String regionInFocus;
            private final GemFireContainer containerInFocus;
            final /* synthetic */ Region val$root;
            final /* synthetic */ GemFireContainer val$c;
            {
                this.val$root = region;
                this.val$c = gemFireContainer;
                this.regionInFocus = this.val$root.getFullPath();
                this.containerInFocus = this.val$c;
            }

            @Override
            public boolean shallExclude(ClassTraverser c) {
                if (super.shallExclude(c)) {
                    return true;
                }
                if (c.member instanceof GemFireContainer) {
                    return !this.containerInFocus.equals(c.member);
                }
                if (c.member instanceof Region) {
                    return !((Exclusions)this).regionNameCheck(this.regionInFocus, ((Region)c.member).getFullPath());
                }
                if (c.member instanceof Bucket) {
                    return !((Exclusions)this).regionNameCheck(this.regionInFocus, ((Bucket)c.member).getPartitionedRegion().getFullPath());
                }
                if (c.member instanceof DistributionAdvisor) {
                    return !((Exclusions)this).regionNameCheck(this.regionInFocus, ((DistributionAdvisor)c.member).getAdvisee().getFullPath());
                }
                if (c.member instanceof ProxyBucketRegion) {
                    return !((Exclusions)this).regionNameCheck(this.regionInFocus, ((ProxyBucketRegion)c.member).getBucketAdvisor().getAdvisee().getFullPath());
                }
                return c.member instanceof GfxdIndexManager;
            }
        };
        long totalFootprint = this.startEstimation(c, regionExclusions);
        SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer:  Total Footprint for " + c + " " + totalFootprint));
        if (retEstimates != null) {
            retEstimates.put(baseTableContainerName + " (gemfirexd,gemfire,others) ", new Object[]{this.getSizes()});
        }
    }

    private void determineIndexMemoryFootPrint(String containerName, List<GemFireContainer> indexes, LinkedHashMap<String, Object[]> retEstimates, PreQualifier preQualifier) throws IllegalArgumentException, IllegalAccessException, InterruptedException, StandardException {
        for (GemFireContainer index : indexes) {
            if (preQualifier != null && !preQualifier.qualifyPartialRow(containerName, index.getTableName(), "LOCAL", null, null, 0L)) continue;
            if (!this.isForInternalUse) {
                SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Determining memory footprint for " + index));
            }
            this.estimateIndexFootPrint(index);
            long[] sizes = this.getSizes();
            retEstimates.put(Misc.getFullTableName(containerName, index.getTableName(), null) + " (gemfirexd,gemfire,others) ", new Object[]{sizes});
        }
    }

    private void estimateIndexFootPrint(final GemFireContainer index) throws IllegalArgumentException, IllegalAccessException, InterruptedException {
        Exclusions indexExclusions = new Exclusions(this){
            private final GemFireContainer indexInFocus;
            {
                this.indexInFocus = index;
            }

            @Override
            public boolean shallExclude(ClassTraverser c) {
                if (super.shallExclude(c)) {
                    return true;
                }
                if (c.member instanceof Region) {
                    return true;
                }
                if (!ObjectSizer.this.initializeMode && c.member instanceof DistributionAdvisee) {
                    return true;
                }
                if (c.member instanceof GemFireContainer) {
                    return c.member != this.indexInFocus;
                }
                return false;
            }
        };
        long totalFootprint = this.startEstimation(index, indexExclusions);
        if (!this.isForInternalUse) {
            SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer:  Total Footprint for " + index + " " + totalFootprint));
        }
    }

    private long[] getSizes() throws InterruptedException {
        long[] sz = new long[]{this.gemfirexdSize, this.gfeSize, this.othersSize};
        this.clearSizing();
        return sz;
    }

    private void clearSizing() {
        this.gemfirexdSize = 0L;
        this.gfeSize = 0L;
        this.othersSize = 0L;
    }

    private void reset(boolean clearSeenList) {
        this.clearSizing();
        this.classBreakup.clear();
        if (clearSeenList) {
            this.seen.clear();
        }
    }

    @SuppressWarnings(value={"DM_GC"})
    private void cleanupGarbage() {
        if (!this.withMemoryFootPrint) {
            return;
        }
        runtime.gc();
        runtime.runFinalization();
    }

    private long startEstimation(Object root, Exclusions exclusions) throws IllegalArgumentException, IllegalAccessException, InterruptedException {
        long size = 0L;
        this.searchAndEstimate(null, root, exclusions);
        if (this.traceOutput) {
            SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer: Object sizes after root " + this.gemfirexdSize + "/" + this.gfeSize + "/" + this.othersSize + " = " + (this.gemfirexdSize + this.gfeSize + this.othersSize)));
        }
        ClassTraverser rootC = this.sink.peek();
        while (!this.sink.isEmpty()) {
            ClassTraverser c = this.sink.poll();
            if (c == null) continue;
            this.report(c);
            while (c.moveNext()) {
                this.searchAndEstimate(c, c.currentMemberFieldValue(), exclusions);
            }
        }
        if (this.sink.size() != 0) {
            throw new AssertionError((Object)"not all objects got consumed");
        }
        LocalRegion r = null;
        if ((root instanceof GemFireContainer && ((r = ((GemFireContainer)root).getRegion()) != null && !r.getFullPath().contains("/SYS") || r == null && ((GemFireContainer)root).getBaseId() != null) || !(root instanceof GemFireContainer)) && rootC != null) {
            LogWriter logger = Misc.getCacheLogWriter();
            StringBuilder sb = rootC.getTopConsumers();
            if (sb != null) {
                logger.info(sb.toString());
            }
        }
        size = this.gemfirexdSize + this.gfeSize + this.othersSize;
        return size;
    }

    private void report(ClassTraverser c) throws IllegalArgumentException, IllegalAccessException {
        if (!this.logObjectGraph) {
            return;
        }
        LogWriter logger = Misc.getCacheLogWriter();
        StringBuilder sb = c.getStack("");
        if (sb == null) {
            return;
        }
        String msg = sb.append("===== EOF ======").toString();
        logger.info(msg);
        System.out.println(msg);
        msg = null;
    }

    private void searchAndEstimate(ClassTraverser currentContext, Object member, Exclusions exclusions) throws IllegalArgumentException, IllegalAccessException {
        if (member == null) {
            return;
        }
        ClassTraverser c = this.createInstance(currentContext, member);
        if (exclusions.shallExclude(c)) {
            if (this.traceOutput) {
                SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer:  Excluding " + c.member));
            }
            return;
        }
        if (!c.seeAndEstimate(null)) {
            if (this.traceOutput) {
                SanityManager.DEBUG_PRINT((String)"TRACE", (String)("objectsizer:  Excluding Members of " + c.member));
            }
            return;
        }
        this.sink.offer(c);
        for (Class<?> clazz = member.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Class<?> fieldType = field.getType();
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers())) {
                    c.seeAndEstimate(fieldType);
                    continue;
                }
                if (fieldType.isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
                c.addField(field);
            }
        }
    }

    public ClassTraverser createInstance(ClassTraverser parent, Object member) {
        return new ClassTraverser(parent, parent != null ? parent.fieldIndex : -1, member);
    }

    private class ClassTraverser {
        private final ArrayList<Field> fields = new ArrayList();
        private int fieldIndex = -1;
        private final Object member;
        private ClassTraverser parentContext = null;
        private int parentFieldIndex = -1;
        private static final int TOP_CONSUMER_COUNT = 20;
        private static final int NUM_STACK_COUNT = 10;
        private int arrayLength = -1;
        private int arrayIndex = -2;

        ClassTraverser(ClassTraverser parent, int parentFieldIndex, Object member) {
            this.parentContext = parent;
            this.member = member;
            this.parentFieldIndex = parentFieldIndex;
        }

        public void addField(Field f) {
            this.fields.add(f);
        }

        public StringBuilder getStack(String defaultIndentation) throws IllegalArgumentException, IllegalAccessException {
            if (this.arrayLength != -1 && this.arrayIndex > 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder(defaultIndentation + "Stack of ");
            this.getStack(sb, 0, defaultIndentation);
            return sb;
        }

        public StringBuilder getTopConsumers() throws IllegalArgumentException, IllegalAccessException {
            if (!ObjectSizer.this.logTopConsumers) {
                ObjectSizer.this.classBreakup.clear();
                return null;
            }
            StringBuilder sb = new StringBuilder("Top Consumers for ").append(this.member).append(" with gemfirexd/gemfire/other sizes: ").append(ObjectSizer.this.gemfirexdSize).append("/").append(ObjectSizer.this.gfeSize).append("/").append(ObjectSizer.this.othersSize);
            Pair[] entries = ObjectSizer.this.classBreakup.values().toArray(new Pair[1]);
            Arrays.sort(entries, new Comparator<Pair>(){

                @Override
                public int compare(Pair o1, Pair o2) {
                    return o1.memSize < o2.memSize ? 1 : (o1.memSize > o2.memSize ? -1 : 0);
                }
            });
            int i = 0;
            for (Pair entry : entries) {
                if (entry == null) continue;
                sb.append("\n").append(entry.clazz).append("  ").append(entry.memSize).append(" (").append(entry.referencePaths.size()).append(")");
                HashMap<String, Integer> reportStack = new HashMap<String, Integer>();
                if (i++ > 20) continue;
                ClassTraverser[] allocations = entry.referencePaths.toArray(new ClassTraverser[1]);
                Arrays.sort(allocations, new Comparator<ClassTraverser>(){

                    @Override
                    public int compare(ClassTraverser o1, ClassTraverser o2) {
                        long o2size;
                        long o1size = SIZE_OF_UTIL.sizeof(o1.member);
                        return o1size < (o2size = SIZE_OF_UTIL.sizeof(o2.member)) ? 1 : (o1size > o2size ? -1 : 0);
                    }
                });
                for (ClassTraverser ct : allocations) {
                    StringBuilder currentStack = ct.getStack("\t");
                    String searchStack = currentStack.toString().replaceAll("(?m)(.*)@.*\\) ", "$1) ");
                    Integer repeatCount = (Integer)reportStack.get(searchStack);
                    if (repeatCount != null) {
                        reportStack.put(searchStack, repeatCount + 1);
                        continue;
                    }
                    if (reportStack.size() > 10) break;
                    reportStack.put(searchStack, 1);
                }
                for (Map.Entry entry2 : reportStack.entrySet()) {
                    sb.append("\n\t(").append(((Integer)entry2.getValue()).longValue()).append(") ").append(((String)entry2.getKey()).toString());
                }
            }
            ObjectSizer.this.classBreakup.clear();
            return sb;
        }

        private boolean seeAndEstimate(Class<?> memberClass) {
            if (memberClass == null) {
                return this.estimate(this.member, this.member.getClass());
            }
            return this.estimate(memberClass, memberClass);
        }

        private String getCanonicalName(Class<?> c) {
            try {
                return c.getCanonicalName();
            }
            catch (IncompatibleClassChangeError ignore) {
                return null;
            }
        }

        private product addTo(Class<?> objectClass) {
            String clName = this.getCanonicalName(objectClass);
            if (clName == null) {
                clName = objectClass.getName();
            }
            if (clName.indexOf("com.pivotal.gemfirexd") >= 0) {
                return product.GEMFIREXD;
            }
            if (clName.indexOf("com.gemstone.gemfire") >= 0) {
                return product.GFE;
            }
            return product.OTHER;
        }

        private long sizeOf(Object obj2estimate) {
            boolean isVisited = ObjectSizer.this.initialset.containsKey(obj2estimate);
            boolean isSeen = ObjectSizer.this.seen.containsKey(obj2estimate);
            if (isVisited && isSeen) {
                if (Region.class.isInstance(obj2estimate) && "/__PR".equals(((Region)obj2estimate).getFullPath())) {
                    return SZ_REF;
                }
                if (PartitionedRegionDataStore.class.isInstance(obj2estimate)) {
                    return SZ_REF;
                }
                if (ConcurrentHashMap.class.isInstance(obj2estimate)) {
                    Field f;
                    Field field = f = this.parentContext != null ? this.parentContext.mappingField(this.parentFieldIndex) : null;
                    if (f != null && f.getName().contains("localBucket2RegionMap")) {
                        return SZ_REF;
                    }
                }
            }
            boolean bl = isSeen = isVisited || isSeen;
            if (isSeen) {
                return -SZ_REF;
            }
            if (obj2estimate instanceof CompactCompositeKey) {
                byte[] key = ((CompactCompositeKey)obj2estimate).getKeyBytes();
                long sz = 0L;
                if (key != null) {
                    sz = key.length;
                }
                ObjectSizer.this.seen.put(obj2estimate, null);
                return -(sz += SIZE_OF_UTIL.sizeof(obj2estimate));
            }
            if (obj2estimate instanceof byte[][]) {
                long sz = SIZE_OF_UTIL.sizeof(obj2estimate);
                for (byte[] b : (byte[][])obj2estimate) {
                    sz += SIZE_OF_UTIL.sizeof(b);
                }
                return sz;
            }
            return SIZE_OF_UTIL.sizeof(obj2estimate);
        }

        private boolean estimate(Object obj2estimate, Class<?> objectClass) {
            long objectsize = this.sizeOf(obj2estimate);
            boolean isSeen = false;
            if (objectsize < 0L) {
                objectsize = -objectsize;
                isSeen = true;
            } else if (obj2estimate.getClass().isPrimitive()) {
                isSeen = true;
            }
            if (!isSeen) {
                product type = this.addTo(objectClass);
                if (type == product.GEMFIREXD) {
                    ObjectSizer objectSizer = ObjectSizer.this;
                    objectSizer.gemfirexdSize = objectSizer.gemfirexdSize + objectsize;
                } else if (type == product.GFE) {
                    ObjectSizer objectSizer = ObjectSizer.this;
                    objectSizer.gfeSize = objectSizer.gfeSize + objectsize;
                } else {
                    ObjectSizer objectSizer = ObjectSizer.this;
                    objectSizer.othersSize = objectSizer.othersSize + objectsize;
                }
                if (!isSeen) {
                    if (ObjectSizer.this.initializeMode) {
                        ObjectSizer.this.initialset.put(obj2estimate, null);
                    } else {
                        ObjectSizer.this.seen.put(obj2estimate, null);
                    }
                }
            }
            if (ObjectSizer.this.logTopConsumers) {
                Pair p = (Pair)ObjectSizer.this.classBreakup.get(objectClass);
                if (p == null) {
                    p = new Pair();
                    p.referencePaths = new ArrayList();
                    p.clazz = objectClass;
                    ObjectSizer.this.classBreakup.put(objectClass, p);
                }
                p.memSize += SIZE_OF_UTIL.sizeof(obj2estimate);
                p.referencePaths.add(this);
            }
            return !isSeen;
        }

        private void getStack(StringBuilder sb, int indent, String defaultIndentation) throws IllegalArgumentException, IllegalAccessException {
            StringBuilder tabs = new StringBuilder(defaultIndentation + "\t");
            for (int i = indent; i > 0; --i) {
                tabs.append("\t");
            }
            String className = this.getCanonicalName(this.member.getClass());
            sb.append((CharSequence)tabs);
            if (this.member instanceof Region) {
                Region region = (Region)this.member;
                sb.append(region.getClass().getSimpleName()).append(" (").append(region.getFullPath()).append(" )");
            } else if (this.member instanceof GemFireContainer) {
                GemFireContainer container = (GemFireContainer)this.member;
                sb.append(container.getClass().getSimpleName()).append(" (").append(container.getQualifiedTableName()).append(" )");
            } else if (this.member instanceof Field) {
                Field f = (Field)this.member;
                String valueType = this.member.getClass().getSimpleName();
                sb.append(f.getDeclaringClass().getSimpleName()).append(":").append(f.getType().getSimpleName()).append("(").append(valueType).append("@").append(Integer.toHexString(System.identityHashCode(this.member))).append(") -> ").append(f.getName());
            } else {
                sb.append(className);
            }
            this.reportSizes(sb, this.member).append("\n");
            if (defaultIndentation.length() == 0) {
                tabs.append("\t");
                long fieldSizes = 0L;
                for (Field f : this.fields) {
                    sb.append((CharSequence)tabs);
                    Object value = f.get(this.member);
                    String valueType = value == null ? "NULL" : value.getClass().getSimpleName();
                    sb.append(f.getDeclaringClass().getSimpleName()).append(":").append(f.getType().getSimpleName()).append("(").append(valueType).append("@").append(Integer.toHexString(System.identityHashCode(value))).append(") -> ").append(f.getName());
                    if (!(!Modifier.isStatic(f.getModifiers()) || ObjectSizer.this.initialset.containsKey(value) && ObjectSizer.this.seen.containsKey(value))) {
                        fieldSizes += SIZE_OF_UTIL.sizeof(f.getType());
                        sb.append(" :: ").append(SIZE_OF_UTIL.sizeof(f.getType()));
                    }
                    sb.append("\n");
                }
                sb.append((CharSequence)tabs).append(" ~ all fields size to ").append(fieldSizes).append("\n");
            }
            ClassTraverser pc = this.parentContext;
            int pfi = this.parentFieldIndex;
            Field[] lastFewFrames = new Field[5];
            int skipFramesCounter = 0;
            while (pc != null) {
                Field f = pc.fields.get(pfi);
                if (!this.lastFewFramesSame(lastFewFrames, f)) {
                    tabs.append("\t");
                    sb.append((CharSequence)tabs);
                    f.setAccessible(true);
                    Object value = f.get(pc.member);
                    Object object = value = value == null ? "null" : value;
                    if (skipFramesCounter != 0) {
                        sb.append("... skipped ").append(skipFramesCounter).append(" similar frames ... ").append("\n").append((CharSequence)tabs);
                        skipFramesCounter = 0;
                    }
                    sb.append(f.getDeclaringClass().getSimpleName());
                    if (pc.member instanceof Region) {
                        sb.append("(").append(((Region)pc.member).getFullPath()).append(")");
                    }
                    String valueType = value == null ? "NULL" : value.getClass().getSimpleName();
                    sb.append(":").append(f.getType().getSimpleName()).append("(").append(valueType).append("@").append(Integer.toHexString(System.identityHashCode(value))).append(") -> ").append(f.getName());
                    sb.append(" :: ").append(SIZE_OF_UTIL.sizeof(value)).append("\n");
                } else {
                    ++skipFramesCounter;
                }
                pfi = pc.parentFieldIndex;
                pc = pc.parentContext;
            }
            tabs = null;
        }

        private StringBuilder reportSizes(StringBuilder sb, Object value) {
            sb.append(" :: ").append(SIZE_OF_UTIL.sizeof(value)).append("  ::  ");
            return sb;
        }

        private boolean lastFewFramesSame(Field[] stack, Field current) {
            boolean lastTwoFramesSame = true;
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i] == null) {
                    stack[i] = current;
                    lastTwoFramesSame = false;
                    break;
                }
                if (!stack[0].getDeclaringClass().equals(current.getDeclaringClass()) || !stack[0].getType().equals(current.getType())) {
                    lastTwoFramesSame = false;
                }
                if (i + 1 >= stack.length) {
                    stack[i] = current;
                    continue;
                }
                if (stack[i + 1] == null) continue;
                stack[i] = stack[i + 1];
            }
            return lastTwoFramesSame;
        }

        public boolean moveNext() {
            if (this.arrayLength != -1) {
                if (++this.arrayIndex >= this.arrayLength) {
                    this.arrayLength = -1;
                    this.arrayIndex = -1;
                } else {
                    return true;
                }
            }
            return ++this.fieldIndex < this.fields.size();
        }

        private Field mappingField(int fldindex) {
            if (fldindex < 0 || fldindex >= this.fields.size()) {
                return null;
            }
            return this.fields.get(fldindex);
        }

        public Object currentMemberFieldValue() throws IllegalArgumentException, IllegalAccessException {
            Object value = null;
            if (this.fieldIndex >= this.fields.size()) {
                return null;
            }
            Field f = this.fields.get(this.fieldIndex);
            Class<?> clazz = f.getType();
            Class<?> componentType = clazz.getComponentType();
            if (clazz.isArray() && !componentType.isPrimitive()) {
                Object valarray = f.get(this.member);
                if (valarray == null) {
                    return null;
                }
                if (this.arrayLength == -1) {
                    this.arrayLength = Array.getLength(valarray);
                    value = valarray;
                }
                if (value == null) {
                    if (++this.arrayIndex < this.arrayLength) {
                        value = Array.get(valarray, this.arrayIndex);
                    } else {
                        this.arrayLength = -1;
                        this.arrayIndex = -2;
                    }
                }
            } else {
                value = f.get(this.member);
            }
            return value;
        }
    }

    static enum product {
        GEMFIREXD,
        GFE,
        OTHER;

    }

    private static class Pair {
        long memSize = 0L;
        ArrayList<ClassTraverser> referencePaths;
        Class<?> clazz;

        private Pair() {
        }
    }

    class Exclusions {
        Exclusions() {
        }

        boolean shallExclude(ClassTraverser c) {
            if (c.parentContext == null) {
                return false;
            }
            if (c.member == null) {
                return true;
            }
            if (c.member instanceof WeakReference && c.member instanceof SoftReference) {
                return true;
            }
            if (c.member instanceof ClassLoader && c.parentContext != null && c.parentContext.member instanceof Thread) {
                return true;
            }
            if (c.member instanceof InternalResourceManager) {
                return true;
            }
            if (c.member instanceof InternalDistributedSystem) {
                return true;
            }
            if (c.member instanceof DistributedLockService) {
                return true;
            }
            if (c.member instanceof GfxdDataDictionary) {
                return true;
            }
            if (c.member instanceof ContextManager) {
                return true;
            }
            if (c.member instanceof GemFireCacheImpl) {
                return true;
            }
            if (c.member instanceof GemFireStore) {
                return true;
            }
            if (c.member instanceof FabricDatabase) {
                return true;
            }
            return !ObjectSizer.this.initializeMode && c.member instanceof Connection;
        }

        private boolean regionNameCheck(String targetRegion, String currRegion) {
            return currRegion.equals(targetRegion) || currRegion.contains(targetRegion.replaceAll("/", "_"));
        }
    }

    public static interface PreQualifier {
        public boolean qualifyPartialRow(String var1, String var2, String var3, String var4, String var5, long var6) throws StandardException;
    }
}

