/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.planexporter;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.AbstractOperationMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessageProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.tools.planexporter.AccessDistributedSystem;
import com.pivotal.gemfirexd.tools.planexporter.CreateXML;
import java.io.CharArrayWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ExecutionPlanMessage
extends GfxdMessage {
    private String schema;
    private String stmtUUID;
    private XPLAINUtil.XMLForms xmlForm;
    private String embedXslFileName;
    private final ExecutionPlanMessageCollector replyProcessor;
    private final List<char[]> plans = Collections.synchronizedList(new ArrayList());

    public ExecutionPlanMessage() {
        this.replyProcessor = null;
    }

    public ExecutionPlanMessage(String schema, String stmtUUID, XPLAINUtil.XMLForms xmlForm, String embedXslFileName, InternalDistributedSystem dm, Set<DistributedMember> members) {
        this.schema = schema;
        this.stmtUUID = stmtUUID;
        this.xmlForm = xmlForm;
        this.embedXslFileName = embedXslFileName;
        this.replyProcessor = new ExecutionPlanMessageCollector(dm, members);
        this.setProcessorId(this.replyProcessor.getProcessorId());
        this.setRecipients(members);
    }

    public GfxdReplyMessageProcessor getReplyProcessor() {
        return this.replyProcessor;
    }

    public List<char[]> getResults() {
        return this.plans;
    }

    public final void addResult(char[] c) {
        this.plans.add(c);
    }

    @Override
    public byte getGfxdID() {
        return 33;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.schema, (DataOutput)out);
        DataSerializer.writeString((String)this.stmtUUID, (DataOutput)out);
        DataSerializer.writeInteger((Integer)this.xmlForm.ordinal(), (DataOutput)out);
        DataSerializer.writeString((String)this.embedXslFileName, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.schema = DataSerializer.readString((DataInput)in);
        this.stmtUUID = DataSerializer.readString((DataInput)in);
        this.xmlForm = XPLAINUtil.XMLForms.values()[DataSerializer.readInteger((DataInput)in)];
        this.embedXslFileName = DataSerializer.readString((DataInput)in);
    }

    @Override
    protected void processMessage(DistributionManager dm) throws GemFireCheckedException {
        EmbedConnection conn = null;
        boolean contextSet = false;
        CharArrayWriter cwriter = new CharArrayWriter();
        try {
            conn = GemFireXDUtils.getTSSConnection(true, true, true);
            conn.getTR().setupContextStack();
            contextSet = true;
            AccessDistributedSystem ds = new AccessDistributedSystem(conn, this.schema, this.stmtUUID, null);
            new CreateXML(ds, true, this.xmlForm, this.embedXslFileName).processPlan(cwriter, false);
            ExecutionPlanReplyMessage replyMsg = new ExecutionPlanReplyMessage(cwriter);
            replyMsg.setRecipient(this.sender);
            replyMsg.setProcessorId(this.getProcessorId());
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("sending plan to " + Arrays.toString(replyMsg.getRecipients()) + " as " + cwriter.toString()));
            }
            dm.putOutgoing((DistributionMessage)replyMsg);
        }
        catch (StandardException ex) {
            throw new ReplyException("ExecutionPlanMessage: Unexpected StandardException on member " + dm.getDistributionManagerId(), (Throwable)ex);
        }
        catch (SQLException ex) {
            throw new ReplyException("ExecutionPlanMessage: Unexpected SQLException on member " + dm.getDistributionManagerId(), (Throwable)ex);
        }
        catch (IOException ioe) {
            throw new ReplyException("ExecutionPlanMessage: Unexpected IOException on member " + dm.getDistributionManagerId(), (Throwable)ioe);
        }
        finally {
            if (contextSet) {
                conn.getTR().restoreContextStack();
            }
            cwriter.close();
        }
    }

    @Override
    protected boolean waitForNodeInitialization() {
        return true;
    }

    @Override
    protected void sendReply(ReplyException ex, DistributionManager dm) {
        if (ex == null) {
            return;
        }
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)(" Raising exception from " + dm + " processorId=" + this.processorId + " recipient " + this.getSender() + " for " + this.stmtUUID + " exception = " + ex), (Throwable)ex);
        }
        ReplyMessage.send((InternalDistributedMember)this.getSender(), (int)this.processorId, (ReplyException)ex, (ReplySender)dm, (AbstractOperationMessage)this);
    }

    public static class ExecutionPlanReplyMessage
    extends GfxdReplyMessage {
        private char[] plan;

        public ExecutionPlanReplyMessage() {
        }

        protected ExecutionPlanReplyMessage(CharArrayWriter writer) {
            this.plan = writer.toCharArray();
        }

        @Override
        public GfxdResponseCode getResponseCode() {
            return null;
        }

        @Override
        public byte getGfxdID() {
            return 34;
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.plan = DataSerializer.readCharArray((DataInput)in);
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeCharArray((char[])this.plan, (DataOutput)out);
        }
    }

    public class ExecutionPlanMessageCollector
    extends GfxdReplyMessageProcessor {
        public ExecutionPlanMessageCollector(InternalDistributedSystem ds, Set<DistributedMember> initMembers) {
            super(ds.getDistributionManager(), initMembers, true);
        }

        public final void process(DistributionMessage msg) {
            try {
                if (msg instanceof ExecutionPlanReplyMessage) {
                    char[] p = ((ExecutionPlanReplyMessage)msg).plan;
                    if (p == null || p.length == 0) {
                        if (GemFireXDUtils.TracePlanGeneration) {
                            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)(" NO result from " + msg.getSender() + " processorId=" + msg.getProcessorId() + " received for " + ExecutionPlanMessage.this.stmtUUID));
                        }
                        return;
                    }
                    if (GemFireXDUtils.TracePlanGeneration) {
                        SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)(" adding remote result from " + msg.getSender() + " processorId=" + msg.getProcessorId() + " for " + ExecutionPlanMessage.this.stmtUUID + " with " + String.valueOf(p)));
                    }
                    ExecutionPlanMessage.this.addResult(p);
                }
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        protected Set<DistributedMember> virtualReset() {
            return null;
        }
    }
}

